/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.DocBaseNodeFactory;
import org.netbeans.modules.web.project.ui.WebLogicalViewProvider;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class ConfFilesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        WebProject webProject = (WebProject)project.getLookup().lookup(WebProject.class);
        assert (webProject != null);
        return new ConfFilesNodeList(webProject);
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    private static final class ConfFilesChildren
    extends Children.Keys {
        private static final String[] wellKnownFiles = new String[]{"web.xml", "webservices.xml", "struts-config.xml", "faces-config.xml", "portlet.xml", "navigator.xml", "managed-beans.xml"};
        private final ProjectWebModule pwm;
        private final HashSet keys;
        private final Comparator comparator = new NodeComparator();
        private FileObject confDir;
        private final FileChangeListener webInfListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                if (ConfFilesChildren.this.isWellKnownFile(fileEvent.getFile().getNameExt())) {
                    ConfFilesChildren.this.addKey(fileEvent.getFile());
                }
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                if (ConfFilesChildren.this.keys.contains(fileRenameEvent.getFile())) {
                    if (!ConfFilesChildren.this.isWellKnownFile(fileRenameEvent.getFile().getNameExt())) {
                        ConfFilesChildren.this.removeKey(fileRenameEvent.getFile());
                    } else {
                        ConfFilesChildren.this.doSetKeys();
                    }
                } else if (ConfFilesChildren.this.isWellKnownFile(fileRenameEvent.getFile().getNameExt())) {
                    ConfFilesChildren.this.addKey(fileRenameEvent.getFile());
                }
            }

            public void fileDeleted(FileEvent fileEvent) {
                if (ConfFilesChildren.this.isWellKnownFile(fileEvent.getFile().getNameExt())) {
                    ConfFilesChildren.this.removeKey(fileEvent.getFile());
                }
            }
        };
        private final FileChangeListener anyFileListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                ConfFilesChildren.this.addKey(fileEvent.getFile());
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                ConfFilesChildren.this.addKey(fileEvent.getFile());
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                ConfFilesChildren.this.addKey(fileRenameEvent.getFile());
            }

            public void fileDeleted(FileEvent fileEvent) {
                ConfFilesChildren.this.removeKey(fileEvent.getFile());
            }
        };
        private final ConfigurationFilesListener serverSpecificFilesListener = new ConfigurationFilesListener(){

            public void fileCreated(FileObject fileObject) {
                ConfFilesChildren.this.addKey(fileObject);
            }

            public void fileDeleted(FileObject fileObject) {
                ConfFilesChildren.this.removeKey(fileObject);
            }
        };

        private ConfFilesChildren(ProjectWebModule projectWebModule) {
            this.pwm = projectWebModule;
            this.keys = new HashSet();
        }

        public static Children forProject(Project project) {
            ProjectWebModule projectWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
            return new ConfFilesChildren(projectWebModule);
        }

        protected void addNotify() {
            this.createKeys();
            this.doSetKeys();
        }

        protected void removeNotify() {
            this.removeListeners();
        }

        public Node[] createNodes(Object object) {
            Node[] nodeArray;
            Node node = null;
            if (this.keys.contains(object)) {
                FileObject fileObject = (FileObject)object;
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    node = dataObject.getNodeDelegate().cloneNode();
                    if (fileObject.isFolder()) {
                        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                        node = new FilterNode(node, dataFolder.createNodeChildren((DataFilter)new DocBaseNodeFactory.VisibilityQueryDataFilter(null)));
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            if (node == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = node;
            }
            return nodeArray;
        }

        public synchronized void refreshNodes() {
            this.addNotify();
        }

        private synchronized void addKey(FileObject fileObject) {
            if (VisibilityQuery.getDefault().isVisible(fileObject)) {
                this.keys.add(fileObject);
                this.doSetKeys();
            }
        }

        private synchronized void removeKey(FileObject fileObject) {
            this.keys.remove(fileObject);
            this.doSetKeys();
        }

        private synchronized void createKeys() {
            this.keys.clear();
            this.addWellKnownFiles();
            this.addConfDirectoryFiles();
            this.addServerSpecificFiles();
            this.addFrameworkFiles();
        }

        private void doSetKeys() {
            final Object[] objectArray = this.keys.toArray();
            Arrays.sort(objectArray, this.comparator);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfFilesChildren.this.setKeys(objectArray);
                }
            });
        }

        private void addWellKnownFiles() {
            FileObject fileObject = this.pwm.getWebInf(true);
            if (fileObject == null) {
                return;
            }
            for (int i = 0; i < wellKnownFiles.length; ++i) {
                FileObject fileObject2 = fileObject.getFileObject(wellKnownFiles[i]);
                if (fileObject2 == null) continue;
                this.keys.add(fileObject2);
            }
            fileObject.addFileChangeListener(this.webInfListener);
        }

        private void addConfDirectoryFiles() {
            this.confDir = this.pwm.getConfDir();
            if (this.confDir == null) {
                return;
            }
            FileObject[] fileObjectArray = this.confDir.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
                this.keys.add(fileObjectArray[i]);
            }
            this.confDir.addFileChangeListener(this.anyFileListener);
        }

        private void addServerSpecificFiles() {
            FileObject[] fileObjectArray = this.pwm.getConfigurationFiles();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                this.keys.add(fileObjectArray[i]);
            }
            this.pwm.addConfigurationFilesListener(this.serverSpecificFilesListener);
        }

        private void addFrameworkFiles() {
            List list = WebFrameworks.getFrameworks();
            for (int i = 0; i < list.size(); ++i) {
                WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)list.get(i);
                FileObject fileObject = this.pwm.getDocumentBase();
                File[] fileArray = null;
                if (fileObject != null) {
                    fileArray = webFrameworkProvider.getConfigurationFiles(WebModule.getWebModule((FileObject)fileObject));
                }
                if (fileArray == null) continue;
                for (int j = 0; j < fileArray.length; ++j) {
                    FileObject fileObject2 = FileUtil.toFileObject((File)fileArray[j]);
                    if (fileObject2 == null) continue;
                    this.keys.add(fileObject2);
                }
            }
        }

        private void removeListeners() {
            this.pwm.removeConfigurationFilesListener(this.serverSpecificFilesListener);
            FileObject fileObject = this.pwm.getWebInf(true);
            if (fileObject != null) {
                this.pwm.getWebInf().removeFileChangeListener(this.webInfListener);
            }
            if (this.confDir != null) {
                this.confDir.removeFileChangeListener(this.anyFileListener);
            }
        }

        private boolean isWellKnownFile(String string) {
            for (int i = 0; i < wellKnownFiles.length; ++i) {
                if (!string.equals(wellKnownFiles[i])) continue;
                return true;
            }
            return false;
        }

        private static final class NodeComparator
        implements Comparator {
            private NodeComparator() {
            }

            public int compare(Object object, Object object2) {
                FileObject fileObject = (FileObject)object;
                FileObject fileObject2 = (FileObject)object2;
                int n = this.compareType(fileObject, fileObject2);
                if (n == 0) {
                    n = this.compareNames(fileObject, fileObject2);
                }
                if (n == 0) {
                    return fileObject.getPath().compareTo(fileObject2.getPath());
                }
                return n;
            }

            private int compareType(FileObject fileObject, FileObject fileObject2) {
                int n = fileObject.isFolder() ? 0 : 1;
                int n2 = fileObject2.isFolder() ? 0 : 1;
                return n - n2;
            }

            private int compareNames(FileObject fileObject, FileObject fileObject2) {
                return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
            }

            public boolean equals(Object object) {
                return object instanceof NodeComparator;
            }
        }
    }

    private static final class ConfFilesNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private static final Image CONFIGURATION_FILES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/config-badge.gif", (boolean)true);
        private Set files;
        private Map fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock = new Object();
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map groupsListeners;
        private final Project project;
        private Node iconDelegate;

        public ConfFilesNode(Project project) {
            super(ConfFilesChildren.forProject(project), ConfFilesNodeFactory.createLookup(project));
            this.project = project;
            this.setName("configurationFiles");
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Image computeIcon(boolean bl, int n) {
            Image image = bl ? this.iconDelegate.getOpenedIcon(n) : this.iconDelegate.getIcon(n);
            image = Utilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
            return image;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ConfFilesNodeFactory.class, (String)"LBL_Node_Config");
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles(this.project);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(this.project);
        }

        protected void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private void setGroups(Collection collection) {
            if (this.groupsListeners != null) {
                for (Object object : this.groupsListeners.keySet()) {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.groupsListeners.get(object);
                    object.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.groupsListeners = new HashMap();
            HashSet hashSet = new HashSet();
            for (PropertyChangeListener propertyChangeListener : collection) {
                PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyChangeListener);
                this.groupsListeners.put(propertyChangeListener, propertyChangeListener2);
                propertyChangeListener.addPropertyChangeListener(propertyChangeListener2);
                FileObject fileObject = propertyChangeListener.getRootFolder();
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected void setFiles(Set set) {
            FileStatusListener fileStatusListener;
            Object object2;
            if (this.fileSystemListeners != null) {
                for (Object object2 : this.fileSystemListeners.keySet()) {
                    fileStatusListener = (FileStatusListener)this.fileSystemListeners.get(object2);
                    object2.removeFileStatusListener(fileStatusListener);
                }
            }
            this.fileSystemListeners = new HashMap();
            this.files = set;
            if (set == null) {
                return;
            }
            Iterator<Object> iterator = set.iterator();
            object2 = new HashSet();
            while (iterator.hasNext()) {
                fileStatusListener = (FileObject)iterator.next();
                try {
                    FileSystem fileSystem = fileStatusListener.getFileSystem();
                    if (object2.contains(fileSystem)) continue;
                    object2.add(fileSystem);
                    FileStatusListener fileStatusListener2 = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                    fileSystem.addFileStatusListener(fileStatusListener2);
                    this.fileSystemListeners.put(fileSystem, fileStatusListener2);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)fileStateInvalidException, (String)("Can not get " + fileStatusListener + " filesystem, ignoring...")));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfFilesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String CONF_FILES = "confFiles";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        ConfFilesNodeList(WebProject webProject) {
            this.project = webProject;
            WebLogicalViewProvider webLogicalViewProvider = (WebLogicalViewProvider)this.project.getLookup().lookup(WebLogicalViewProvider.class);
            assert (webLogicalViewProvider != null);
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CONF_FILES);
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(String string) {
            if (string == CONF_FILES) {
                return new ConfFilesNode(this.project);
            }
            assert (false) : "No node for key: " + string;
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfFilesNodeList.this.changeSupport.fireChange();
                }
            });
        }
    }
}

