/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.project.anttasks.OldProjectTransformer;
import org.netbeans.modules.xslt.project.anttasks.jbi.ServiceEntry;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.PartnerLinkTypeReference;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJBIGenerator {
    private Map<String, String> mNameSpacePrefix = new HashMap<String, String>();
    private String mSourceDirectory = null;
    private String mBuildDirectory = null;
    private Logger logger = Logger.getLogger(AbstractJBIGenerator.class.getName());
    private List<ServiceEntry> mProviders = new ArrayList<ServiceEntry>();
    private List<ServiceEntry> mConsumers = new ArrayList<ServiceEntry>();
    public static final String JBI_ELEM_NAME = "jbi";
    public static final String SERVICES_ELEM_NAME = "services";
    public static final String PROVIDES_ELEM_NAME = "provides";
    public static final String CONSUMES_ELEM_NAME = "consumes";
    public static final String BINDING_ATTR_NAME = "binding-component";
    public static final String INTERFACE_ATTR_NAME = "interface-name";
    public static final String ENDPOINT_ATTR_NAME = "endpoint-name";
    public static final String SERVICE_ATTR_NAME = "service-name";
    public static final String VERSION_ATTR_NAME = "version";
    public static final String VERSION_ATTR_VALUE = "1.0";
    public static final String NS_ATTR_NAME = "xmlns";
    public static final String NS_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi";
    public static final String NS_XSI_ATTR_NAME = "xmlns:xsi";
    public static final String NS_XSI_ATTR_VALUE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_ATTR_NAME = "xsi:schemaLocation";
    public static final String XSI_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi jbi.xsd";
    public static final String JBI_EXT_NS = "http://www.sun.com/jbi/descriptor/service-unit";
    public static final String JBI_EXT_DISPLAY_NAME = "display-name";
    public static final String JBI_EXT_PROC_NAME = "process-name";
    public static final String JBI_EXT_FILE_PATH = "file-path";
    public static final String NAMESPACE_PREFIX = "ns";
    public static final String COLON_SEPARATOR = ":";

    public AbstractJBIGenerator(String srcDir, String buildDir) {
        this.mSourceDirectory = srcDir;
        this.mBuildDirectory = buildDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public String getBuildDirectory() {
        return this.mBuildDirectory;
    }

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public String getSourceDirectory() {
        return this.mSourceDirectory;
    }

    public void generate() {
        if (this.mBuildDirectory == null || this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for build || source files.");
        }
        if (this.isOldProject()) {
            OldProjectTransformer oldProjectTransformer = new OldProjectTransformer(this.getSourceDirectory(), this.getBuildDirectory());
            oldProjectTransformer.execute();
        }
        this.populateNamespace(JBI_EXT_NS);
        this.process();
        try {
            this.generateJBIDescriptor();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private boolean isOldProject() {
        File tMapFile = this.getTransformmapFile();
        return tMapFile == null || !tMapFile.isFile();
    }

    protected abstract TMapModel getTMapModel();

    protected abstract <T extends ReferenceableWSDLComponent> T resolveReference(NamedComponentReference<T> var1);

    private void process() {
        TMapModel tMapModel = this.getTMapModel();
        try {
            this.populateProviderConsumer(tMapModel);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error encountered while processing transformmap model");
            throw new RuntimeException(ex);
        }
    }

    private ServiceEntry createServiceEntry(PartnerLinkTypeReference pltRefComponent) {
        PortType pt;
        if (pltRefComponent == null) {
            return null;
        }
        WSDLReference pltRef = pltRefComponent.getPartnerLinkType();
        WSDLReference roleRef = pltRefComponent.getRole();
        if (pltRef == null || roleRef == null) {
            return null;
        }
        ServiceEntry entry = null;
        QName pltQname = pltRef.getQName();
        if (pltQname == null) {
            return null;
        }
        String pltNS = pltQname.getNamespaceURI();
        String pltName = pltQname.getLocalPart();
        String pltNSPrefix = this.populateNamespace(pltNS);
        String portName = null;
        String portNameNS = null;
        String portNameNSPrefix = null;
        QName portNameQname = null;
        String roleName = null;
        Role role = (Role)this.resolveReference((NamedComponentReference)roleRef);
        if (role == null) {
            return null;
        }
        roleName = role.getName();
        NamedComponentReference portTypeRef = role.getPortType();
        if (portTypeRef != null && (pt = (PortType)this.resolveReference(portTypeRef)) != null) {
            portName = pt.getName();
            portNameNS = pt.getModel().getDefinitions().getTargetNamespace();
            portNameNSPrefix = this.populateNamespace(portNameNS);
            portNameQname = portTypeRef.getQName();
        }
        if (portName == null) {
            this.logger.log(Level.SEVERE, "Problem encountered while processing portType   PartnerLink =  \"" + pltName + "\"");
            throw new RuntimeException("Problem encountered while processing portType !");
        }
        String displayName = "";
        String processName = "";
        String filePath = "";
        if (pltRefComponent instanceof Service) {
            Service service = (Service)pltRefComponent;
            processName = displayName = service.getPartnerLinkType().getQName().getLocalPart();
            for (Operation operation : service.getOperations()) {
                for (Transform transform : operation.getTransforms()) {
                    filePath = filePath + transform.getFile() + ";";
                }
            }
            if (filePath.endsWith(";")) {
                filePath = filePath.substring(0, filePath.length() - 1);
            }
        }
        entry = new ServiceEntry(pltName, portName, pltNS, portNameNS, roleName, pltNSPrefix, portNameNSPrefix, pltQname, portNameQname, displayName, processName, filePath);
        return entry;
    }

    private void populateProviderConsumer(TMapModel tMapModel) {
        ServiceEntry provider = null;
        ServiceEntry consumer = null;
        List services = tMapModel.getTransformMap().getServices();
        if (services == null) {
            return;
        }
        for (Service service : services) {
            List operations;
            provider = this.createServiceEntry((PartnerLinkTypeReference)service);
            if (provider != null && !this.mProviders.contains(provider)) {
                this.mProviders.add(provider);
            }
            if ((operations = service.getOperations()) == null) continue;
            for (Operation operation : operations) {
                List invokes = operation.getInvokes();
                System.out.println("invokes: " + invokes);
                if (invokes == null) continue;
                System.out.println("invokes.size(): " + invokes.size());
                for (Invoke invoke : invokes) {
                    if (invoke == null) continue;
                    consumer = this.createServiceEntry((PartnerLinkTypeReference)invoke);
                    System.out.println("created consumer " + consumer + " for invoke: " + invoke);
                    if (consumer == null || this.mConsumers.contains(consumer)) continue;
                    this.mConsumers.add(consumer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJBIDescriptor() throws IOException {
        String extPrefix = this.mNameSpacePrefix.get(JBI_EXT_NS);
        String extDnElem = extPrefix + COLON_SEPARATOR + JBI_EXT_DISPLAY_NAME;
        String extPnElem = extPrefix + COLON_SEPARATOR + JBI_EXT_PROC_NAME;
        String extFpElem = extPrefix + COLON_SEPARATOR + JBI_EXT_FILE_PATH;
        FileOutputStream fos = null;
        try {
            ServiceEntry tmpService;
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            sb.append("<jbi version=\"1.0\"\n");
            sb.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            sb.append("        xmlns=\"http://java.sun.com/xml/ns/jbi\"\n");
            sb.append("        xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi jbi.xsd\"\n");
            int nss = this.mNameSpacePrefix.size();
            int i = 0;
            Set<String> nsUris = this.mNameSpacePrefix.keySet();
            for (String nsUri : nsUris) {
                sb.append("        xmlns:" + this.mNameSpacePrefix.get(nsUri) + "=\"" + nsUri + "\"");
                if (i < nss - 1) {
                    sb.append("\n");
                }
                ++i;
            }
            sb.append(">\n");
            sb.append("    <services binding-component=\"false\">\n");
            if (this.mProviders != null) {
                for (int j = 0; j < this.mProviders.size(); ++j) {
                    tmpService = this.mProviders.get(j);
                    sb.append("        <provides interface-name=\"" + AbstractJBIGenerator.getColonedQName(tmpService.getPortNameQname(), this.mNameSpacePrefix));
                    sb.append("\" service-name=\"" + AbstractJBIGenerator.getColonedQName(tmpService.getPartnerLinkNameQname(), this.mNameSpacePrefix));
                    sb.append("\" endpoint-name=\"" + tmpService.getRoleName());
                    sb.append("\">\n");
                    sb.append("            <" + extDnElem + ">" + this.escapeXml(tmpService.getDisplayName()) + "</" + extDnElem + ">\n");
                    sb.append("            <" + extPnElem + ">" + this.escapeXml(tmpService.getProcessName()) + "</" + extPnElem + ">\n");
                    sb.append("            <" + extFpElem + ">" + this.escapeXml(tmpService.getFilePath()) + "</" + extFpElem + ">\n");
                    sb.append("        </provides>\n");
                }
            }
            if (this.mConsumers != null) {
                for (int j = 0; j < this.mConsumers.size(); ++j) {
                    tmpService = this.mConsumers.get(j);
                    sb.append("        <consumes interface-name=\"" + AbstractJBIGenerator.getColonedQName(tmpService.getPortNameQname(), this.mNameSpacePrefix));
                    sb.append("\" service-name=\"" + AbstractJBIGenerator.getColonedQName(tmpService.getPartnerLinkNameQname(), this.mNameSpacePrefix));
                    sb.append("\" endpoint-name=\"" + tmpService.getRoleName());
                    sb.append("\">\n");
                    sb.append("            <" + extDnElem + ">" + this.escapeXml(tmpService.getDisplayName()) + "</" + extDnElem + ">\n");
                    sb.append("            <" + extPnElem + ">" + this.escapeXml(tmpService.getProcessName()) + "</" + extPnElem + ">\n");
                    sb.append("            <" + extFpElem + ">" + this.escapeXml(tmpService.getFilePath()) + "</" + extFpElem + ">\n");
                    sb.append("        </consumes>\n");
                }
            }
            sb.append("    </services>\n");
            sb.append(" </jbi>\n");
            String content = sb.toString();
            fos = new FileOutputStream(this.getJbiFile());
            AbstractJBIGenerator.store(content.getBytes("UTF-8"), fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private String escapeXml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private File getFileInSrc(String fileName) {
        if (fileName == null) {
            return null;
        }
        String srcDir = this.getSourceDirectory();
        if (srcDir == null || "".equals(srcDir)) {
            throw new BuildException("source directory shouldn't be null or empty");
        }
        File file = new File(srcDir + "/" + fileName);
        return file;
    }

    protected File getTransformmapFile() {
        File transformmapFile = this.getFileInSrc("transformmap.xml");
        if (transformmapFile == null || !transformmapFile.isFile()) {
            // empty if block
        }
        return transformmapFile;
    }

    private File getJbiFile() {
        String buildDir = this.getBuildDirectory();
        if (buildDir == null || "".equals(buildDir)) {
            throw new BuildException("build directory shouldn't be null or empty");
        }
        File jbiFile = new File(buildDir + "/META-INF/jbi.xml");
        return jbiFile;
    }

    private String populateNamespace(String namespaceURI) {
        if (namespaceURI == null || "".equals(namespaceURI)) {
            return null;
        }
        String namespacePrefix = null;
        namespacePrefix = this.mNameSpacePrefix.get(namespaceURI);
        if (namespacePrefix == null) {
            namespacePrefix = NAMESPACE_PREFIX + this.mNameSpacePrefix.size();
            this.mNameSpacePrefix.put(namespaceURI, namespacePrefix);
        }
        return namespacePrefix;
    }

    private static String getColonedQName(QName qn, Map nsTable) {
        String ns = qn.getNamespaceURI();
        String prefix = (String)nsTable.get(ns);
        if (prefix == null) {
            return qn.getLocalPart();
        }
        return prefix + COLON_SEPARATOR + qn.getLocalPart();
    }

    private static QName getQName(String qname) {
        return QName.valueOf(qname);
    }

    private static void store(byte[] input, OutputStream output) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = in.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        output.flush();
    }
}

