/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.openide.util.NbPreferences;

public final class GrailsSettings {
    public static final String GRAILS_BASE_PROPERTY = "grailsBase";
    private static final String GRAILS_HOME_KEY = "grailsHome";
    private static final String GRAILS_PORT_KEY = "grailsPrj-Port-";
    private static final String GRAILS_ENV_KEY = "grailsPrj-Env-";
    private static final String GRAILS_DEPLOY_KEY = "grailsPrj-Deploy-";
    private static final String GRAILS_AUTODEPLOY_KEY = "grailsPrj-Autodeploy-";
    private static final String GRAILS_DEBUG_BROWSER_KEY = "grailsPrj-DebugBrowser-";
    private static GrailsSettings instance;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private GrailsSettings() {
    }

    public static synchronized GrailsSettings getInstance() {
        if (instance == null) {
            instance = new GrailsSettings();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGrailsBase() {
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            return this.getPreferences().get(GRAILS_HOME_KEY, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGrailsBase(String string) {
        String string2;
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            string2 = this.getGrailsBase();
            this.getPreferences().put(GRAILS_HOME_KEY, string);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_BASE_PROPERTY, string2, string);
    }

    public String getPortForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getPortKey(project), null);
    }

    public void setPortForProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getPortKey(project), string);
    }

    public GrailsEnvironment getEnvForProject(Project project) {
        assert (project != null);
        String string = this.getPreferences().get(this.getEnvKey(project), null);
        if (string != null) {
            return GrailsEnvironment.valueOf(string);
        }
        return null;
    }

    public void setEnvForProject(Project project, GrailsEnvironment grailsEnvironment) {
        assert (project != null);
        assert (grailsEnvironment != null);
        this.getPreferences().put(this.getEnvKey(project), grailsEnvironment.toString());
    }

    public boolean getAutoDeployFlagForProject(Project project) {
        assert (project != null);
        return this.getPreferences().getBoolean(this.getAutodeployKey(project), false);
    }

    public void setAutoDeployFlagForProject(Project project, boolean bl) {
        assert (project != null);
        this.getPreferences().putBoolean(this.getAutodeployKey(project), bl);
    }

    public String getDeployDirForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getDeployKey(project), null);
    }

    public void setDeployDirForProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getDeployKey(project), string);
    }

    public String getDebugBrowserForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getDebugBrowserKey(project), null);
    }

    public void setDebugBrowserProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getDebugBrowserKey(project), string);
    }

    private String getProjectName(Project project) {
        assert (project != null);
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        assert (projectInformation != null);
        return projectInformation.getName();
    }

    private String getPortKey(Project project) {
        assert (project != null);
        return GRAILS_PORT_KEY + this.getProjectName(project);
    }

    private String getEnvKey(Project project) {
        assert (project != null);
        return GRAILS_ENV_KEY + this.getProjectName(project);
    }

    private String getDeployKey(Project project) {
        assert (project != null);
        return GRAILS_DEPLOY_KEY + this.getProjectName(project);
    }

    private String getAutodeployKey(Project project) {
        assert (project != null);
        return GRAILS_AUTODEPLOY_KEY + this.getProjectName(project);
    }

    private String getDebugBrowserKey(Project project) {
        assert (project != null);
        return GRAILS_DEBUG_BROWSER_KEY + this.getProjectName(project);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GrailsSettings.class);
    }
}

