/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.base.att;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.asm.base.att.TokenIterator;
import org.netbeans.modules.asm.base.syntax.AntlrScanner;
import org.netbeans.modules.asm.base.syntax.AntlrToken;
import org.netbeans.modules.asm.base.syntax.BranchElementImpl;
import org.netbeans.modules.asm.base.syntax.IdentResolver;
import org.netbeans.modules.asm.base.syntax.InstructionToken;
import org.netbeans.modules.asm.base.syntax.LabelElementImpl;
import org.netbeans.modules.asm.base.syntax.RegisterElementImpl;
import org.netbeans.modules.asm.base.syntax.ScannerFactory;
import org.netbeans.modules.asm.base.syntax.fake.FakeInstruction;
import org.netbeans.modules.asm.model.lang.AsmElement;
import org.netbeans.modules.asm.model.lang.AsmElementBuilder;
import org.netbeans.modules.asm.model.lang.OperandElement;
import org.netbeans.modules.asm.model.lang.Register;
import org.netbeans.modules.asm.model.lang.impl.AbstractAsmElement;
import org.netbeans.modules.asm.model.lang.impl.AsmRootElement;
import org.netbeans.modules.asm.model.lang.impl.BaseInstructionElement;
import org.netbeans.modules.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.asm.model.lang.syntax.AsmBaseTokenId;
import org.netbeans.modules.asm.model.lang.syntax.AsmParser;
import org.netbeans.modules.asm.model.lang.syntax.AsmToken;
import org.netbeans.modules.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.asm.model.util.IntervalSet;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ATTParser
implements AsmParser {
    private final IdentResolver resolver;
    private final ScannerFactory scannerFactory;
    private final Lookup myLookup;
    private List<AsmToken> tokens;
    private AsmElementBuilder result;
    private TokenIterator cur;
    private Set<String> globals;
    private IntervalSet<FunctionBoundsResolver.Entry> funcs;
    private String memOpBeginMark;
    private String memOpEndMark;
    private FunctionNameDetector funcDetector;

    public ATTParser(ScannerFactory scannerFactory, IdentResolver identResolver) {
        this.resolver = identResolver;
        this.scannerFactory = scannerFactory;
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new FunctionBoundsResolverImpl());
        this.myLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        this.tokens = new ArrayList<AsmToken>();
        this.globals = new HashSet<String>();
        this.funcs = new IntervalSet();
        this.setMemOpMarks("(", ")");
        this.setFunctionNameDetector(new DefaultFunctionNameDetector());
    }

    public void setMemOpMarks(String string, String string2) {
        this.memOpBeginMark = string;
        this.memOpEndMark = string2;
    }

    public void setFunctionNameDetector(FunctionNameDetector functionNameDetector) {
        this.funcDetector = functionNameDetector;
    }

    public Lookup getServices() {
        return this.myLookup;
    }

    private void reset(Reader reader) {
        AsmToken asmToken;
        this.tokens.clear();
        this.globals.clear();
        this.funcs.clear();
        this.result = AsmElementBuilder.create(null);
        AntlrScanner antlrScanner = this.scannerFactory.createScanner(reader, null);
        int n = 0;
        do {
            try {
                asmToken = ((AntlrToken)antlrScanner.nextToken()).createAsmToken(this.resolver);
                n = asmToken.getEndOffset();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Antlr lexer crashed");
                this.tokens.add(new AsmToken(AsmBaseTokenId.ASM_EOF, "", n, n + 1));
                break;
            }
            if (asmToken.getId() == AsmBaseTokenId.ASM_EMPTY) continue;
            this.tokens.add(asmToken);
        } while (asmToken.getId() != AsmBaseTokenId.ASM_EOF);
        this.cur = new TokenIteratorImpl();
    }

    public AsmElement parse(Reader reader) {
        AsmToken asmToken;
        int n = -1;
        int n2 = -1;
        Object object = "";
        this.reset(reader);
        while (this.cur.hasNext() && (asmToken = this.cur.next()).getId() != AsmBaseTokenId.ASM_EOF) {
            AsmElement asmElement;
            Object object2;
            Object object3;
            if (asmToken.getId() == AsmBaseTokenId.ASM_INSTRUCTION) {
                this.result.add(this.readInstruction((InstructionToken)asmToken));
                n = this.getLastResultIdx();
                continue;
            }
            if (asmToken.getId() == AsmBaseTokenId.ASM_DIRECTIVE) {
                if (!this.isDefinitionMark(asmToken.getText())) continue;
                this.globals.add(this.cur.getCurrect().getText());
                continue;
            }
            if (asmToken.getId() == AsmBaseTokenId.ASM_UNKWN_ID || asmToken.getId() == AsmBaseTokenId.ASM_LABEL) {
                object3 = BranchElementImpl.create(asmToken.getText());
                ((AbstractAsmElement)object3).setOffset(asmToken);
                n = this.getLastResultIdx();
                object2 = new InstructionToken(FakeInstruction.getInstance(), asmToken.getText(), asmToken.getStartOffset(), asmToken.getEndOffset());
                asmElement = this.readInstruction((InstructionToken)object2);
                asmElement.getCompounds().add(0, (AsmElement)object3);
                this.result.add(asmElement);
                continue;
            }
            if (asmToken.getId() != AsmBaseTokenId.ASM_LABEL_INST) continue;
            object3 = asmToken.getText();
            object2 = this.funcDetector.getCleanName((String)object3);
            asmElement = LabelElementImpl.create((String)object2);
            ((AbstractAsmElement)asmElement).setOffset(asmToken);
            this.result.add(asmElement);
            if (!this.funcDetector.isFunctionLabel((String)object3)) continue;
            if (n2 != -1 && n2 != n) {
                this.funcs.add(new FunctionBoundsResolver.Entry((String)object, n2, n));
            }
            object = object2;
            n2 = n = this.getLastResultIdx();
        }
        if (n2 != -1 && n2 != n) {
            this.funcs.add(new FunctionBoundsResolver.Entry((String)object, n2, n));
        }
        this.tokens = null;
        return AsmRootElement.create(this.result.get());
    }

    private boolean isDefinitionMark(String string) {
        return ".globl".equals(string) || ".local".equals(string) || ".global".equals(string);
    }

    private int getLastResultIdx() {
        return this.result.size() - 1;
    }

    private AsmElement readInstruction(InstructionToken instructionToken) {
        AsmToken asmToken;
        Object object;
        ArrayList<Register> arrayList = new ArrayList<Register>();
        ArrayList<Register> arrayList2 = new ArrayList<Register>();
        AsmElementBuilder asmElementBuilder = AsmElementBuilder.create(null);
        Instruction instruction = instructionToken.getInstruction();
        int n = 0;
        int n2 = 2;
        if (!instruction.getArguments().isEmpty() && !(object = instruction.getArguments().iterator().next().getParamMnemonic()).isEmpty()) {
            n2 = object.size();
        }
        while ((asmToken = this.cur.getCurrect()).getId() != AsmBaseTokenId.ASM_EOF) {
            if (asmToken.getId() == AsmBaseTokenId.ASM_REGISTER) {
                object = this.resolver.getRegister(asmToken.getText());
                if (object != null) {
                    AbstractAsmElement abstractAsmElement;
                    if (n == 0) {
                        OperandElement.Usage usage = OperandElement.Usage.OP_USE_NO_USE;
                        if (instruction.getReadArgIdxs().contains(n2)) {
                            arrayList.add((Register)object);
                            usage = OperandElement.Usage.OP_USE_READ;
                        }
                        if (instruction.getWriteArgIdxs().contains(n2)) {
                            arrayList2.add((Register)object);
                            usage = usage.apply(OperandElement.Usage.OP_USE_READ_WRITE);
                        }
                        abstractAsmElement = RegisterElementImpl.create((Register)object, usage);
                    } else {
                        arrayList.add((Register)object);
                        abstractAsmElement = RegisterElementImpl.create((Register)object, OperandElement.Usage.OP_USE_READ);
                    }
                    abstractAsmElement.setOffset(asmToken);
                    asmElementBuilder.add(abstractAsmElement);
                }
            } else if (asmToken.getId() == AsmBaseTokenId.ASM_MARK) {
                if (asmToken.getText().equals(",") && n == 0) {
                    --n2;
                } else if (asmToken.getText().equals(this.memOpBeginMark)) {
                    ++n;
                } else if (asmToken.getText().equals(this.memOpEndMark)) {
                    --n;
                }
            } else if (asmToken.getId() == AsmBaseTokenId.ASM_UNKWN_ID || asmToken.getId() == AsmBaseTokenId.ASM_INSTRUCTION || asmToken.getId() == AsmBaseTokenId.ASM_LABEL_INST || asmToken.getId() == AsmBaseTokenId.ASM_DIRECTIVE) break;
            this.cur.next();
        }
        object = BaseInstructionElement.create(asmElementBuilder.get(), instruction, arrayList, arrayList2);
        ((AbstractAsmElement)object).setStartOffset(instructionToken.getStartOffset());
        ((AbstractAsmElement)object).setEndOffset(this.cur.getCurrect().getStartOffset());
        return object;
    }

    private class TokenIteratorImpl
    implements TokenIterator {
        private int curPos;

        public TokenIteratorImpl() {
            this(0);
        }

        private TokenIteratorImpl(int n) {
            assert (ATTParser.this.tokens.size() > 0);
            this.curPos = n;
        }

        public AsmToken getCurrect() {
            if (this.curPos >= ATTParser.this.tokens.size()) {
                return (AsmToken)ATTParser.this.tokens.get(ATTParser.this.tokens.size() - 1);
            }
            return (AsmToken)ATTParser.this.tokens.get(this.curPos);
        }

        public AsmToken guess(int n) {
            if (this.curPos + n < ATTParser.this.tokens.size()) {
                return (AsmToken)ATTParser.this.tokens.get(this.curPos + n);
            }
            return (AsmToken)ATTParser.this.tokens.get(ATTParser.this.tokens.size() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsmToken next() {
            try {
                AsmToken asmToken = this.getCurrect();
                return asmToken;
            }
            finally {
                ++this.curPos;
            }
        }

        public TokenIterator createRecovery() {
            return new TokenIteratorImpl(this.curPos);
        }

        public boolean hasNext() {
            return this.curPos < ATTParser.this.tokens.size() - 1;
        }
    }

    public class DefaultFunctionNameDetector
    implements FunctionNameDetector {
        public boolean isFunctionLabel(String string) {
            return !(string = string.substring(0, string.length() - 1)).startsWith(".") && !Character.isDigit(string.charAt(0)) || ATTParser.this.globals.contains(string);
        }

        public String getCleanName(String string) {
            if (string.endsWith(":")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
    }

    public static interface FunctionNameDetector {
        public boolean isFunctionLabel(String var1);

        public String getCleanName(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionBoundsResolverImpl
    implements FunctionBoundsResolver {
        private FunctionBoundsResolverImpl() {
        }

        @Override
        public IntervalSet<FunctionBoundsResolver.Entry> getFunctions() {
            return ATTParser.this.funcs;
        }
    }
}

