/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.AddCastFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddCast
implements ErrorRule<Void> {
    private static final Map<Tree.Kind, String> operator2DN = new HashMap<Tree.Kind, String>();

    static void computeType(CompilationInfo compilationInfo, int n, TypeMirror[] typeMirrorArray, ExpressionTree[] expressionTreeArray, Tree[] treeArray) {
        for (Object object = compilationInfo.getTreeUtilities().pathFor(n + 1); object != null; object = object.getParentPath()) {
            Object object2;
            Object object3;
            Tree tree = object.getLeaf();
            TypeMirror typeMirror = null;
            TypeMirror typeMirror2 = null;
            ExpressionTree expressionTree = null;
            if (tree.getKind() == Tree.Kind.VARIABLE && ((VariableTree)tree).getInitializer() != null) {
                typeMirror = compilationInfo.getTrees().getTypeMirror((TreePath)object);
                expressionTree = ((VariableTree)tree).getInitializer();
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (tree.getKind() == Tree.Kind.ASSIGNMENT) {
                typeMirror = compilationInfo.getTrees().getTypeMirror((TreePath)object);
                expressionTree = ((AssignmentTree)tree).getExpression();
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (tree.getKind() == Tree.Kind.RETURN) {
                for (object3 = object; object3 != null && ((TreePath)object3).getLeaf().getKind() != Tree.Kind.METHOD; object3 = ((TreePath)object3).getParentPath()) {
                }
                if (object3 != null && (object2 = (Object)((MethodTree)((TreePath)object3).getLeaf()).getReturnType()) != null) {
                    typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object3, (Tree)object2));
                    expressionTree = ((ReturnTree)tree).getExpression();
                    typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
                }
            }
            if ((tree.getKind() == Tree.Kind.METHOD_INVOCATION || tree.getKind() == Tree.Kind.NEW_CLASS) && org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)compilationInfo, (TreePath)object, (TypeMirror[])(object3 = new TypeMirror[1]), (int[])(object2 = new int[1])) != null) {
                typeMirror = object3[0];
                expressionTree = tree.getKind() == Tree.Kind.METHOD_INVOCATION ? ((MethodInvocationTree)tree).getArguments().get(object2[0]) : ((NewClassTree)tree).getArguments().get(object2[0]);
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (typeMirror == null || typeMirror2 == null || (object3 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree))).getKind() == TypeKind.EXECUTABLE) continue;
            if (!compilationInfo.getTypes().isAssignable((TypeMirror)object3, typeMirror) && compilationInfo.getTypeUtilities().isCastable(typeMirror2, typeMirror) && object3.getKind() != TypeKind.ERROR && typeMirror.getKind() != TypeKind.ERROR) {
                typeMirrorArray[0] = typeMirror;
                expressionTreeArray[0] = expressionTree;
                treeArray[0] = tree;
                continue;
            }
            typeMirrorArray[0] = null;
        }
        if (typeMirrorArray[0] != null) {
            typeMirrorArray[0] = Utilities.resolveCapturedType(compilationInfo, typeMirrorArray[0]);
        }
    }

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve.location"));
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        TypeMirror[] typeMirrorArray = new TypeMirror[1];
        ExpressionTree[] expressionTreeArray = new ExpressionTree[1];
        Tree[] treeArray = new Tree[1];
        AddCast.computeType(compilationInfo, n, typeMirrorArray, expressionTreeArray, treeArray);
        if (typeMirrorArray[0] != null) {
            int n2 = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expressionTreeArray[0]);
            Class<? extends Tree> clazz = expressionTreeArray[0].getKind().asInterface();
            boolean bl = clazz == BinaryTree.class || clazz == ConditionalExpressionTree.class;
            arrayList.add(new AddCastFix(compilationInfo.getJavaSource(), (String)new HintDisplayNameVisitor(compilationInfo).scan(expressionTreeArray[0], null), ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirrorArray[0], (boolean)false)).toString(), n2, bl));
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AddCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AddCast.class, (String)"LBL_Add_Cast");
    }

    public String getDescription() {
        return NbBundle.getMessage(AddCast.class, (String)"DSC_Add_Cast");
    }

    static {
        operator2DN.put(Tree.Kind.AND, "&");
        operator2DN.put(Tree.Kind.XOR, "^");
        operator2DN.put(Tree.Kind.OR, "|");
        operator2DN.put(Tree.Kind.CONDITIONAL_AND, "&&");
        operator2DN.put(Tree.Kind.CONDITIONAL_OR, "||");
        operator2DN.put(Tree.Kind.MULTIPLY_ASSIGNMENT, "*=");
        operator2DN.put(Tree.Kind.DIVIDE_ASSIGNMENT, "/=");
        operator2DN.put(Tree.Kind.REMAINDER_ASSIGNMENT, "%=");
        operator2DN.put(Tree.Kind.PLUS_ASSIGNMENT, "+=");
        operator2DN.put(Tree.Kind.MINUS_ASSIGNMENT, "-=");
        operator2DN.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, "<<=");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, ">>=");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, ">>>=");
        operator2DN.put(Tree.Kind.AND_ASSIGNMENT, "&=");
        operator2DN.put(Tree.Kind.XOR_ASSIGNMENT, "^=");
        operator2DN.put(Tree.Kind.OR_ASSIGNMENT, "|=");
        operator2DN.put(Tree.Kind.BITWISE_COMPLEMENT, "~");
        operator2DN.put(Tree.Kind.LOGICAL_COMPLEMENT, "!");
        operator2DN.put(Tree.Kind.MULTIPLY, "*");
        operator2DN.put(Tree.Kind.DIVIDE, "/");
        operator2DN.put(Tree.Kind.REMAINDER, "%");
        operator2DN.put(Tree.Kind.PLUS, "+");
        operator2DN.put(Tree.Kind.MINUS, "-");
        operator2DN.put(Tree.Kind.LEFT_SHIFT, "<<");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT, ">>");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, ">>>");
        operator2DN.put(Tree.Kind.LESS_THAN, "<");
        operator2DN.put(Tree.Kind.GREATER_THAN, ">");
        operator2DN.put(Tree.Kind.LESS_THAN_EQUAL, "<=");
        operator2DN.put(Tree.Kind.GREATER_THAN_EQUAL, ">=");
        operator2DN.put(Tree.Kind.EQUAL_TO, "==");
        operator2DN.put(Tree.Kind.NOT_EQUAL_TO, "!=");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HintDisplayNameVisitor
    extends TreeScanner<String, Void> {
        private CompilationInfo info;

        public HintDisplayNameVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        @Override
        public String visitIdentifier(IdentifierTree identifierTree, Void void_) {
            return "..." + identifierTree.getName().toString();
        }

        @Override
        public String visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
            ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
            return "..." + this.simpleName(expressionTree) + "(...)";
        }

        @Override
        public String visitArrayAccess(ArrayAccessTree arrayAccessTree, Void void_) {
            return "..." + this.simpleName(arrayAccessTree.getExpression()) + "[]";
        }

        @Override
        public String visitNewClass(NewClassTree newClassTree, Void void_) {
            return "...new " + this.simpleName(newClassTree.getIdentifier()) + "(...)";
        }

        @Override
        public String visitBinary(BinaryTree binaryTree, Void void_) {
            String string = (String)operator2DN.get((Object)binaryTree.getKind());
            return (String)this.scan(binaryTree.getLeftOperand(), void_) + string + (String)this.scan(binaryTree.getRightOperand(), void_);
        }

        @Override
        public String visitLiteral(LiteralTree literalTree, Void void_) {
            if (literalTree.getValue() instanceof String) {
                return "...";
            }
            int n = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), literalTree);
            int n2 = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), literalTree);
            return this.info.getText().substring(n, n2);
        }

        private String simpleName(Tree tree) {
            if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                return ((IdentifierTree)tree).getName().toString();
            }
            if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
                return ((MemberSelectTree)tree).getIdentifier().toString();
            }
            if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return (String)this.scan(tree, null);
            }
            if (tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                return this.simpleName(((ParameterizedTypeTree)tree).getType()) + "<...>";
            }
            if (tree.getKind() == Tree.Kind.ARRAY_ACCESS) {
                return this.simpleName(((ArrayAccessTree)tree).getExpression()) + "[]";
            }
            throw new IllegalStateException("Currently unsupported kind of tree: " + (Object)((Object)tree.getKind()));
        }
    }
}

