/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongStringComparison
extends AbstractHint {
    private static String STRING_TYPE = "java.lang.String";
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);

    public WrongStringComparison() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.EQUAL_TO && tree.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return null;
        }
        BinaryTree binaryTree = (BinaryTree)tree;
        TreePath treePath2 = new TreePath(treePath, binaryTree.getLeftOperand());
        TreePath treePath3 = new TreePath(treePath, binaryTree.getRightOperand());
        Trees trees = compilationInfo.getTrees();
        TypeMirror typeMirror = treePath2 == null ? null : trees.getTypeMirror(treePath2);
        TypeMirror typeMirror2 = treePath3 == null ? null : trees.getTypeMirror(treePath3);
        Tree.Kind kind = treePath.getLeaf().getKind();
        boolean bl = false;
        while (kind != Tree.Kind.CLASS && kind != Tree.Kind.COMPILATION_UNIT) {
            if (kind == Tree.Kind.CONDITIONAL_AND) {
                bl = true;
            }
            if (kind == Tree.Kind.METHOD) {
                if (!bl || !((MethodTree)treePath.getLeaf()).getName().toString().equals("equals")) break;
                return null;
            }
            treePath = treePath.getParentPath();
            kind = treePath.getLeaf().getKind();
        }
        if (typeMirror != null && typeMirror2 != null && STRING_TYPE.equals(((Object)typeMirror).toString()) && STRING_TYPE.equals(((Object)typeMirror2).toString())) {
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree))));
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return "Wrong_String_Comparison";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"LBL_WrongStringComparison");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"DSC_WrongStringComparison");
    }
}

