/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor.pastetype;

import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.pastetype.DnDImportPanel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class WSDLImportPasteType
extends PasteType {
    private final WSDLModel newModel;
    private final WSDLModel currModel;

    public WSDLImportPasteType(WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        this.currModel = wSDLModel;
        this.newModel = wSDLModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable paste() throws IOException {
        if (this.newModel.equals(this.currModel)) {
            return null;
        }
        String string = this.validate();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)new Exception(string)));
            return null;
        }
        Set set = ((AbstractDocumentComponent)this.currModel.getDefinitions()).getPrefixes().keySet();
        String string2 = NameGenerator.getInstance().generateNamespacePrefix(null, this.currModel);
        DataObject dataObject = ActionHelper.getDataObject((Model)this.newModel);
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        DnDImportPanel dnDImportPanel = new DnDImportPanel();
        dnDImportPanel.setNamespace(this.newModel.getDefinitions().getTargetNamespace());
        dnDImportPanel.setProject(project);
        dnDImportPanel.setPrefix(string2);
        dnDImportPanel.setFileName(dataObject.getPrimaryFile());
        dnDImportPanel.setPrefixes(set);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dnDImportPanel, NbBundle.getMessage(WSDLImportPasteType.class, (String)"LBL_ConfirmWSDLDocDrop"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(WSDLImportPasteType.class), null);
        dnDImportPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            string2 = dnDImportPanel.getPrefix();
            Import import_ = null;
            try {
                this.currModel.startTransaction();
                Utility.addNamespacePrefix(this.newModel, this.currModel, string2);
                import_ = Utility.addWSDLImport(this.newModel, this.currModel);
            }
            finally {
                if (this.currModel.isIntransaction()) {
                    this.currModel.endTransaction();
                }
            }
            if (import_ != null) {
                ActionHelper.selectNode((WSDLComponent)import_);
            }
        }
        return null;
    }

    String validate() {
        DataObject dataObject = ActionHelper.getDataObject((Model)this.newModel);
        if (this.newModel.getState() != Model.State.VALID) {
            return NbBundle.getMessage(WSDLImportPasteType.class, (String)"ERRMSG_ImportedWSDLIsNotValid", (Object)dataObject.getPrimaryFile().getNameExt());
        }
        if (!Utility.canImport((Model)this.newModel, this.currModel)) {
            return NbBundle.getMessage(WSDLImportPasteType.class, (String)"ERRMSG_ProjectNotReferenceable");
        }
        String string = this.newModel.getDefinitions().getTargetNamespace();
        if (string == null) {
            return NbBundle.getMessage(WSDLImportPasteType.class, (String)"ERRMSG_ImportedWSDLWithNoTargetNamespace", (Object)dataObject.getPrimaryFile().getNameExt());
        }
        Collection collection = this.currModel.getDefinitions().getImports();
        for (Import import_ : collection) {
            try {
                WSDLModel wSDLModel = import_.getImportedWSDLModel();
                if (!this.newModel.equals(wSDLModel)) continue;
                return NbBundle.getMessage(WSDLImportPasteType.class, (String)"ERRMSG_AlreadyRefd");
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
        return null;
    }
}

