/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.FocusableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;

public class ButtonWidget
extends Widget
implements FocusableWidget {
    private ImageWidget imageWidget = null;
    private LabelWidget labelWidget = null;
    private Insets margin = new Insets(2, 8, 2, 8);
    private boolean rollover = false;
    private boolean pressed = false;
    private boolean enabled = true;
    private boolean focused = false;
    private boolean parentSelectionAllowed = false;
    private ActionListener actionListener = null;
    private boolean focusable;
    private static final Color BORDER_COLOR = new Color(8363449);
    private static final Color BACKGROUND_COLOR_1 = new Color(0xD2D2DD);
    private static final Color BACKGROUND_COLOR_2 = new Color(0xF8F8F8);
    private static final Color BACKGROUND_COLOR_DISABLED = new Color(0xE4E4E4);
    private static final Color ENABLED_TEXT_COLOR = new Color(0x222222);
    private static final Color DISABLED_TEXT_COLOR = new Color(0x888888);

    public ButtonWidget(Scene scene, String string) {
        this(scene, string, false);
    }

    public ButtonWidget(Scene scene, String string, boolean bl) {
        this(scene, null, string, bl);
    }

    public ButtonWidget(Scene scene, Image image) {
        this(scene, image, null, false);
    }

    public ButtonWidget(Scene scene, Image image, boolean bl) {
        this(scene, image, null, bl);
    }

    public ButtonWidget(Scene scene, Image image, String string, boolean bl) {
        super(scene);
        this.focusable = bl;
        this.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)4));
        this.setIconAndText(image, string);
        this.setBorder(new ButtonBorder());
        this.getActions().addAction((WidgetAction)((PartnerScene)scene).getButtonAction());
        this.getActions().addAction(((PartnerScene)scene).getSelectAction());
    }

    public String getText() {
        return this.labelWidget == null ? null : this.labelWidget.getLabel();
    }

    public Image getIcon() {
        return this.imageWidget == null ? null : this.imageWidget.getImage();
    }

    public void setText(String string) {
        this.setIconAndText(this.getIcon(), string);
    }

    public void setIcon(Image image) {
        this.setIconAndText(image, this.getText());
    }

    public Insets getMargin() {
        return new Insets(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right);
    }

    public void setMargin(Insets insets) {
        this.margin.set(insets.top, insets.left, insets.bottom, insets.right);
        this.revalidate(true);
        this.getScene().validate();
    }

    public void setIconAndText(Image image, String string) {
        this.removeButtonChildren();
        String string2 = this.getText();
        Image image2 = this.getIcon();
        if (this.imageWidget == null) {
            if (image != null) {
                this.imageWidget = new ImageWidget(this.getScene(), image);
            }
        } else if (image == null) {
            this.imageWidget = null;
        } else if (image != image2) {
            this.imageWidget.setImage(image);
        }
        if (this.labelWidget == null) {
            if (string != null) {
                this.labelWidget = new LabelWidget(this.getScene(), string);
                this.labelWidget.setFont(this.getScene().getDefaultFont());
                this.labelWidget.setForeground(this.isButtonEnabled() ? ENABLED_TEXT_COLOR : DISABLED_TEXT_COLOR);
            }
        } else if (string == null) {
            this.labelWidget = null;
        } else if (string2 == null || !string.equals(string2)) {
            this.labelWidget.setLabel(string);
        }
        this.addButtonChildren();
        this.getScene().validate();
    }

    private void removeButtonChildren() {
        if (this.labelWidget != null) {
            this.removeChild((Widget)this.labelWidget);
        }
        if (this.imageWidget != null) {
            this.removeChild((Widget)this.imageWidget);
        }
    }

    private void addButtonChildren() {
        if (this.imageWidget != null) {
            this.addChild((Widget)this.imageWidget);
        }
        if (this.labelWidget != null) {
            this.addChild((Widget)this.labelWidget);
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    private void fireActionPerformed() {
        if (this.actionListener != null && this.enabled) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "button-pressed"));
        }
    }

    public boolean isParenSelectionAllowed() {
        return this.parentSelectionAllowed;
    }

    public void setParentSelectionAllowed(boolean bl) {
        this.parentSelectionAllowed = bl;
    }

    public void mouseEntered() {
        if (!this.getState().isFocused()) {
            this.rollover = true;
        }
        this.repaint();
    }

    public void mouseExited() {
        this.rollover = false;
        this.repaint();
    }

    public void mousePressed() {
        this.pressed = true;
        this.repaint();
    }

    public void mouseReleased(boolean bl) {
        this.pressed = false;
        this.focused = false;
        this.repaint();
        if (bl) {
            this.fireActionPerformed();
        }
    }

    public void setButtonEnabled(boolean bl) {
        this.enabled = bl;
        if (this.labelWidget != null) {
            this.labelWidget.setForeground(bl ? ENABLED_TEXT_COLOR : DISABLED_TEXT_COLOR);
        }
        this.revalidate(true);
        this.getScene().validate();
    }

    public boolean isButtonEnabled() {
        return this.enabled;
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        if (!this.enabled) {
            return;
        }
        if (!objectState.isFocused() && objectState2.isFocused()) {
            this.focused = true;
            this.revalidate(true);
        } else if (objectState.isFocused() && !objectState2.isFocused()) {
            this.focused = false;
            this.revalidate(true);
        }
        this.getScene().validate();
    }

    private static Color grayFilter(Color color) {
        int n = Math.round(0.299f * (float)color.getRed() + 0.587f * (float)color.getGreen() + 0.114f * (float)color.getBlue());
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return new Color(n, n, n);
    }

    public boolean isFocusable() {
        return this.focusable && this.isButtonEnabled() && this.isWidgetVisible();
    }

    private boolean isWidgetVisible() {
        ButtonWidget buttonWidget = this;
        while (buttonWidget.isVisible() && (buttonWidget = buttonWidget.getParentWidget()) != null) {
        }
        return buttonWidget == null;
    }

    public void setFocusable(boolean bl) {
        this.focusable = bl;
    }

    public String toString() {
        return this.labelWidget != null ? this.labelWidget.getLabel() : "";
    }

    private class ButtonBorder
    implements Border {
        public Insets getInsets() {
            return new Insets(((ButtonWidget)ButtonWidget.this).margin.top, ((ButtonWidget)ButtonWidget.this).margin.left, ((ButtonWidget)ButtonWidget.this).margin.bottom, ((ButtonWidget)ButtonWidget.this).margin.right);
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            if (ButtonWidget.this.enabled) {
                graphics2D.setPaint(BORDER_COLOR);
                graphics2D.fill(new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6.0, 6.0));
                if (ButtonWidget.this.pressed) {
                    graphics2D.setPaint(new Color(0xCCCCCC));
                } else {
                    graphics2D.setPaint(new GradientPaint(0.0f, rectangle.y + 1, BACKGROUND_COLOR_1, 0.0f, (float)rectangle.y + (float)rectangle.height * 0.5f, BACKGROUND_COLOR_2, true));
                }
                if (ButtonWidget.this.rollover) {
                    graphics2D.fill(new RoundRectangle2D.Double((double)rectangle.x + 1.5, (double)rectangle.y + 1.5, rectangle.width - 3, rectangle.height - 3, 3.0, 3.0));
                } else if (ButtonWidget.this.focused) {
                    graphics2D.setPaint(WidgetConstants.SELECTION_COLOR);
                    graphics2D.fill(new RoundRectangle2D.Double(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 4.0, 4.0));
                } else {
                    graphics2D.fill(new RoundRectangle2D.Double(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 4.0, 4.0));
                }
            } else {
                graphics2D.setPaint(ButtonWidget.grayFilter(BORDER_COLOR));
                graphics2D.fill(new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6.0, 6.0));
                graphics2D.setPaint(BACKGROUND_COLOR_DISABLED);
                graphics2D.fill(new RoundRectangle2D.Double(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 4.0, 4.0));
            }
            graphics2D.setPaint(paint);
        }

        public boolean isOpaque() {
            return true;
        }
    }
}

