/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.util.Collection;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.view.ImportSchemaCustomizer;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SchemaReferenceDecorator
extends AbstractReferenceDecorator {
    private ImportSchemaCustomizer customizer;
    private int prefixCounter;

    public SchemaReferenceDecorator(ImportSchemaCustomizer importSchemaCustomizer) {
        this.customizer = importSchemaCustomizer;
    }

    public String validate(ExternalReferenceNode externalReferenceNode) {
        String string;
        Object object;
        if (externalReferenceNode.hasModel()) {
            object = externalReferenceNode.getModel();
            if (object == null) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_NoModel");
            }
            if (object instanceof SchemaModel && (string = ((SchemaModel)object).getSchema().getTargetNamespace()) == null) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_NoNamespace");
            }
            string = this.customizer.getComponentModel();
            if (object.equals(string)) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_SameModel");
            }
            if (string instanceof SchemaModel) {
                SchemaModel schemaModel = (SchemaModel)string;
                Collection collection = schemaModel.getSchema().getSchemaReferences();
                for (SchemaModelReference schemaModelReference : collection) {
                    try {
                        SchemaModel schemaModel2 = schemaModelReference.resolveReferencedModel();
                        if (!object.equals(schemaModel2)) continue;
                        return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_AlreadyRefd");
                    }
                    catch (CatalogModelException catalogModelException) {
                    }
                }
            }
        }
        object = externalReferenceNode.getNamespace();
        string = this.customizer.getTargetNamespace();
        if (this.customizer.mustNamespaceDiffer()) {
            if (object != null && !"NO_NAME_SPACE".equals(object) && string.equals(object)) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_SameNamespace");
            }
        } else if (object != null && !"NO_NAME_SPACE".equals(object) && !string.equals(object)) {
            return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_ReferenceDecorator_DifferentNamespace");
        }
        return null;
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        return this.customizer.createExternalReferenceNode(node);
    }

    protected String generatePrefix(Model model) {
        WSDLModel wSDLModel = this.customizer.getModel();
        if (wSDLModel != null) {
            return NameGenerator.getInstance().generateNamespacePrefix(null, wSDLModel, this.prefixCounter++);
        }
        return "";
    }

    public Utilities.DocumentTypesEnum getDocumentType() {
        return Utilities.DocumentTypesEnum.schema;
    }

    public String getHtmlDisplayName(String string, ExternalReferenceNode externalReferenceNode) {
        if (this.validate(externalReferenceNode) != null) {
            return "<s>" + string + "</s>";
        }
        return string;
    }

    public String getNamespace(Model model) {
        if (model instanceof SchemaModel) {
            SchemaModel schemaModel = (SchemaModel)model;
            return schemaModel.getSchema().getTargetNamespace();
        }
        return null;
    }
}

