/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.ui.view.ElementOrType;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.OperationPanel;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartAndElementOrTypeTableModel
extends AbstractTableModel {
    private List<PartAndElementOrType> mPartAndElementOrTypeList = new ArrayList<PartAndElementOrType>();
    private Map<String, String> namespaceToPrefixMap = new HashMap<String, String>();

    public PartAndElementOrTypeTableModel(Map<String, String> map) {
        this.namespaceToPrefixMap = map;
    }

    public List<PartAndElementOrType> getPartAndElementOrType() {
        return this.mPartAndElementOrTypeList;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return NbBundle.getMessage(PartAndElementOrTypeTableModel.class, (String)"PartAndElementOrTypeTableMode.Column1.text");
        }
        return NbBundle.getMessage(PartAndElementOrTypeTableModel.class, (String)"PartAndElementOrTypeTableMode.Column2.text");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.mPartAndElementOrTypeList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PartAndElementOrType partAndElementOrType = this.mPartAndElementOrTypeList.get(n);
        if (n2 == 0) {
            return partAndElementOrType.getPartName();
        }
        if (n2 == 1) {
            return partAndElementOrType.getElementOrType();
        }
        return "Missing Value";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            return;
        }
        PartAndElementOrType partAndElementOrType = this.mPartAndElementOrTypeList.get(n);
        if (n2 == 0) {
            String string = (String)object;
            String string2 = (String)this.getValueAt(n, 0);
            if (string2 != null && string2.equals(string)) {
                return;
            }
            if (this.isPartNameExists(string)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PartAndElementOrTypeTableModel.class, (String)"ERR_MSG_PART_EXISTS", (Object)string), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else if (!this.isValidPartName(string)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                partAndElementOrType.setPartName(string);
            }
        } else if (n2 == 1 && object instanceof ElementOrType) {
            ElementOrType elementOrType = (ElementOrType)object;
            partAndElementOrType.setElementOrType(elementOrType);
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public void removeSelectedRow(int n) {
        int n2 = this.mPartAndElementOrTypeList.size();
        if (n >= n2) {
            throw new IllegalArgumentException("can not delete row " + n + 1 + "total rows are" + n2);
        }
        this.mPartAndElementOrTypeList.remove(n);
        super.fireTableRowsDeleted(n, n);
    }

    public void addNewRow() {
        GlobalSimpleType globalSimpleType = null;
        Schema schema = SchemaModelFactory.getDefault().getPrimitiveTypesModel().getSchema();
        Collection collection = schema.getSimpleTypes();
        for (GlobalSimpleType globalSimpleType2 : collection) {
            if (!globalSimpleType2.getName().equals("string")) continue;
            globalSimpleType = globalSimpleType2;
            break;
        }
        PartAndElementOrType partAndElementOrType = new PartAndElementOrType(this.generateUniquePartName(), new ElementOrType((GlobalType)globalSimpleType, this.namespaceToPrefixMap));
        this.mPartAndElementOrTypeList.add(partAndElementOrType);
        int n = this.mPartAndElementOrTypeList.indexOf(partAndElementOrType);
        super.fireTableRowsInserted(n, n);
    }

    private String generateUniquePartName() {
        String string = "part";
        int n = 1;
        String string2 = string + n++;
        while (this.isPartNameExists(string2)) {
            string2 = string + n++;
        }
        return string2;
    }

    private boolean isPartNameExists(String string) {
        for (PartAndElementOrType partAndElementOrType : this.mPartAndElementOrTypeList) {
            String string2 = partAndElementOrType.getPartName();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidPartName(String string) {
        return Utils.isValidNCName((String)string);
    }

    public class PartAndElementOrType {
        private String mPartName;
        private ElementOrType mElementOrType;

        public PartAndElementOrType(String string, ElementOrType elementOrType) {
            this.mPartName = string;
            this.mElementOrType = elementOrType;
        }

        public String getPartName() {
            return this.mPartName;
        }

        public void setPartName(String string) {
            this.mPartName = string;
        }

        public ElementOrType getElementOrType() {
            return this.mElementOrType;
        }

        public void setElementOrType(ElementOrType elementOrType) {
            this.mElementOrType = elementOrType;
        }
    }
}

