/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.api.property.ElementOrTypeChooserHelper;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.ElementOrType;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementOrTypeChooserPanel
extends JPanel
implements ExplorerManager.Provider {
    private Map<String, String> namespaceToPrefixMap;
    private Project mProject;
    private WSDLModel mModel;
    private SchemaComponent mPreviousSelectedComponent;
    private ExplorerManager manager;
    public static String PROP_ACTION_APPLY = "APPLY";
    private ElementOrType selectedElementOrType;
    private SchemaComponent selectedComponent;
    private BeanTreeView beanTreeView1;

    public ElementOrTypeChooserPanel(Project project, Map<String, String> map, WSDLModel wSDLModel) {
        this.namespaceToPrefixMap = map;
        this.mProject = project;
        this.mModel = wSDLModel;
        this.initComponents();
        this.initGUI();
    }

    public ElementOrTypeChooserPanel(Project project, Map<String, String> map, WSDLModel wSDLModel, SchemaComponent schemaComponent) {
        this.namespaceToPrefixMap = map;
        this.mProject = project;
        this.mModel = wSDLModel;
        this.mPreviousSelectedComponent = schemaComponent;
        this.initComponents();
        this.initGUI();
    }

    private void initComponents() {
        this.beanTreeView1 = new BeanTreeView();
        this.setName("Form");
        this.beanTreeView1.setAutoscrolls(true);
        this.beanTreeView1.setDefaultActionAllowed(false);
        this.beanTreeView1.setDragSource(false);
        this.beanTreeView1.setDropTarget(false);
        this.beanTreeView1.setFocusable(false);
        this.beanTreeView1.setName("beanTreeView1");
        this.beanTreeView1.setPopupAllowed(false);
        this.beanTreeView1.setRootVisible(false);
        this.beanTreeView1.setSelectionMode(1);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.beanTreeView1, -1, 410, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.beanTreeView1, -1, 411, Short.MAX_VALUE));
    }

    private void initGUI() {
        this.manager = new ExplorerManager();
        this.manager.addPropertyChangeListener((PropertyChangeListener)new ExplorerPropertyChangeListener());
        AbstractNode abstractNode = new AbstractNode((Children)new Children.Array());
        this.manager.setRootContext((Node)abstractNode);
        this.populateRootNode((Node)abstractNode);
        Utility.expandNodes((TreeView)this.beanTreeView1, 3, (Node)abstractNode);
    }

    private void populateRootNode(Node node) {
        ElementOrTypeChooserHelper elementOrTypeChooserHelper = new ElementOrTypeChooserHelper(this.mProject, this.mModel);
        elementOrTypeChooserHelper.populateNodes(node);
        if (this.mPreviousSelectedComponent != null) {
            Node node2 = elementOrTypeChooserHelper.selectNode(this.mPreviousSelectedComponent);
            if (node2 != null) {
                this.selectNode(node2);
            }
        } else {
            this.selectNode(node);
        }
    }

    private void selectNode(Node node) {
        final Node node2 = node;
        Runnable runnable = new Runnable(){

            public void run() {
                if (ElementOrTypeChooserPanel.this.manager != null) {
                    try {
                        ElementOrTypeChooserPanel.this.manager.setExploredContextAndSelection(node2, new Node[]{node2});
                        ElementOrTypeChooserPanel.this.beanTreeView1.expandNode(node2);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static final void main(String[] stringArray) {
    }

    public void apply() {
        if (this.selectedComponent != null) {
            if (this.selectedComponent instanceof GlobalType) {
                this.selectedElementOrType = new ElementOrType((GlobalType)this.selectedComponent, this.namespaceToPrefixMap);
            } else if (this.selectedComponent instanceof GlobalElement) {
                this.selectedElementOrType = new ElementOrType((GlobalElement)this.selectedComponent, this.namespaceToPrefixMap);
            }
        }
    }

    public ElementOrType getSelectedComponent() {
        return this.selectedElementOrType;
    }

    public SchemaComponent getSelectedSchemaComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(ElementOrType elementOrType) {
        this.selectedElementOrType = elementOrType;
    }

    class ExplorerPropertyChangeListener
    implements PropertyChangeListener {
        ExplorerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 0) {
                Node node = nodeArray[0];
                ElementOrTypeChooserPanel.this.firePropertyChange(PROP_ACTION_APPLY, true, false);
                SchemaComponent schemaComponent = null;
                SchemaComponentReference schemaComponentReference = (SchemaComponentReference)node.getLookup().lookup(SchemaComponentReference.class);
                if (schemaComponentReference != null) {
                    schemaComponent = schemaComponentReference.get();
                }
                if (schemaComponent == null) {
                    schemaComponent = (SchemaComponent)node.getLookup().lookup(SchemaComponent.class);
                }
                if (schemaComponent != null && (schemaComponent instanceof GlobalType || schemaComponent instanceof GlobalElement)) {
                    ElementOrTypeChooserPanel.this.selectedComponent = schemaComponent;
                    ElementOrTypeChooserPanel.this.firePropertyChange(PROP_ACTION_APPLY, false, true);
                }
            }
        }
    }
}

