/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.api.property;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.api.property.ElementOrTypeOrMessagePartProvider;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;

public class ElementOrTypeOrMessagePart {
    private GlobalElement mElement;
    private GlobalType mType;
    private Part mPart;
    private Message mMessage;
    private QName mQName;
    private ElementOrTypeOrMessagePartProvider.ParameterType pType = ElementOrTypeOrMessagePartProvider.ParameterType.NONE;
    private WSDLModel mModel;
    private String mPartName;

    public ElementOrTypeOrMessagePart(QName qName, WSDLModel wSDLModel, ElementOrTypeOrMessagePartProvider.ParameterType parameterType) {
        this.pType = parameterType;
        this.mQName = qName;
        this.mModel = wSDLModel;
        if (this.pType == ElementOrTypeOrMessagePartProvider.ParameterType.ELEMENT) {
            this.mElement = Utility.findGlobalElement(wSDLModel, qName);
        } else if (this.pType == ElementOrTypeOrMessagePartProvider.ParameterType.TYPE) {
            this.mType = Utility.findGlobalType(wSDLModel, qName);
        }
    }

    public Part getMessagePart() {
        return this.mPart;
    }

    public ElementOrTypeOrMessagePartProvider.ParameterType getParameterType() {
        return this.pType;
    }

    public ElementOrTypeOrMessagePart(QName qName, WSDLModel wSDLModel, String string) {
        this.pType = ElementOrTypeOrMessagePartProvider.ParameterType.MESSAGEPART;
        this.mModel = wSDLModel;
        this.mQName = qName;
        this.mPartName = string;
        this.mMessage = (Message)this.mModel.findComponentByName(qName, Message.class);
        if (this.mMessage != null) {
            for (Part part : this.mMessage.getParts()) {
                if (!part.getName().equals(string)) continue;
                this.mPart = part;
                break;
            }
        }
    }

    public ElementOrTypeOrMessagePart(GlobalElement globalElement, WSDLModel wSDLModel) {
        this.mElement = globalElement;
        this.mModel = wSDLModel;
        this.pType = ElementOrTypeOrMessagePartProvider.ParameterType.ELEMENT;
    }

    public ElementOrTypeOrMessagePart(GlobalType globalType, WSDLModel wSDLModel) {
        this.mType = globalType;
        this.mModel = wSDLModel;
        this.pType = ElementOrTypeOrMessagePartProvider.ParameterType.TYPE;
    }

    public ElementOrTypeOrMessagePart(Part part, WSDLModel wSDLModel) {
        this.mPart = part;
        this.mMessage = (Message)part.getParent();
        this.mModel = wSDLModel;
        this.pType = ElementOrTypeOrMessagePartProvider.ParameterType.MESSAGEPART;
    }

    public GlobalElement getElement() {
        return this.mElement;
    }

    public GlobalType getType() {
        return this.mType;
    }

    public String toString() {
        if (this.mQName != null) {
            String string = Utility.fromQNameToString(this.mQName);
            if (this.pType == ElementOrTypeOrMessagePartProvider.ParameterType.MESSAGEPART) {
                string = string + "/" + this.mPartName;
            }
            return string;
        }
        String string = null;
        String string2 = "";
        if (this.mElement != null) {
            string = this.mElement.getModel().getSchema().getTargetNamespace();
            string2 = this.mElement.getName();
        }
        if (this.mType != null) {
            string = this.mType.getModel().getSchema().getTargetNamespace();
            string2 = this.mType.getName();
        }
        if (this.mMessage != null) {
            string = this.mMessage.getModel().getDefinitions().getTargetNamespace();
            string2 = this.mMessage.getName();
        }
        if (string == null) {
            return string2;
        }
        if (this.mModel == null) {
            return new QName(string, string2).toString();
        }
        String string3 = Utility.getNamespacePrefix(string, this.mModel);
        if (string3 == null) {
            string3 = NameGenerator.getInstance().generateNamespacePrefix(null, this.mModel);
            boolean bl = Utility.startTransaction(this.mModel);
            ((AbstractDocumentComponent)this.mModel.getDefinitions()).addPrefix(string3, string);
            Utility.endTransaction(this.mModel, bl);
        }
        if (this.pType == ElementOrTypeOrMessagePartProvider.ParameterType.MESSAGEPART) {
            return string3 + ":" + string2 + "/" + this.mPart.getName();
        }
        return string3 + ":" + string2;
    }
}

