/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public class Cache {
    private boolean useZip;
    Delegate delegate;

    public Cache(boolean bl) throws IOException {
        this.delegate = bl ? new Zipped() : new Plain();
    }

    public void writeAst(AST aST, File file) throws IOException {
        this.delegate.writeAst(aST, file);
    }

    public AST readAst(File file) throws IOException, ClassNotFoundException {
        return this.delegate.readAst(file);
    }

    private class Zipped
    extends Plain
    implements Delegate {
        private ZipFile zip;

        public Zipped() throws IOException {
            this.zip = new ZipFile(new File("test-model-cache.zip"), 1);
        }

        protected InputStream getFileInputStream(File file) throws IOException {
            String string = this.getEntryName(file);
            ZipEntry zipEntry = this.zip.getEntry(string);
            if (zipEntry == null) {
                throw new ZipException("Entry not found: " + string);
            }
            InputStream inputStream = this.zip.getInputStream(zipEntry);
            return inputStream;
        }
    }

    private class Plain
    extends Base
    implements Delegate {
        private File cacheDir;

        public Plain() {
            this.cacheDir = new File("test-model-cache");
            this.cacheDir.mkdirs();
        }

        protected InputStream getFileInputStream(File file) throws IOException {
            File file2 = this.getCacheFile(file);
            return new BufferedInputStream(new FileInputStream(file2), TraceFlags.BUF_SIZE);
        }

        protected OutputStream getFileOutputStream(File file) throws IOException {
            File file2 = this.getCacheFile(file);
            return new FileOutputStream(file2);
        }

        protected File getCacheFile(File file) {
            return new File(this.cacheDir, this.getEntryName(file));
        }

        protected String getEntryName(File file) {
            return file.getAbsolutePath().substring(1) + ".ast";
        }
    }

    private abstract class Base
    implements Delegate {
        private Base() {
        }

        protected abstract InputStream getFileInputStream(File var1) throws IOException;

        protected abstract OutputStream getFileOutputStream(File var1) throws IOException;

        public void writeAst(AST aST, File file) throws IOException {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.getFileOutputStream(file));
            AstWrapper astWrapper = new AstWrapper(aST);
            objectOutputStream.writeObject(astWrapper);
            objectOutputStream.close();
        }

        public AST readAst(File file) throws IOException, ClassNotFoundException {
            AstWrapper astWrapper = null;
            ObjectInputStream objectInputStream = new ObjectInputStream(this.getFileInputStream(file));
            astWrapper = (AstWrapper)objectInputStream.readObject();
            objectInputStream.close();
            return astWrapper.ast;
        }
    }

    private static class AstWrapper
    implements Serializable {
        public AST ast;

        public AstWrapper(AST aST) {
            this.ast = aST;
        }
    }

    private static interface Delegate {
        public void writeAst(AST var1, File var2) throws IOException;

        public AST readAst(File var1) throws IOException, ClassNotFoundException;
    }
}

