/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.UIDFilter;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectImpl
extends CsmSelect {
    private static final FilterBuilder builder = new FilterBuilder();

    public CsmSelect.CsmFilterBuilder getFilterBuilder() {
        return builder;
    }

    public Iterator<CsmMacro> getMacros(CsmFile csmFile, CsmSelect.CsmFilter csmFilter) {
        if (csmFile instanceof FileImpl) {
            Iterator<CsmMacro> iterator = this.analyzeFilter((FileImpl)csmFile, csmFilter);
            if (iterator != null) {
                return iterator;
            }
            return ((FileImpl)csmFile).getMacros(csmFilter);
        }
        return csmFile.getMacros().iterator();
    }

    private Iterator<CsmMacro> analyzeFilter(FileImpl fileImpl, CsmSelect.CsmFilter csmFilter) {
        FilterBuilder.NameFilterImpl nameFilterImpl;
        if (csmFilter instanceof FilterBuilder.NameFilterImpl && (nameFilterImpl = (FilterBuilder.NameFilterImpl)csmFilter).caseSensitive && nameFilterImpl.match && !nameFilterImpl.allowEmptyName) {
            Collection collection = fileImpl.findMacroUids(nameFilterImpl.strPrefix);
            return new LazyCsmCollection(collection, true).iterator(csmFilter);
        }
        return null;
    }

    public Iterator<CsmInclude> getIncludes(CsmFile csmFile, CsmSelect.CsmFilter csmFilter) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getIncludes(csmFilter);
        }
        return csmFile.getIncludes().iterator();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace csmNamespace, CsmSelect.CsmFilter csmFilter) {
        if (csmNamespace instanceof NamespaceImpl) {
            Iterator<CsmOffsetableDeclaration> iterator = this.analyzeFilter((NamespaceImpl)csmNamespace, csmFilter);
            if (iterator != null) {
                return iterator;
            }
            return ((NamespaceImpl)csmNamespace).getDeclarations(csmFilter);
        }
        return csmNamespace.getDeclarations().iterator();
    }

    private Iterator<CsmOffsetableDeclaration> analyzeFilter(NamespaceImpl namespaceImpl, CsmSelect.CsmFilter csmFilter) {
        Object object;
        if (!namespaceImpl.isGlobal() && namespaceImpl.getName().length() == 0) {
            return null;
        }
        FilterBuilder.NameFilterImpl nameFilterImpl = null;
        FilterBuilder.KindFilterImpl kindFilterImpl = null;
        if (csmFilter instanceof FilterBuilder.CompoundFilterImpl) {
            object = (FilterBuilder.CompoundFilterImpl)csmFilter;
            if (((FilterBuilder.CompoundFilterImpl)object).first instanceof FilterBuilder.KindFilterImpl && ((FilterBuilder.CompoundFilterImpl)object).second instanceof FilterBuilder.NameFilterImpl) {
                nameFilterImpl = (FilterBuilder.NameFilterImpl)((FilterBuilder.CompoundFilterImpl)object).second;
                kindFilterImpl = (FilterBuilder.KindFilterImpl)((FilterBuilder.CompoundFilterImpl)object).first;
            } else if (((FilterBuilder.CompoundFilterImpl)object).first instanceof FilterBuilder.NameFilterImpl && ((FilterBuilder.CompoundFilterImpl)object).second instanceof FilterBuilder.KindFilterImpl) {
                nameFilterImpl = (FilterBuilder.NameFilterImpl)((FilterBuilder.CompoundFilterImpl)object).first;
                kindFilterImpl = (FilterBuilder.KindFilterImpl)((FilterBuilder.CompoundFilterImpl)object).second;
            }
        } else if (csmFilter instanceof FilterBuilder.KindFilterImpl) {
            kindFilterImpl = (FilterBuilder.KindFilterImpl)csmFilter;
        }
        if (nameFilterImpl != null && kindFilterImpl != null) {
            if (nameFilterImpl.caseSensitive && nameFilterImpl.match) {
                object = new ArrayList();
                for (int i = 0; i < kindFilterImpl.kinds.length; ++i) {
                    String string = namespaceImpl.isGlobal() ? (kindFilterImpl.kinds[i] == CsmDeclaration.Kind.VARIABLE || kindFilterImpl.kinds[i] == CsmDeclaration.Kind.VARIABLE_DEFINITION ? Utils.getCsmDeclarationKindkey(kindFilterImpl.kinds[i]) + ':' + "::" + nameFilterImpl.strPrefix : Utils.getCsmDeclarationKindkey(kindFilterImpl.kinds[i]) + ':' + nameFilterImpl.strPrefix) : Utils.getCsmDeclarationKindkey(kindFilterImpl.kinds[i]) + ':' + namespaceImpl.getQualifiedName() + "::" + nameFilterImpl.strPrefix;
                    object.addAll(namespaceImpl.findUidsByPrefix(string));
                }
                if (nameFilterImpl.allowEmptyName) {
                    object.addAll(namespaceImpl.getUnnamedUids());
                }
                return new LazyCsmCollection(object, true).iterator(csmFilter);
            }
            object = new ArrayList();
            for (int i = 0; i < kindFilterImpl.kinds.length; ++i) {
                String string = Utils.getCsmDeclarationKindkey(kindFilterImpl.kinds[i]);
                object.addAll(namespaceImpl.findUidsByPrefix(string));
            }
            if (nameFilterImpl.allowEmptyName) {
                object.addAll(namespaceImpl.getUnnamedUids());
            }
            return new LazyCsmCollection(object, true).iterator(csmFilter);
        }
        if (kindFilterImpl != null) {
            object = new ArrayList();
            for (int i = 0; i < kindFilterImpl.kinds.length; ++i) {
                String string = Utils.getCsmDeclarationKindkey(kindFilterImpl.kinds[i]);
                object.addAll(namespaceImpl.findUidsByPrefix(string));
            }
            return new LazyCsmCollection(object, true).iterator(csmFilter);
        }
        return null;
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition csmNamespaceDefinition, CsmSelect.CsmFilter csmFilter) {
        if (csmNamespaceDefinition instanceof NamespaceDefinitionImpl) {
            return ((NamespaceDefinitionImpl)csmNamespaceDefinition).getDeclarations(csmFilter);
        }
        return csmNamespaceDefinition.getDeclarations().iterator();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile csmFile, CsmSelect.CsmFilter csmFilter) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getDeclarations(csmFilter);
        }
        return csmFile.getDeclarations().iterator();
    }

    public Iterator<CsmVariable> getStaticVariables(CsmFile csmFile, CsmSelect.CsmFilter csmFilter) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getStaticVariableDeclarations(csmFilter);
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<CsmFunction> getStaticFunctions(CsmFile csmFile, CsmSelect.CsmFilter csmFilter) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getStaticFunctionDeclarations(csmFilter);
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<CsmMember> getClassMembers(CsmClass csmClass, CsmSelect.CsmFilter csmFilter) {
        if (csmClass instanceof ClassImpl) {
            return ((ClassImpl)csmClass).getMembers(csmFilter);
        }
        return csmClass.getMembers().iterator();
    }

    static class FilterBuilder
    implements CsmSelect.CsmFilterBuilder {
        FilterBuilder() {
        }

        public CsmSelect.CsmFilter createKindFilter(CsmDeclaration.Kind[] kindArray) {
            return new KindFilterImpl(kindArray);
        }

        public CsmSelect.CsmFilter createNameFilter(String string, boolean bl, boolean bl2, boolean bl3) {
            return new NameFilterImpl(bl3, string, bl, bl2);
        }

        public CsmSelect.CsmFilter createOffsetFilter(int n, int n2) {
            return new OffsetFilterImpl(n, n2);
        }

        public CsmSelect.CsmFilter createCompoundFilter(CsmSelect.CsmFilter csmFilter, CsmSelect.CsmFilter csmFilter2) {
            return new CompoundFilterImpl(csmFilter, csmFilter2);
        }

        public CsmSelect.CsmFilter createNameFilter(CsmSelect.NameAcceptor nameAcceptor) {
            return new NameAcceptorFilterImpl(nameAcceptor);
        }

        private static class NameAcceptorFilterImpl
        implements Filter {
            private final CsmSelect.NameAcceptor nameAcceptor;

            public NameAcceptorFilterImpl(CsmSelect.NameAcceptor nameAcceptor) {
                this.nameAcceptor = nameAcceptor;
            }

            public boolean accept(CsmUID csmUID) {
                CharSequence charSequence = UIDUtilities.getName((CsmUID<CsmOffsetableDeclaration>)csmUID);
                return this.nameAcceptor.accept(charSequence);
            }
        }

        private static class CompoundFilterImpl
        implements Filter {
            private final CsmSelect.CsmFilter first;
            private final CsmSelect.CsmFilter second;

            public CompoundFilterImpl(CsmSelect.CsmFilter csmFilter, CsmSelect.CsmFilter csmFilter2) {
                this.first = csmFilter;
                this.second = csmFilter2;
            }

            public boolean accept(CsmUID csmUID) {
                return ((UIDFilter)this.first).accept(csmUID) && ((UIDFilter)this.second).accept(csmUID);
            }

            public String toString() {
                return "filter [" + this.first + "][" + this.second + "]";
            }
        }

        private static class OffsetFilterImpl
        implements Filter {
            private final int startOffset;
            private final int endOffset;

            public OffsetFilterImpl(int n, int n2) {
                this.startOffset = n;
                this.endOffset = n2;
            }

            public boolean accept(CsmUID csmUID) {
                int n = UIDUtilities.getStartOffset((CsmUID<CsmOffsetableDeclaration>)csmUID);
                int n2 = UIDUtilities.getEndOffset((CsmUID<CsmOffsetableDeclaration>)csmUID);
                if (n < 0) {
                    return true;
                }
                return n2 >= this.startOffset && n < this.endOffset;
            }

            public String toString() {
                return "start offset=" + this.startOffset + "; endOffset=" + this.endOffset;
            }
        }

        private static class NameFilterImpl
        implements Filter {
            private final boolean allowEmptyName;
            private final String strPrefix;
            private final boolean match;
            private final boolean caseSensitive;

            public NameFilterImpl(boolean bl, String string, boolean bl2, boolean bl3) {
                this.allowEmptyName = bl;
                this.strPrefix = string;
                this.match = bl2;
                this.caseSensitive = bl3;
            }

            public boolean accept(CsmUID csmUID) {
                CharSequence charSequence = UIDUtilities.getName((CsmUID<CsmOffsetableDeclaration>)csmUID);
                if (charSequence != null) {
                    if (this.allowEmptyName && charSequence.length() == 0) {
                        return true;
                    }
                    return CsmSortUtilities.matchName((CharSequence)charSequence, (CharSequence)this.strPrefix, (boolean)this.match, (boolean)this.caseSensitive);
                }
                return false;
            }

            public String toString() {
                return "pref=" + this.strPrefix + "; match=" + this.match + "; cs=" + this.caseSensitive + "; allowEmpty=" + this.allowEmptyName;
            }
        }

        private static class KindFilterImpl
        implements Filter {
            private final CsmDeclaration.Kind[] kinds;

            public KindFilterImpl(CsmDeclaration.Kind[] kindArray) {
                this.kinds = kindArray;
            }

            public boolean accept(CsmUID csmUID) {
                CsmDeclaration.Kind kind = UIDUtilities.getKind((CsmUID<CsmOffsetableDeclaration>)csmUID);
                if (kind != null) {
                    for (CsmDeclaration.Kind kind2 : this.kinds) {
                        if (kind2 != kind) continue;
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return Arrays.asList(this.kinds).toString();
            }
        }
    }

    private static interface Filter
    extends CsmSelect.CsmFilter,
    UIDFilter {
    }
}

