/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelResolverImpl
extends CsmLabelResolver {
    public Collection<CsmReference> getLabels(CsmFunctionDefinition csmFunctionDefinition, CharSequence charSequence, CsmLabelResolver.LabelKind labelKind) {
        Context context = new Context(csmFunctionDefinition, charSequence, labelKind);
        if (csmFunctionDefinition != null) {
            this.processInnerStatements((CsmStatement)csmFunctionDefinition.getBody(), context);
        }
        return context.collection;
    }

    private void processInnerStatements(CsmStatement csmStatement, Context context) {
        if (csmStatement != null) {
            switch (csmStatement.getKind()) {
                case LABEL: {
                    context.addLabelDefinition((CsmLabel)csmStatement);
                    break;
                }
                case GOTO: {
                    context.addLabelReference((CsmGotoStatement)csmStatement);
                    break;
                }
                case COMPOUND: {
                    for (CsmStatement csmStatement2 : ((CsmCompoundStatement)csmStatement).getStatements()) {
                        this.processInnerStatements(csmStatement2, context);
                    }
                    break;
                }
                case WHILE: 
                case DO_WHILE: 
                case FOR: {
                    this.processInnerStatements(((CsmLoopStatement)csmStatement).getBody(), context);
                    break;
                }
                case IF: {
                    this.processInnerStatements(((CsmIfStatement)csmStatement).getThen(), context);
                    this.processInnerStatements(((CsmIfStatement)csmStatement).getElse(), context);
                    break;
                }
            }
        }
    }

    private static class Context {
        private Collection<CsmReference> collection = new ArrayList<CsmReference>();
        private CharSequence label;
        private CsmLabelResolver.LabelKind kind;
        private CsmFunctionDefinition owner;

        private Context(CsmFunctionDefinition csmFunctionDefinition, CharSequence charSequence, CsmLabelResolver.LabelKind labelKind) {
            this.label = charSequence;
            this.kind = labelKind;
            this.owner = csmFunctionDefinition;
        }

        private void addLabelDefinition(CsmLabel csmLabel) {
            if (!(this.kind != CsmLabelResolver.LabelKind.Both && this.kind != CsmLabelResolver.LabelKind.Definiton || this.label != null && CharSequenceKey.Comparator.compare(this.label, csmLabel.getLabel()) != 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmLabel));
            }
        }

        private void addLabelReference(CsmGotoStatement csmGotoStatement) {
            if (!(this.kind != CsmLabelResolver.LabelKind.Both && this.kind != CsmLabelResolver.LabelKind.Reference || this.label != null && CharSequenceKey.Comparator.compare(this.label, csmGotoStatement.getLabel()) != 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmGotoStatement));
            }
        }
    }
}

