/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import antlr.TokenStream;
import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyCompoundStatementImpl
extends StatementBase
implements CsmCompoundStatement {
    private SoftReference<List> statements = null;

    public LazyCompoundStatementImpl(AST aST, CsmFile csmFile, CsmFunction csmFunction) {
        super(aST, csmFile, (CsmScope)csmFunction);
        assert (aST.getType() == 290);
        aST.setFirstChild(null);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public List<CsmStatement> getStatements() {
        if (this.statements == null) {
            return this.createStatements();
        }
        List list = this.statements.get();
        return list == null ? this.createStatements() : list;
    }

    public List createStatements() {
        ArrayList arrayList = new ArrayList();
        if (this.renderStatements(arrayList)) {
            this.statements = new SoftReference(arrayList);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean renderStatements(List list) {
        FileImpl fileImpl = (FileImpl)this.getContainingFile();
        TokenStream tokenStream = fileImpl.getTokenStream(this.getStartOffset(), this.getEndOffset());
        if (tokenStream == null) {
            Utils.LOG.severe("Can't create compound statement: can't create token stream for file " + fileImpl.getAbsolutePath());
            return false;
        }
        AST aST = this.resolveLazyCompoundStatement(tokenStream);
        fileImpl.releaseTokenStream(tokenStream);
        this.renderStatements(aST, list);
        return true;
    }

    private void renderStatements(AST aST, List list) {
        AST aST2 = aST = aST == null ? null : aST.getFirstChild();
        while (aST != null) {
            StatementBase statementBase = AstRenderer.renderStatement(aST, this.getContainingFile(), (CsmScope)this);
            if (statementBase != null) {
                list.add(statementBase);
            }
            aST = aST.getNextSibling();
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getStatements();
    }

    private AST resolveLazyCompoundStatement(TokenStream tokenStream) {
        int n = 8;
        if (!TraceFlags.REPORT_PARSING_ERRORS || TraceFlags.DEBUG) {
            n |= 4;
        }
        CPPParserEx cPPParserEx = CPPParserEx.getInstance(((Object)this.getContainingFile().getName()).toString(), tokenStream, n);
        cPPParserEx.setLazyCompound(false);
        cPPParserEx.compound_statement();
        AST aST = cPPParserEx.getAST();
        return aST;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
    }

    public LazyCompoundStatementImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.statements = null;
    }
}

