/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public class ParserThread
implements Runnable {
    private boolean stopped = false;

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace("started");
        }
        ParserQueue parserQueue = ParserQueue.instance();
        while (!this.stopped) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                this.trace("polling queue");
            }
            try {
                ParserQueue.Entry entry = parserQueue.poll();
                if (entry == null) {
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("waiting");
                    }
                    parserQueue.waitReady();
                    continue;
                }
                FileImpl fileImpl = entry.getFile();
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    this.trace("parsing started: " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
                Diagnostic.StopWatch stopWatch = TraceFlags.TIMING_PARSE_PER_FILE_FLAT && !fileImpl.isParsed() ? new Diagnostic.StopWatch() : null;
                APTPreprocHandler aPTPreprocHandler = null;
                try {
                    if (fileImpl.getProjectImpl().isDisposing()) continue;
                    APTPreprocHandler.State state = entry.getPreprocState();
                    if (state != null) {
                        aPTPreprocHandler = fileImpl.getProjectImpl().createEmptyPreprocHandler(fileImpl.getBuffer().getFile());
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            System.err.println("before ensureParse on " + fileImpl.getAbsolutePath() + ParserQueue.tracePreprocState(state));
                        }
                        aPTPreprocHandler.setState(state);
                    }
                    fileImpl.ensureParsed(aPTPreprocHandler);
                }
                catch (Throwable throwable) {
                    DiagnosticExceptoins.register(throwable);
                }
                finally {
                    if (stopWatch != null) {
                        stopWatch.stopAndReport("parsing " + fileImpl.getAbsolutePath());
                    }
                    try {
                        parserQueue.onFileParsingFinished(fileImpl);
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("parsing done: " + fileImpl.getAbsolutePath());
                        }
                        Notificator.instance().flush();
                        if (!TraceFlags.TRACE_PARSER_QUEUE) continue;
                        this.trace("model event flushed");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (!TraceFlags.TRACE_PARSER_QUEUE) break;
                this.trace("interrupted");
                break;
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace(this.stopped ? "stopped" : "finished");
        }
    }

    private void trace(String string) {
        System.err.println(Thread.currentThread().getName() + ": " + string);
    }
}

