/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private Map<CsmUID<CsmFile>, NodeLink> graph;

    public GraphContainer(ProjectBase projectBase) {
        super(new GraphContainerKey(((Object)projectBase.getUniqueName()).toString()));
        this.graph = new HashMap<CsmUID<CsmFile>, NodeLink>();
        this.put();
    }

    public GraphContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        assert (dataInput != null);
        this.graph = new HashMap<CsmUID<CsmFile>, NodeLink>();
        GraphContainer.readUIDToNodeLinkMap(dataInput, this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(CsmFile csmFile) {
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                CsmUID<CsmFile> csmUID2;
                CsmUID csmUID3;
                NodeLink nodeLink = this.graph.get(csmUID);
                if (nodeLink != null) {
                    Set set = nodeLink.getOutLinks();
                    CsmInclude csmInclude = set.iterator();
                    while (csmInclude.hasNext()) {
                        csmUID3 = (CsmUID)csmInclude.next();
                        csmUID2 = this.graph.get(csmUID3);
                        if (csmUID2 == null) continue;
                        ((NodeLink)csmUID2).removeInLink((CsmUID<CsmFile>)csmUID);
                    }
                    set.clear();
                } else {
                    nodeLink = new NodeLink();
                    this.graph.put(csmUID, nodeLink);
                }
                for (CsmInclude csmInclude : csmFile.getIncludes()) {
                    csmUID3 = csmInclude.getIncludeFile();
                    if (csmUID3 == null) continue;
                    csmUID2 = UIDCsmConverter.fileToUID((CsmFile)csmUID3);
                    NodeLink nodeLink2 = this.graph.get(csmUID2);
                    if (nodeLink2 == null) {
                        nodeLink2 = new NodeLink();
                        this.graph.put(csmUID2, nodeLink2);
                    }
                    nodeLink.addOutLink((CsmUID<CsmFile>)csmUID2);
                    nodeLink2.addInLink((CsmUID<CsmFile>)csmUID);
                }
            }
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(CsmFile csmFile) {
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                NodeLink nodeLink = this.graph.get(csmUID);
                if (nodeLink != null) {
                    NodeLink nodeLink2;
                    Object object2;
                    Set set = nodeLink.getInLinks();
                    for (Object object2 : set) {
                        nodeLink2 = this.graph.get(object2);
                        if (nodeLink2 == null) continue;
                        nodeLink2.removeOutLink((CsmUID<CsmFile>)csmUID);
                    }
                    set.clear();
                    Set set2 = nodeLink.getOutLinks();
                    object2 = set2.iterator();
                    while (object2.hasNext()) {
                        nodeLink2 = (CsmUID)object2.next();
                        NodeLink nodeLink3 = this.graph.get(nodeLink2);
                        if (nodeLink3 == null) continue;
                        nodeLink3.removeInLink((CsmUID<CsmFile>)csmUID);
                    }
                    set2.clear();
                    this.graph.remove(csmUID);
                }
            }
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getIncludedFiles(CsmFile csmFile) {
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                this.getIncludedFiles(hashSet, csmUID);
            }
        }
        return this.convertToFiles(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getParentFiles(CsmFile csmFile) {
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                this.getParentFiles(hashSet, csmUID);
            }
        }
        return this.convertToFiles(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getTopParentFiles(CsmFile csmFile) {
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                this.getParentFiles(hashSet, csmUID);
                if (hashSet.size() == 0) {
                    hashSet.add(csmUID);
                }
                ArrayList<CsmUID<CsmFile>> arrayList = new ArrayList<CsmUID<CsmFile>>(hashSet);
                hashSet.clear();
                for (CsmUID csmUID2 : arrayList) {
                    NodeLink nodeLink = this.graph.get(csmUID2);
                    if (nodeLink == null || nodeLink.getInLinks().size() != 0) continue;
                    hashSet.add((CsmUID<CsmFile>)csmUID2);
                }
            }
        }
        return this.convertToFiles(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getCoherenceFiles(CsmFile csmFile) {
        CsmProject csmProject = csmFile.getProject();
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                this.getParentFiles(hashSet, csmUID);
                if (hashSet.size() == 0) {
                    hashSet.add(csmUID);
                }
                for (CsmUID<CsmFile> csmUID2 : new ArrayList<CsmUID<CsmFile>>(hashSet)) {
                    this.getIncludedFiles(hashSet, csmUID2);
                }
            }
        }
        return this.convertToFiles(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getInLinks(CsmFile csmFile) {
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                NodeLink nodeLink = this.graph.get(csmUID);
                if (nodeLink != null) {
                    for (CsmUID csmUID2 : nodeLink.getInLinks()) {
                        if (hashSet.contains(csmUID2)) continue;
                        hashSet.add((CsmUID<CsmFile>)csmUID2);
                    }
                }
            }
        }
        return this.convertToFiles(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmFile> getOutLinks(CsmFile csmFile) {
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        CsmUID<CsmFile> csmUID = UIDCsmConverter.fileToUID(csmFile);
        if (csmUID != null) {
            Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
            synchronized (map) {
                NodeLink nodeLink = this.graph.get(csmUID);
                if (nodeLink != null) {
                    for (CsmUID csmUID2 : nodeLink.getOutLinks()) {
                        if (hashSet.contains(csmUID2)) continue;
                        hashSet.add((CsmUID<CsmFile>)csmUID2);
                    }
                }
            }
        }
        return this.convertToFiles(hashSet);
    }

    private Set<CsmFile> convertToFiles(Set<CsmUID<CsmFile>> set) {
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        for (CsmUID<CsmFile> csmUID : set) {
            CsmFile csmFile = UIDCsmConverter.UIDtoFile(csmUID);
            if (csmFile == null) continue;
            hashSet.add(csmFile);
        }
        return hashSet;
    }

    private void getIncludedFiles(Set<CsmUID<CsmFile>> set, CsmUID<CsmFile> csmUID) {
        NodeLink nodeLink = this.graph.get(csmUID);
        if (nodeLink != null) {
            for (CsmUID csmUID2 : nodeLink.getOutLinks()) {
                if (set.contains(csmUID2)) continue;
                set.add((CsmUID<CsmFile>)csmUID2);
                this.getIncludedFiles(set, (CsmUID<CsmFile>)csmUID2);
            }
        }
    }

    private void getParentFiles(Set<CsmUID<CsmFile>> set, CsmUID<CsmFile> csmUID) {
        NodeLink nodeLink = this.graph.get(csmUID);
        if (nodeLink != null) {
            for (CsmUID csmUID2 : nodeLink.getInLinks()) {
                if (set.contains(csmUID2)) continue;
                set.add((CsmUID<CsmFile>)csmUID2);
                this.getParentFiles(set, (CsmUID<CsmFile>)csmUID2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
        synchronized (map) {
            this.graph.clear();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        Map<CsmUID<CsmFile>, NodeLink> map = this.graph;
        synchronized (map) {
            GraphContainer.writeUIDToNodeLinkMap(dataOutput, this.graph);
        }
    }

    private static void writeUIDToNodeLinkMap(DataOutput dataOutput, Map<CsmUID<CsmFile>, NodeLink> map) throws IOException {
        assert (dataOutput != null);
        assert (map != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null);
        dataOutput.writeInt(map.size());
        Set<Map.Entry<CsmUID<CsmFile>, NodeLink>> set = map.entrySet();
        for (Map.Entry<CsmUID<CsmFile>, NodeLink> entry : set) {
            assert (entry != null);
            uIDObjectFactory.writeUID(entry.getKey(), dataOutput);
            entry.getValue().write(dataOutput);
        }
    }

    private static void readUIDToNodeLinkMap(DataInput dataInput, Map<CsmUID<CsmFile>, NodeLink> map) throws IOException {
        assert (dataInput != null);
        assert (map != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null);
        map.clear();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CsmUID csmUID = uIDObjectFactory.readUID(dataInput);
            NodeLink nodeLink = new NodeLink(dataInput);
            assert (csmUID != null);
            assert (nodeLink != null);
            map.put((CsmUID<CsmFile>)csmUID, nodeLink);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeLink
    implements SelfPersistent,
    Persistent {
        Set<CsmUID<CsmFile>> in = new HashSet<CsmUID<CsmFile>>();
        Set<CsmUID<CsmFile>> out = new HashSet<CsmUID<CsmFile>>();

        private NodeLink() {
        }

        private NodeLink(DataInput dataInput) throws IOException {
            assert (dataInput != null);
            assert (this.in != null);
            assert (this.out != null);
            UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
            assert (uIDObjectFactory != null);
            uIDObjectFactory.readUIDCollection(this.in, dataInput);
            uIDObjectFactory.readUIDCollection(this.out, dataInput);
        }

        private void addInLink(CsmUID<CsmFile> csmUID) {
            this.in.add(csmUID);
        }

        private void removeInLink(CsmUID<CsmFile> csmUID) {
            this.in.remove(csmUID);
        }

        private Set<CsmUID<CsmFile>> getInLinks() {
            return this.in;
        }

        private void addOutLink(CsmUID<CsmFile> csmUID) {
            this.out.add(csmUID);
        }

        private void removeOutLink(CsmUID<CsmFile> csmUID) {
            this.out.remove(csmUID);
        }

        private Set<CsmUID<CsmFile>> getOutLinks() {
            return this.out;
        }

        public void write(DataOutput dataOutput) throws IOException {
            assert (dataOutput != null);
            assert (this.in != null);
            assert (this.out != null);
            UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
            assert (uIDObjectFactory != null);
            uIDObjectFactory.writeUIDCollection(this.in, dataOutput, false);
            uIDObjectFactory.writeUIDCollection(this.out, dataOutput, false);
        }
    }
}

