/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private final Object lock = new Object();
    private Map<CharSequence, MyFile> myFiles = new ConcurrentHashMap<CharSequence, MyFile>();
    private Map<CharSequence, Object> canonicFiles = new ConcurrentHashMap<CharSequence, Object>();

    public FileContainer(ProjectBase projectBase) {
        super(new FileContainerKey(((Object)projectBase.getUniqueName()).toString()));
        this.put();
    }

    public FileContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        FileContainer.readStringToMyFileMap(dataInput, this.myFiles);
        FileContainer.readStringToStringsArrMap(dataInput, this.canonicFiles);
    }

    private void trace(Map<String, Object> map, String string) {
        System.err.printf("%s\n", string);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            System.err.printf("%s ->\n%s\n\n", entry.getKey(), entry.getValue());
        }
    }

    public void putFile(File file, FileImpl fileImpl, APTPreprocHandler.State state) {
        String string = FileContainer.getFileKey(file, true);
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)fileImpl);
        MyFile myFile = new MyFile(csmUID, state, string);
        MyFile myFile2 = this.myFiles.put(string, myFile);
        this.addAlternativeFileKey(string, myFile.canonical);
        if (myFile2 != null) {
            System.err.println("Replace file " + file.getAbsoluteFile());
        }
        this.put();
    }

    public void removeFile(File file) {
        String string = FileContainer.getFileKey(file, false);
        MyFile myFile = this.myFiles.remove(string);
        if (myFile != null) {
            this.removeAlternativeFileKey(myFile.canonical, string);
        }
        if (myFile == null || myFile.fileNew != null) {
            // empty if block
        }
        this.put();
    }

    public FileImpl getFile(File file) {
        MyFile myFile = this.getMyFile(file, false);
        if (myFile == null) {
            return null;
        }
        CsmUID csmUID = myFile.fileNew;
        FileImpl fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)myFile.fileNew);
        if (fileImpl == null) {
            DiagnosticExceptoins.register(new IllegalStateException("no file for UID " + csmUID));
        }
        return fileImpl;
    }

    public void putPreprocState(File file, APTPreprocHandler.State state) {
        MyFile myFile = this.getMyFile(file, true);
        if (myFile == null) {
            return;
        }
        if (myFile.state == null || !myFile.state.isValid()) {
            myFile.state = state;
        } else if (myFile.state.isCompileContext()) {
            if (state.isCompileContext()) {
                myFile.state = state;
            } else if (TRACE_PP_STATE_OUT) {
                System.err.println("Do not reset correct state to incorrect " + file.getAbsolutePath());
            }
        } else {
            myFile.state = state;
        }
        if (TRACE_PP_STATE_OUT) {
            String string = FileContainer.getFileKey(file, false);
            System.err.println("\nPut state for file" + string + "\n");
            System.err.println(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePreprocState(File file) {
        MyFile myFile = this.getMyFile(file, false);
        if (myFile == null) {
            return;
        }
        Object object = this.getLock(file);
        synchronized (object) {
            if (myFile.state != null) {
                myFile.state = APTHandlersSupport.createInvalidPreprocState((APTPreprocHandler.State)myFile.state);
            }
        }
        if (TRACE_PP_STATE_OUT) {
            object = FileContainer.getFileKey(file, false);
            System.err.println("\nInvalidated state for file" + (String)object + "\n");
        }
    }

    public APTPreprocHandler.State getPreprocState(File file) {
        MyFile myFile = this.getMyFile(file, false);
        if (myFile == null) {
            return null;
        }
        return myFile.state;
    }

    public Object getLock(File file) {
        MyFile myFile = this.getMyFile(file, false);
        if (myFile == null) {
            return this.lock;
        }
        return myFile;
    }

    public void clearState() {
        ArrayList<MyFile> arrayList = new ArrayList<MyFile>(this.myFiles.values());
        for (MyFile myFile : arrayList) {
            myFile.state = null;
        }
        this.put();
    }

    public Collection<CsmFile> getFiles() {
        ArrayList arrayList = new ArrayList(this.myFiles.values().size());
        this.getFiles2(arrayList);
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public Collection<FileImpl> getFileImpls() {
        ArrayList arrayList = new ArrayList(this.myFiles.values().size());
        this.getFiles2(arrayList);
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    private void getFiles2(List<CsmUID<CsmFile>> list) {
        ArrayList<MyFile> arrayList = new ArrayList<MyFile>(this.myFiles.values());
        for (MyFile myFile : arrayList) {
            list.add((CsmUID<CsmFile>)myFile.fileNew);
        }
    }

    public void clear() {
        this.myFiles.clear();
        this.put();
    }

    public int getSize() {
        return this.myFiles.size();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        FileContainer.writeStringToMyFileMap(dataOutput, this.myFiles);
        FileContainer.writeStringToStringsArrMap(dataOutput, this.canonicFiles);
    }

    public void read(DataInput dataInput) throws IOException {
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        HashMap hashMap = new HashMap();
        HashMap<CharSequence, APTPreprocHandler.State> hashMap2 = new HashMap<CharSequence, APTPreprocHandler.State>();
        uIDObjectFactory.readStringToUIDMap(hashMap, dataInput, FilePathCache.getManager());
        PersistentUtils.readStringToStateMap(hashMap2, dataInput);
        this.myFiles.clear();
        System.err.println("NEED TO UPDATE DESERIALIZATION");
        for (Map.Entry entry : hashMap.entrySet()) {
            APTPreprocHandler.State state = hashMap2.get(entry.getValue());
            MyFile myFile = new MyFile(entry.getValue(), state, entry.getKey());
            this.myFiles.put(entry.getKey(), myFile);
        }
    }

    public static String getFileKey(File file, boolean bl) {
        String string = null;
        if (TraceFlags.USE_CANONICAL_PATH) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
        } else {
            string = file.getAbsolutePath();
        }
        return bl ? ((Object)FilePathCache.getString((CharSequence)string)).toString() : string;
    }

    private String getAlternativeFileKey(String string) {
        Object object = this.canonicFiles.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            assert (((String[])object).length >= 2);
            return ((String[])object)[0];
        }
        return null;
    }

    private MyFile getMyFile(File file, boolean bl) {
        String string = FileContainer.getFileKey(file, bl);
        MyFile myFile = this.myFiles.get(string);
        if (myFile == null) {
            String string2 = this.getAlternativeFileKey(string);
            MyFile myFile2 = myFile = string2 == null ? null : this.myFiles.get(string2);
            if (myFile != null && TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("alternative for " + string + " is " + string2);
            }
        }
        return myFile;
    }

    private void addAlternativeFileKey(String stringArray, CharSequence charSequence) {
        String[] stringArray2;
        Object object = this.canonicFiles.get(charSequence);
        if (object == null) {
            stringArray2 = stringArray;
        } else if (object instanceof String) {
            if (object.equals(stringArray)) {
                return;
            }
            stringArray2 = new String[]{(String)object, stringArray};
        } else {
            String[] stringArray3;
            for (String string : stringArray3 = (String[])object) {
                if (!string.equals(stringArray)) continue;
                return;
            }
            String[] stringArray4 = new String[stringArray3.length + 1];
            System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
            stringArray4[stringArray3.length] = stringArray;
            stringArray2 = stringArray4;
        }
        this.canonicFiles.put(charSequence, stringArray2);
        if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
            if (stringArray2 instanceof String[]) {
                System.err.println("entry for " + charSequence + " while adding " + (String)stringArray + " is " + Arrays.asList(stringArray2).toString());
            } else {
                System.err.println("entry for " + charSequence + " while adding " + (String)stringArray + " is " + stringArray2);
            }
        }
    }

    private void removeAlternativeFileKey(CharSequence charSequence, String string) {
        String[] stringArray;
        Object object = this.canonicFiles.get(charSequence);
        assert (object != null) : "no entry for " + charSequence + " of " + string;
        if (object instanceof String) {
            stringArray = null;
        } else {
            String[] stringArray2 = (String[])object;
            assert (stringArray2.length >= 2);
            if (stringArray2.length == 2) {
                stringArray = stringArray2[0].equals(string) ? stringArray2[1] : stringArray2[0];
            } else {
                String[] stringArray3 = new String[stringArray2.length - 1];
                int n = 0;
                for (String string2 : stringArray2) {
                    if (string2.equals(string)) continue;
                    stringArray3[n++] = string2;
                }
                stringArray = stringArray3;
            }
        }
        if (stringArray == null) {
            this.canonicFiles.remove(string);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("removed entry for " + charSequence + " while removing " + string);
            }
        } else {
            this.canonicFiles.put(charSequence, stringArray);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("change entry for " + charSequence + " while removing " + string + " to " + stringArray);
            }
        }
    }

    private static void writeStringToMyFileMap(DataOutput dataOutput, Map<CharSequence, MyFile> map) throws IOException {
        assert (dataOutput != null);
        assert (map != null);
        int n = map.size();
        dataOutput.writeInt(n);
        Set<Map.Entry<CharSequence, MyFile>> set = map.entrySet();
        for (Map.Entry<CharSequence, MyFile> entry : set) {
            dataOutput.writeUTF(((Object)entry.getKey()).toString());
            assert (entry.getValue() != null);
            entry.getValue().write(dataOutput);
        }
    }

    private static void readStringToMyFileMap(DataInput dataInput, Map<CharSequence, MyFile> map) throws IOException {
        assert (dataInput != null);
        assert (map != null);
        APTStringManager aPTStringManager = FilePathCache.getManager();
        map.clear();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            string = aPTStringManager == null ? string : ((Object)aPTStringManager.getString((CharSequence)string)).toString();
            MyFile myFile = new MyFile(dataInput);
            assert (string != null);
            assert (myFile != null);
            map.put(string, myFile);
        }
    }

    private static void writeStringToStringsArrMap(DataOutput dataOutput, Map<CharSequence, Object> map) throws IOException {
        assert (dataOutput != null);
        assert (map != null);
        int n = map.size();
        dataOutput.writeInt(n);
        Set<Map.Entry<CharSequence, Object>> set = map.entrySet();
        for (Map.Entry<CharSequence, Object> entry : set) {
            assert (entry != null);
            CharSequence charSequence = entry.getKey();
            Object object = entry.getValue();
            assert (charSequence != null);
            assert (object != null);
            assert (object instanceof CharSequence || object instanceof CharSequence[]);
            dataOutput.writeUTF(((Object)charSequence).toString());
            if (object instanceof String) {
                dataOutput.writeInt(1);
                dataOutput.writeUTF((String)object);
                continue;
            }
            if (!(object instanceof String[])) continue;
            String[] stringArray = (String[])object;
            dataOutput.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                dataOutput.writeUTF(stringArray[i]);
            }
        }
    }

    private static void readStringToStringsArrMap(DataInput dataInput, Map<CharSequence, Object> map) throws IOException {
        assert (dataInput != null);
        assert (map != null);
        APTStringManager aPTStringManager = FilePathCache.getManager();
        map.clear();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            String string2 = string = aPTStringManager == null ? string : ((Object)aPTStringManager.getString((CharSequence)string)).toString();
            assert (string != null);
            int n2 = dataInput.readInt();
            assert (n2 != 0);
            if (n2 == 1) {
                map.put(string, dataInput.readUTF());
                continue;
            }
            String[] stringArray = new String[n2];
            for (int j = 0; j < n2; ++j) {
                String string3 = dataInput.readUTF();
                String string4 = string3 = aPTStringManager == null ? string3 : ((Object)aPTStringManager.getString((CharSequence)string3)).toString();
                assert (string3 != null);
                stringArray[j] = string3;
            }
            map.put(string, stringArray);
        }
    }

    private static final CharSequence getCanonicalKey(CharSequence charSequence) {
        try {
            String string = new File(((Object)charSequence).toString()).getCanonicalPath();
            if (charSequence.equals(string)) {
                return charSequence;
            }
            return FilePathCache.getString((CharSequence)string);
        }
        catch (IOException iOException) {
            return charSequence;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyFile
    implements Persistent,
    SelfPersistent {
        private final CsmUID<CsmFile> fileNew;
        private final CharSequence canonical;
        private APTPreprocHandler.State state;

        private MyFile(DataInput dataInput) throws IOException {
            this.fileNew = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
            this.canonical = dataInput.readUTF();
            if (dataInput.readBoolean()) {
                this.state = PersistentUtils.readPreprocState(dataInput);
            }
        }

        private MyFile(CsmUID<CsmFile> csmUID, APTPreprocHandler.State state, CharSequence charSequence) {
            this.fileNew = csmUID;
            this.state = state;
            this.canonical = FileContainer.getCanonicalKey(charSequence);
        }

        public void write(DataOutput dataOutput) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.fileNew, dataOutput);
            dataOutput.writeUTF(((Object)this.canonical).toString());
            dataOutput.writeBoolean(this.state != null);
            if (this.state != null) {
                PersistentUtils.writePreprocState(this.state, dataOutput);
            }
        }
    }
}

