/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmFunction<T>,
Disposable,
RawNamable,
CsmTemplate {
    private static final String OPERATOR = "operator";
    private static final CharSequence NULL = CharSequenceKey.create((CharSequence)"<null>");
    private CharSequence name;
    private final CsmType returnType;
    private final List<CsmUID<CsmParameter>> parameters;
    private CharSequence signature;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence[] rawName;
    private TemplateDescriptor templateDescriptor = null;
    protected CharSequence classTemplateSuffix;
    private static final byte FLAGS_VOID_PARMLIST = 1;
    private static final byte FLAGS_STATIC = 2;
    private static final byte FLAGS_CONST = 4;
    private static final byte FLAGS_OPERATOR = 8;
    private byte flags;
    private static final boolean CHECK_SCOPE = false;

    public FunctionImpl(AST aST, CsmFile csmFile, CsmScope csmScope) throws AstRendererException {
        this(aST, csmFile, csmScope, true);
    }

    protected FunctionImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        super(aST, csmFile);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)this.initName(aST));
        this.rawName = AstUtil.getRawNameInChildren(aST);
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            this.setStatic(aST2.getType() == 48);
        } else {
            System.err.println("function ast " + aST.getText() + " without childs in file " + csmFile.getAbsolutePath());
        }
        if (!this.isStatic()) {
            for (CsmFunction object2 : ((FileImpl)csmFile).getStaticFunctionDeclarations()) {
                if (!this.name.equals(object2.getName())) continue;
                this.setStatic(true);
                break;
            }
        }
        if (csmScope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            csmScope = csmFile;
        }
        this._setScope(csmScope);
        RepositoryUtils.hang(this);
        boolean bl2 = FunctionImpl.initConst(aST);
        this.setFlags((byte)4, bl2);
        this.initTemplate(aST);
        this.returnType = this.initReturnType(aST);
        List<CsmParameter> list = this.initParameters(aST);
        this.parameters = list == null ? null : RepositoryUtils.put(list);
        if (list == null || list.size() == 0) {
            this.setFlags((byte)1, this.isVoidParameter(aST));
        } else {
            this.setFlags((byte)1, false);
        }
        if (this.name == null) {
            this.name = NULL;
        }
        if (((Object)this.name).toString().startsWith(OPERATOR) && this.name.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(this.name.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        if (bl) {
            this.registerInProject();
        }
    }

    public void setScope(CsmScope csmScope) {
        this.unregisterInProject();
        try {
            this._setScope(csmScope);
        }
        catch (AstRendererException astRendererException) {
            DiagnosticExceptoins.register(astRendererException);
        }
        this.registerInProject();
    }

    private void _setScope(CsmScope csmScope) throws AstRendererException {
        boolean bl;
        this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
        boolean bl2 = bl = this.scopeUID != null || csmScope == null;
        if (!bl) {
            throw new AstRendererException((FileImpl)this.getContainingFile(), this.getStartOffset(), "Cannot find function scope.");
        }
        this.scopeRef = null;
    }

    public boolean isPureDefinition() {
        return this.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    private boolean hasFlags(byte by) {
        return (this.flags & by) == by;
    }

    private void setFlags(byte by, boolean bl) {
        this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
    }

    public boolean isStatic() {
        return this.hasFlags((byte)2);
    }

    protected void setStatic(boolean bl) {
        this.setFlags((byte)2, bl);
    }

    private AST findParameterNode(AST aST) {
        AST aST2;
        AST aST3 = AstUtil.findChildOfType(aST, 274);
        if (aST3 != null && (aST2 = AstUtil.findSiblingOfType(aST3.getNextSibling(), 275)) != null) {
            aST3 = aST2;
        }
        return aST3;
    }

    private void initTemplate(AST aST) throws AstRendererException {
        boolean bl = false;
        boolean bl2 = false;
        switch (aST.getType()) {
            case 245: 
            case 250: 
            case 251: 
            case 265: {
                bl = true;
                break;
            }
            case 255: 
            case 257: {
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            StringBuilder stringBuilder;
            Object object;
            AST aST2;
            boolean bl3;
            Object object2;
            boolean bl4 = false;
            List<CsmTemplateParameter> list = null;
            AST aST3 = object2 = aST.getFirstChild();
            boolean bl5 = bl3 = object2 != null && object2.getType() == 31;
            if (!bl3) {
                RepositoryUtils.remove(this.getUID());
                throw new AstRendererException((FileImpl)this.getContainingFile(), this.getStartOffset(), "Template expected. " + object2 + " found.");
            }
            AST aST4 = AstUtil.findChildOfType(aST, 282);
            AST aST5 = aST2 = aST4 != null ? AstUtil.findChildOfType(aST4, 146) : null;
            if (aST2 != null) {
                Object object3 = null;
                for (object = aST2.getNextSibling(); object != null; object = object.getNextSibling()) {
                    if (object.getType() != 148) continue;
                    object3 = object;
                    break;
                }
                if (object3 != null && (object = object3.getNextSibling()) != null && object.getType() == 177) {
                    if (bl2) {
                        this.classTemplateSuffix = TemplateUtils.getSpecializationSuffix(aST4);
                    }
                    if ((stringBuilder = object2.getNextSibling()) != null && stringBuilder.getType() == 31) {
                        object2 = stringBuilder;
                        bl4 = true;
                    } else {
                        bl4 = true;
                        bl = false;
                    }
                }
            }
            int n = 0;
            if (bl4) {
                list = TemplateUtils.getTemplateParameters(aST3, this.getContainingFile(), (CsmScope)this);
                n = list.size();
            }
            object = "";
            if (bl) {
                if (bl2) {
                    object = aST4 == null ? "<>" : TemplateUtils.getSpecializationSuffix(aST4);
                } else {
                    stringBuilder = new StringBuilder();
                    TemplateUtils.addSpecializationSuffix(object2.getFirstChild(), stringBuilder);
                    object = '<' + stringBuilder.toString() + '>';
                }
                if (list != null) {
                    list.addAll(TemplateUtils.getTemplateParameters(object2, this.getContainingFile(), (CsmScope)this));
                } else {
                    list = TemplateUtils.getTemplateParameters(object2, this.getContainingFile(), (CsmScope)this);
                }
            }
            this.templateDescriptor = new TemplateDescriptor(list, (CharSequence)object, n);
        }
    }

    protected CharSequence getScopeSuffix() {
        return this.classTemplateSuffix != null ? this.classTemplateSuffix : "";
    }

    protected String initName(AST aST) {
        return FunctionImpl.findFunctionName(aST);
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequenceKey.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public boolean isVoidParameterList() {
        return this.hasFlags((byte)1);
    }

    private static String extractName(AST aST) {
        AST aST2;
        int n = aST.getType();
        if (n == 204) {
            return aST.getText();
        }
        if (n == 282 && (aST2 = AstUtil.getLastChild(aST)) != null) {
            if (aST2.getType() == 204) {
                return aST2.getText();
            }
            AST aST3 = AstUtil.findChildOfType(aST, 25);
            if (aST3 != null) {
                StringBuilder stringBuilder = new StringBuilder(aST3.getText());
                stringBuilder.append(' ');
                for (AST aST4 = aST3.getNextSibling(); aST4 != null; aST4 = aST4.getNextSibling()) {
                    stringBuilder.append(aST4.getText());
                }
                return stringBuilder.toString();
            }
            AST aST5 = aST.getFirstChild();
            if (aST5.getType() == 204) {
                return aST5.getText();
            }
        }
        return "";
    }

    private static String findFunctionName(AST aST) {
        if (CastUtils.isCast(aST)) {
            return CastUtils.getFunctionName(aST);
        }
        AST aST2 = AstUtil.findMethodName(aST);
        if (aST2 != null) {
            return FunctionImpl.extractName(aST2);
        }
        return "";
    }

    protected boolean isCStyleStatic() {
        return this.isStatic() && CsmKindUtilities.isFile((CsmObject)this.getScope());
    }

    protected void registerInProject() {
        if (this.isCStyleStatic()) {
            return;
        }
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration((CsmDeclaration)this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    protected final void setName(CharSequence charSequence) {
        this.name = QualifiedNameCache.getManager().getString(charSequence);
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmScope csmScope = this.getScope();
        if ((csmScope instanceof CsmNamespace || csmScope instanceof CsmClass || csmScope instanceof CsmNamespaceDefinition) && (charSequence = ((CsmQualifiedNamedElement)csmScope).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + this.getScopeSuffix() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        return ((Object)this.getQualifiedName()).toString() + ((Object)this.getSignature()).toString().substring(this.getName().length());
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION;
    }

    public String getDeclarationText() {
        return "";
    }

    public CsmFunctionDefinition getDefinition() {
        CsmFunctionDefinition csmFunctionDefinition;
        block5: {
            CsmProject csmProject;
            Iterator<Object> iterator;
            if (this.isCStyleStatic()) {
                CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createNameFilter(((Object)this.getName()).toString(), true, true, false);
                Iterator iterator2 = CsmSelect.getDefault().getDeclarations(this.getContainingFile(), csmFilter);
                while (iterator2.hasNext()) {
                    CsmDeclaration csmDeclaration = (CsmDeclaration)iterator2.next();
                    if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmDeclaration) || !this.getName().equals(csmDeclaration.getName())) continue;
                    CsmFunctionDefinition csmFunctionDefinition2 = (CsmFunctionDefinition)csmDeclaration;
                    if (!this.getSignature().equals(csmFunctionDefinition2.getSignature())) continue;
                    return csmFunctionDefinition2;
                }
                return null;
            }
            String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix();
            CsmProject csmProject2 = this.getContainingFile().getProject();
            csmFunctionDefinition = this.findDefinition(csmProject2, string);
            if (csmFunctionDefinition == null) {
                iterator = csmProject2.getLibraries().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (CsmProject)iterator.next(), string)) == null) {
                }
            }
            if (csmFunctionDefinition != null || !(csmProject2 instanceof ProjectBase)) break block5;
            iterator = ((ProjectBase)csmProject2).getDependentProjects().iterator();
            while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (ProjectBase)iterator.next(), string)) == null) {
            }
        }
        return csmFunctionDefinition;
    }

    private CsmFunctionDefinition findDefinition(CsmProject csmProject, String string) {
        CsmScope csmScope;
        CsmDeclaration csmDeclaration = csmProject.findDeclaration((CharSequence)string);
        if (csmDeclaration instanceof CsmFunctionDefinition) {
            return (CsmFunctionDefinition)csmDeclaration;
        }
        if (this.getParameters().size() == 0 && !this.isVoidParameterList() && CsmKindUtilities.isNamespace((CsmObject)(csmScope = this.getScope())) && ((CsmNamespace)csmScope).isGlobal() && csmProject instanceof ProjectBase) {
            String string2 = string.substring(0, string.indexOf(40) + 1);
            Collection<CsmOffsetableDeclaration> collection = ((ProjectBase)csmProject).findDeclarationsByPrefix(string2);
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
                if (ProjectBase.isCppFile(csmOffsetableDeclaration.getContainingFile())) continue;
                return (CsmFunctionDefinition)csmOffsetableDeclaration;
            }
        }
        return null;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    public boolean isInline() {
        return false;
    }

    private CsmType initReturnType(AST aST) {
        TypeImpl typeImpl = null;
        AST aST2 = FunctionImpl.getTypeToken(aST);
        if (aST2 != null) {
            typeImpl = AstRenderer.renderType(aST2, this.getContainingFile());
        }
        if (typeImpl == null) {
            typeImpl = TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
        }
        return TemplateUtils.checkTemplateType(typeImpl, (CsmScope)this);
    }

    public CsmType getReturnType() {
        return this.returnType;
    }

    private static AST getTypeToken(AST aST) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            int n = aST2.getType();
            switch (n) {
                case 253: 
                case 254: {
                    return aST2;
                }
            }
            if (!AstRenderer.isQualifier(n)) continue;
            return aST2;
        }
        return null;
    }

    private List<CsmParameter> initParameters(AST aST) {
        AST aST2 = this.findParameterNode(aST);
        return AstRenderer.renderParameters(aST2, this.getContainingFile(), (CsmScope)this);
    }

    private boolean isVoidParameter(AST aST) {
        AST aST2 = this.findParameterNode(aST);
        return AstRenderer.isVoidParameter(aST2);
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getSignature() {
        if (this.signature == null) {
            this.signature = QualifiedNameCache.getManager().getString((CharSequence)this.createSignature());
        }
        return this.signature;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return this.hasFlags((byte)8);
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        CsmFunction.OperatorKind operatorKind = CsmFunction.OperatorKind.NONE;
        if (this.isOperator()) {
            String string = ((Object)this.getName()).toString();
            int n = string.indexOf(OPERATOR);
            assert (n >= 0) : "must have word \"operator\" in name";
            String string2 = string.substring(n += OPERATOR.length()).trim();
            operatorKind = CsmFunction.OperatorKind.getKindByImage((String)string2);
        }
        return operatorKind;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        arrayList.addAll(this.getParameters());
        return arrayList;
    }

    private String createSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(this.createTemplateSignature());
        stringBuilder.append('(');
        Iterator<CsmParameter> iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            CsmParameter csmParameter = iterator.next();
            CsmType csmType = csmParameter.getType();
            if (csmType != null) {
                stringBuilder.append(csmType.getCanonicalText());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
                continue;
            }
            if (!csmParameter.isVarArgs()) continue;
            stringBuilder.append("...");
        }
        stringBuilder.append(')');
        if (this.isConst()) {
            stringBuilder.append(" const");
        }
        return stringBuilder.toString();
    }

    private String createTemplateSignature() {
        List<CsmTemplateParameter> list = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
        if (list != null) {
            int n;
            int n2 = n = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (list.size() > n) {
                Iterator<CsmTemplateParameter> iterator = list.iterator();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    iterator.next();
                }
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return this.createTemplateParamsSignature(arrayList);
    }

    private String createTemplateParamsSignature(List<CsmTemplateParameter> list) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (list != null && list.size() > 0) {
            stringBuilder.append('<');
            Iterator<CsmTemplateParameter> iterator = list.iterator();
            while (iterator.hasNext()) {
                CsmVariable csmVariable;
                CsmType csmType;
                CsmTemplateParameter csmTemplateParameter = iterator.next();
                if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmTemplateParameter) && (csmType = (csmVariable = (CsmVariable)csmTemplateParameter).getType()) != null) {
                    stringBuilder.append(csmType.getCanonicalText());
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                }
                if (!CsmKindUtilities.isClassifier((CsmObject)csmTemplateParameter)) continue;
                csmVariable = (CsmClassifier)csmTemplateParameter;
                stringBuilder.append("class");
                if (CsmKindUtilities.isTemplate((CsmObject)csmTemplateParameter)) {
                    stringBuilder.append(this.createTemplateParamsSignature(((CsmTemplate)csmVariable).getTemplateParameters()));
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope csmScope = this._getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private static boolean initConst(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 282; aST2 = aST2.getNextSibling()) {
        }
        while (aST2 != null) {
            if (AstRenderer.isConstQualifier(aST2.getType())) {
                return true;
            }
            aST2 = aST2.getNextSibling();
        }
        return false;
    }

    protected boolean isConst() {
        return this.hasFlags((byte)4);
    }

    private CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (csmScope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return csmScope;
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        Collection<CsmParameter> collection = UIDCsmConverter.UIDsToDeclarations(this.parameters);
        return collection;
    }

    private void _disposeParameters() {
        if (this.parameters != null) {
            RepositoryUtils.remove(this.parameters);
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        PersistentUtils.writeType(this.returnType, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUIDCollection(this.parameters, dataOutput, false);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
        PersistentUtils.writeUTF(this.signature, dataOutput);
        dataOutput.writeByte(this.flags);
        dataOutput.writeUTF(((Object)this.getScopeSuffix()).toString());
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
    }

    public FunctionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.returnType = PersistentUtils.readType(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.parameters = uIDObjectFactory.readUIDCollection(new ArrayList(), dataInput);
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeRef = null;
        this.signature = PersistentUtils.readUTF(dataInput);
        if (this.signature != null) {
            this.signature = QualifiedNameCache.getManager().getString(this.signature);
        }
        this.flags = dataInput.readByte();
        this.classTemplateSuffix = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
    }
}

