/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDefinitionImpl<T>
extends FunctionImplEx<T>
implements CsmFunctionDefinition<T> {
    private CsmUID<CsmFunction> declarationUID;
    private final CsmCompoundStatement body;

    public FunctionDefinitionImpl(AST aST, CsmFile csmFile, CsmScope csmScope) throws AstRendererException {
        this(aST, csmFile, csmScope, true);
    }

    protected FunctionDefinitionImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        super(aST, csmFile, csmScope, false);
        boolean bl2;
        this.body = AstRenderer.findCompoundStatement(aST, this.getContainingFile(), this);
        boolean bl3 = bl2 = this.body != null;
        if (!bl2) {
            RepositoryUtils.hang(this);
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Null body in function definition.");
        }
        if (bl) {
            this.registerInProject();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        return this.getDeclaration(null);
    }

    public CsmFunction getDeclaration(Resolver resolver) {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction == null) {
            this._setDeclaration(null);
            csmFunction = this.findDeclaration(resolver);
            this._setDeclaration(csmFunction);
        }
        return csmFunction;
    }

    private CsmFunction _getDeclaration() {
        CsmFunction csmFunction = UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
        return csmFunction;
    }

    private void _setDeclaration(CsmFunction csmFunction) {
        this.declarationUID = UIDCsmConverter.declarationToUID(csmFunction);
        assert (this.declarationUID != null || csmFunction == null);
    }

    private CsmFunction findDeclaration(Resolver resolver) {
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        CsmDeclaration csmDeclaration = this.getContainingFile().getProject().findDeclaration((CharSequence)string);
        if (csmDeclaration == null) {
            CsmObject csmObject = this.findOwner(resolver);
            if (csmObject instanceof CsmClass) {
                Iterator iterator = CsmSelect.getDefault().getClassMembers((CsmClass)csmObject, CsmSelect.getDefault().getFilterBuilder().createNameFilter(((Object)this.getName()).toString(), true, true, false));
                csmDeclaration = FunctionDefinitionImpl.findByName(iterator, this.getName());
            } else if (csmObject instanceof CsmNamespace) {
                Iterator iterator = CsmSelect.getDefault().getDeclarations((CsmNamespace)csmObject, CsmSelect.getDefault().getFilterBuilder().createNameFilter(((Object)this.getName()).toString(), true, true, false));
                csmDeclaration = FunctionDefinitionImpl.findByName(iterator, this.getName());
            }
        }
        return (CsmFunction)csmDeclaration;
    }

    private static CsmFunction findByName(Iterator iterator, CharSequence charSequence) {
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            CsmFunction csmFunction;
            Object e = iterator2.next();
            if (!CsmKindUtilities.isCsmObject(e) || !CsmKindUtilities.isFunction((CsmObject)((CsmObject)e)) || !(csmFunction = (CsmFunction)e).getName().equals(charSequence)) continue;
            return csmFunction;
        }
        return null;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    protected String findQualifiedName() {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction != null) {
            return ((Object)csmFunction.getQualifiedName()).toString();
        }
        return super.findQualifiedName();
    }

    @Override
    public CsmScope getScope() {
        return this.getContainingFile();
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> collection = super.getScopeElements();
        collection.add((CsmScopeElement)this.getBody());
        return collection;
    }

    @Override
    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeCompoundStatement(this.body, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, dataOutput);
    }

    public FunctionDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.body = PersistentUtils.readCompoundStatement(dataInput);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

