/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendClassImpl
extends OffsetableDeclarationBase<CsmFriendClass>
implements CsmFriendClass {
    private final CharSequence name;
    private final CharSequence[] nameParts;
    private final CsmUID<CsmClass> parentUID;
    private CsmUID<CsmClass> friendUID;

    public FriendClassImpl(AST aST, FileImpl fileImpl, CsmClass csmClass) {
        super(aST, fileImpl);
        this.parentUID = csmClass.getUID();
        AST aST2 = AstUtil.findSiblingOfType(aST, 282);
        this.name = aST2 == null ? CharSequenceKey.empty() : QualifiedNameCache.getManager().getString(AstRenderer.getQualifiedName(aST2));
        this.nameParts = this.initNameParts(aST2);
        this.registerInProject();
    }

    private void registerInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.parentUID.getObject();
    }

    public CsmScope getScope() {
        return this.getContainingClass();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmClass csmClass = this.getContainingClass();
        CharSequence charSequence = csmClass.getQualifiedName();
        if (charSequence != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
    }

    public CsmClass getReferencedClass() {
        return this.getReferencedClass(null);
    }

    public CsmClass getReferencedClass(Resolver resolver) {
        if (this.friendUID != null) {
            return (CsmClass)this.friendUID.getObject();
        }
        CsmObject csmObject = this.resolve(resolver);
        if (csmObject instanceof CsmClass) {
            this.friendUID = ((CsmClass)csmObject).getUID();
            return (CsmClass)csmObject;
        }
        return null;
    }

    private String[] initNameParts(AST aST) {
        if (aST != null) {
            return AstRenderer.getNameTokens(aST);
        }
        return new String[0];
    }

    private CsmObject resolve(Resolver resolver) {
        return ResolverFactory.createResolver(this, resolver).resolve(this.nameParts, 2);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unregisterInProject();
    }

    private void unregisterInProject() {
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration((CsmDeclaration)this);
        this.cleanUID();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        PersistentUtils.writeStrings(this.nameParts, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.parentUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendUID, dataOutput);
    }

    public FriendClassImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.nameParts = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.parentUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.friendUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

