/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class RunAsRemoteWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -5592669886554891271L;
    static final RemoteConfiguration NO_REMOTE_CONFIGURATION = new RemoteConfiguration(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_NoRemoteConfiguration"));
    private static final PhpProjectProperties.UploadFiles DEFAULT_UPLOAD_FILES = PhpProjectProperties.UploadFiles.MANUALLY;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton manageRemoteConnectionButton;
    private JComboBox remoteConnectionComboBox;
    private JLabel remoteConnectionHintLabel;
    private JLabel remoteConnectionLabel;
    private JComboBox runAsComboBox;
    private JLabel runAsLabel;
    private JLabel uploadDirectoryLabel;
    private JTextField uploadDirectoryTextField;
    private JComboBox uploadFilesComboBox;
    private JLabel uploadFilesHintLabel;
    private JLabel uploadFilesLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsRemoteWeb(ConfigManager configManager, SourcesFolderProvider sourcesFolderProvider) {
        this(configManager, sourcesFolderProvider, NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ConfigRemoteWeb"));
    }

    public RunAsRemoteWeb(ConfigManager configManager, SourcesFolderProvider sourcesFolderProvider, String string) {
        super(configManager);
        this.displayName = string;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.hideUploadFilesFields();
        this.labels = new JLabel[]{this.urlLabel, this.uploadDirectoryLabel, this.indexFileLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.uploadDirectoryTextField, this.indexFileTextField};
        this.propertyNames = new String[]{"url", "remoteDirectory", "indexFile"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        this.populateRemoteConnectionComboBox();
        this.remoteConnectionComboBox.setRenderer(new RemoteConnectionRenderer());
        for (PhpProjectProperties.UploadFiles uploadFiles : PhpProjectProperties.UploadFiles.values()) {
            this.uploadFilesComboBox.addItem(uploadFiles);
        }
        this.uploadFilesComboBox.setRenderer(new RemoteUploadRenderer());
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                RemoteConfiguration remoteConfiguration = (RemoteConfiguration)jComboBox.getSelectedItem();
                assert (remoteConfiguration != null);
                return remoteConfiguration.getName();
            }
        };
        this.remoteConnectionComboBox.addActionListener(new ComboBoxUpdater("remoteConnection", this.remoteConnectionLabel, this.remoteConnectionComboBox, comboBoxSelectedItemConvertor));
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor2 = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)jComboBox.getSelectedItem());
                assert (uploadFiles != null);
                RunAsRemoteWeb.this.uploadFilesHintLabel.setText(uploadFiles.getDescription());
                return uploadFiles.name();
            }
        };
        this.uploadFilesComboBox.addActionListener(new ComboBoxUpdater("remoteUpload", this.uploadFilesLabel, this.uploadFilesComboBox, comboBoxSelectedItemConvertor2));
        this.runAsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.changeSupport.fireChange();
            }
        });
        this.remoteConnectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.uploadDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.updateRemoteConnectionHint();
    }

    private void hideUploadFilesFields() {
        this.uploadFilesLabel.setVisible(false);
        this.uploadFilesComboBox.setVisible(false);
        this.uploadFilesHintLabel.setVisible(false);
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.REMOTE;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected JComboBox getRunAsCombo() {
        return this.runAsComboBox;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
        this.selectRemoteConnection();
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String string = this.getValue("remoteUpload");
        if (string == null) {
            uploadFiles = DEFAULT_UPLOAD_FILES;
        } else {
            try {
                uploadFiles = PhpProjectProperties.UploadFiles.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uploadFiles = DEFAULT_UPLOAD_FILES;
            }
        }
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
    }

    protected void validateFields() {
        this.changeSupport.fireChange();
    }

    public void addRunAsRemoteWebListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeRunAsRemoteWebListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void populateRemoteConnectionComboBox() {
        List<RemoteConfiguration> list = RemoteConnections.get().getRemoteConfigurations();
        if (list.isEmpty()) {
            list = Arrays.asList(NO_REMOTE_CONFIGURATION);
        }
        DefaultComboBoxModel<RemoteConfiguration> defaultComboBoxModel = new DefaultComboBoxModel<RemoteConfiguration>(new Vector<RemoteConfiguration>(list));
        this.remoteConnectionComboBox.setModel(defaultComboBoxModel);
    }

    private void selectRemoteConnection() {
        String string = this.getValue("remoteConnection");
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.remoteConnectionComboBox.getModel();
        if (string == null && defaultComboBoxModel.getIndexOf(NO_REMOTE_CONFIGURATION) != -1) {
            this.remoteConnectionComboBox.setSelectedItem(NO_REMOTE_CONFIGURATION);
            return;
        }
        int n = this.remoteConnectionComboBox.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getItemAt(i);
            if (string != null && !"".equals(string) && !string.equals(remoteConfiguration.getName())) continue;
            this.remoteConnectionComboBox.setSelectedItem(remoteConfiguration);
            return;
        }
        assert (false) : "Should not get here";
    }

    public String getUrl() {
        return this.urlTextField.getText().trim();
    }

    public void setUrl(String string) {
        this.urlTextField.setText(string);
    }

    public RemoteConfiguration getRemoteConfiguration() {
        return (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
    }

    public void setRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
        this.remoteConnectionComboBox.setSelectedItem(remoteConfiguration);
    }

    public String getUploadDirectory() {
        return this.uploadDirectoryTextField.getText().trim();
    }

    public void setUploadDirectory(String string) {
        this.uploadDirectoryTextField.setText(string);
    }

    public PhpProjectProperties.UploadFiles getUploadFiles() {
        return (PhpProjectProperties.UploadFiles)((Object)this.uploadFilesComboBox.getSelectedItem());
    }

    public void setUploadFiles(PhpProjectProperties.UploadFiles uploadFiles) {
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
    }

    public String getIndexFile() {
        return this.indexFileTextField.getText().trim();
    }

    public void setIndexFile(String string) {
        this.indexFileTextField.setText(string);
    }

    public void hideIndexFile() {
        this.indexFileLabel.setVisible(false);
        this.indexFileTextField.setVisible(false);
        this.indexFileBrowseButton.setVisible(false);
    }

    void updateRemoteConnectionHint() {
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
        if (remoteConfiguration == NO_REMOTE_CONFIGURATION) {
            this.remoteConnectionHintLabel.setText(" ");
            return;
        }
        this.remoteConnectionHintLabel.setText(RunAsValidator.composeUploadDirectoryHint(remoteConfiguration.getHost(), remoteConfiguration.getInitialDirectory(), this.uploadDirectoryTextField.getText()));
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.remoteConnectionLabel = new JLabel();
        this.remoteConnectionComboBox = new JComboBox();
        this.manageRemoteConnectionButton = new JButton();
        this.uploadDirectoryLabel = new JLabel();
        this.uploadDirectoryTextField = new JTextField();
        this.remoteConnectionHintLabel = new JLabel();
        this.uploadFilesLabel = new JLabel();
        this.uploadFilesComboBox = new JComboBox();
        this.uploadFilesHintLabel = new JLabel();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.runAsLabel.setLabelFor(this.runAsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ProjectUrl"));
        this.remoteConnectionLabel.setLabelFor(this.remoteConnectionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_FtpConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageRemoteConnectionButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Manage"));
        this.manageRemoteConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.manageRemoteConnectionButtonActionPerformed(actionEvent);
            }
        });
        this.uploadDirectoryLabel.setLabelFor(this.uploadDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectoryLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadDirectory"));
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionHintLabel, (String)"dummy");
        this.remoteConnectionHintLabel.setEnabled(false);
        this.uploadFilesLabel.setLabelFor(this.uploadFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadFiles"));
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesHintLabel, (String)"dummy");
        this.uploadFilesHintLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_BrowseIndex"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.remoteConnectionLabel).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadFilesLabel).add((Component)this.urlLabel).add((Component)this.runAsLabel).add((Component)this.indexFileLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionHintLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 127, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add(2, (Component)this.urlTextField, -1, 228, Short.MAX_VALUE).add((Component)this.uploadFilesHintLabel).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionComboBox, 0, 127, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.manageRemoteConnectionButton)).add((Component)this.uploadDirectoryTextField, -1, 228, Short.MAX_VALUE).add((Component)this.uploadFilesComboBox, 0, 228, Short.MAX_VALUE).add((Component)this.runAsComboBox, 0, 228, Short.MAX_VALUE)).add(0, 0, 0)))));
        groupLayout.linkSize(new Component[]{this.indexFileBrowseButton, this.manageRemoteConnectionButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsComboBox, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileLabel).add((Component)this.indexFileTextField, -2, -1, -2).add((Component)this.indexFileBrowseButton)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.remoteConnectionLabel).add((Component)this.manageRemoteConnectionButton).add((Component)this.remoteConnectionComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadDirectoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.remoteConnectionHintLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadFilesLabel).add((Component)this.uploadFilesComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.uploadFilesHintLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void manageRemoteConnectionButtonActionPerformed(ActionEvent actionEvent) {
        if (RemoteConnections.get().openManager((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem())) {
            this.populateRemoteConnectionComboBox();
            this.selectRemoteConnection();
        }
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseFolderFile(this.sourcesFolderProvider.getSourcesFolder(), this.indexFileTextField);
    }

    private static class RemoteUploadRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 86192358777523629L;

        public RemoteUploadRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof PhpProjectProperties.UploadFiles);
            this.setName("ComboBox.listRenderer");
            this.setText(((PhpProjectProperties.UploadFiles)((Object)object)).getLabel());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private static class RemoteConnectionRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 93621381917558630L;

        public RemoteConnectionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof RemoteConfiguration);
            this.setName("ComboBox.listRenderer");
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)object;
            this.setText(remoteConfiguration.getDisplayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setBackground(jList.getBackground());
            }
            this.setForeground(this.getForeground(remoteConfiguration, jList, bl));
            return this;
        }

        private Color getForeground(RemoteConfiguration remoteConfiguration, JList jList, boolean bl) {
            if (remoteConfiguration == NO_REMOTE_CONFIGURATION) {
                return UIManager.getColor("nb.errorForeground");
            }
            return bl ? jList.getSelectionForeground() : jList.getForeground();
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class ComboBoxUpdater
    implements ActionListener {
        private final JLabel label;
        private final JComboBox field;
        private final String propName;
        private final ComboBoxSelectedItemConvertor comboBoxConvertor;

        public ComboBoxUpdater(String string, JLabel jLabel, JComboBox jComboBox, ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor) {
            this.propName = string;
            this.label = jLabel;
            this.field = jComboBox;
            this.comboBoxConvertor = comboBoxSelectedItemConvertor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.comboBoxConvertor.convert(this.field);
            RunAsRemoteWeb.this.putValue(this.propName, string);
            RunAsRemoteWeb.this.markAsModified(this.label, this.propName, string);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    static interface ComboBoxSelectedItemConvertor {
        public String convert(JComboBox var1);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsRemoteWeb.this.getDefaultValue(this.getPropName());
        }
    }
}

