/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureExistingProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.ConfigureNewProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureProjectPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
SourcesFolderProvider,
ChangeListener {
    static final String PROJECT_NAME = "projectName";
    static final String PROJECT_DIR = "projectDir";
    static final String IS_PROJECT_DIR_USED = "isProjectDirUsed";
    static final String SET_AS_MAIN = "setAsMain";
    static final String SOURCES_FOLDER = "sourcesFolder";
    static final String LOCAL_SERVERS = "localServers";
    static final String ENCODING = "encoding";
    static final String ROOTS = "roots";
    private static final FilenameFilter NB_FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return "nbproject".equals(string);
        }
    };
    private final String[] steps;
    private final NewPhpProjectWizardIterator.WizardType wizardType;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private ConfigurableProjectPanel configureProjectPanelVisual = null;
    private WizardDescriptor descriptor = null;
    private String originalProjectName = null;
    private String originalSources = null;

    public ConfigureProjectPanel(String[] stringArray, NewPhpProjectWizardIterator.WizardType wizardType) {
        this.steps = stringArray;
        this.wizardType = wizardType;
    }

    public Component getComponent() {
        if (this.configureProjectPanelVisual == null) {
            switch (this.wizardType) {
                case NEW: {
                    this.configureProjectPanelVisual = new ConfigureNewProjectPanelVisual(this);
                    break;
                }
                case EXISTING: {
                    this.configureProjectPanelVisual = new ConfigureExistingProjectPanelVisual(this);
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                    break;
                }
            }
        }
        return this.configureProjectPanelVisual;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ConfigureProjectPanel.class.getName() + "." + (Object)((Object)this.wizardType));
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        this.descriptor = wizardDescriptor;
        this.removeListeners();
        switch (this.wizardType) {
            case NEW: {
                this.configureProjectPanelVisual.setProjectName(this.getProjectName());
                this.configureProjectPanelVisual.setLocalServerModel(this.getLocalServers());
                LocalServer localServer = this.getLocalServer();
                if (localServer == null) break;
                this.configureProjectPanelVisual.selectSourcesLocation(localServer);
                break;
            }
            case EXISTING: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.configureProjectPanelVisual.setProjectFolder(this.getProjectFolder().getAbsolutePath());
        this.configureProjectPanelVisual.setEncoding(this.getEncoding());
        this.addListeners();
        this.stateChanged(null);
    }

    private void addListeners() {
        this.configureProjectPanelVisual.addConfigureProjectListener(this);
    }

    private void removeListeners() {
        this.configureProjectPanelVisual.removeConfigureProjectListener(this);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(IS_PROJECT_DIR_USED, (Object)this.configureProjectPanelVisual.isProjectFolderUsed());
        wizardDescriptor.putProperty(PROJECT_DIR, (Object)FileUtil.normalizeFile((File)this.getProjectFolderFile()));
        wizardDescriptor.putProperty(PROJECT_NAME, (Object)this.configureProjectPanelVisual.getProjectName());
        wizardDescriptor.putProperty(SOURCES_FOLDER, (Object)this.configureProjectPanelVisual.getSourcesLocation());
        wizardDescriptor.putProperty(LOCAL_SERVERS, (Object)this.configureProjectPanelVisual.getLocalServerModel());
        wizardDescriptor.putProperty(ENCODING, (Object)this.configureProjectPanelVisual.getEncoding());
        wizardDescriptor.putProperty(SET_AS_MAIN, (Object)false);
    }

    public File getProjectFolderFile() {
        String string = this.configureProjectPanelVisual.getProjectFolder();
        if (string.length() == 0) {
            return null;
        }
        return new File(string);
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String string = null;
        switch (this.wizardType) {
            case NEW: {
                string = this.validateProject();
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateSources(false);
                if (string == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            case EXISTING: {
                string = this.validateSources(true);
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateProject();
                if (string == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    @Override
    public FileObject getSourcesFolder() {
        this.getComponent();
        return FileUtil.toFileObject((File)new File(this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot()));
    }

    @Override
    public String getSourcesFolderName() {
        this.getComponent();
        return this.configureProjectPanelVisual.getProjectName();
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    String[] getSteps() {
        return this.steps;
    }

    String getProjectName() {
        String string = (String)this.descriptor.getProperty(PROJECT_NAME);
        if (string == null) {
            string = this.getDefaultFreeName(ProjectChooser.getProjectsFolder());
            this.descriptor.putProperty(PROJECT_NAME, (Object)string);
            this.originalProjectName = string;
        }
        return string;
    }

    private File getProjectFolder() {
        File file = (File)this.descriptor.getProperty(PROJECT_DIR);
        if (file == null) {
            file = new File(ProjectChooser.getProjectsFolder(), this.getProjectName());
            this.descriptor.putProperty(PROJECT_DIR, (Object)file);
        }
        return file;
    }

    private String getDefaultFreeName(File file) {
        String string;
        int n = 1;
        while ((string = this.validFreeProjectName(file, n++)) == null) {
        }
        return string;
    }

    private Charset getEncoding() {
        Charset charset = (Charset)this.descriptor.getProperty(ENCODING);
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
        }
        return charset;
    }

    private LocalServer getLocalServer() {
        return (LocalServer)this.descriptor.getProperty(SOURCES_FOLDER);
    }

    private MutableComboBoxModel getLocalServers() {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.descriptor.getProperty(LOCAL_SERVERS);
        if (mutableComboBoxModel != null) {
            return mutableComboBoxModel;
        }
        return this.getOSDependentLocalServers();
    }

    private MutableComboBoxModel getOSDependentLocalServers() {
        LocalServer.ComboBoxModel comboBoxModel = new LocalServer.ComboBoxModel(new LocalServer(this.getProjectFolder().getAbsolutePath()));
        String string = this.getSourcesFolderName();
        List<PhpEnvironment.DocumentRoot> list = PhpEnvironment.get().getDocumentRoots();
        this.descriptor.putProperty(ROOTS, list);
        for (PhpEnvironment.DocumentRoot documentRoot : list) {
            LocalServer localServer = new LocalServer(documentRoot.getDocumentRoot() + File.separator + string);
            localServer.setHint(documentRoot.getHint());
            comboBoxModel.addElement(localServer);
            if (!documentRoot.isPreferred()) continue;
            comboBoxModel.setSelectedItem(localServer);
        }
        return comboBoxModel;
    }

    private String validFreeProjectName(File file, int n) {
        String string = MessageFormat.format(NbBundle.getMessage(ConfigureProjectPanel.class, (String)"TXT_DefaultProjectName"), n);
        File file2 = new File(file, string);
        if (file2.exists()) {
            return null;
        }
        return string;
    }

    private String validateProject() {
        String string = this.configureProjectPanelVisual.getProjectName();
        if (string.trim().length() == 0) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectName");
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed()) {
            return null;
        }
        File file = this.getProjectFolderFile();
        if (file == null || !Utils.isValidFileName(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectFolder");
        }
        String string2 = Utils.validateProjectDirectory(file, "Project", true, false);
        if (string2 != null) {
            return string2;
        }
        if (this.isProjectAlready(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectAlreadyProject");
        }
        this.warnIfNotEmpty(file.getAbsolutePath(), "Project");
        return null;
    }

    private boolean isProjectAlready(File file) {
        if (!file.exists()) {
            return false;
        }
        File[] fileArray = file.listFiles(NB_FILENAME_FILTER);
        return fileArray != null && fileArray.length > 0;
    }

    private String validateSources(boolean bl) {
        String string = null;
        LocalServer localServer = this.configureProjectPanelVisual.getSourcesLocation();
        String string2 = localServer.getSrcRoot();
        File file = FileUtil.normalizeFile((File)new File(string2));
        if (string2.trim().length() == 0 || !Utils.isValidFileName(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
        }
        string = Utils.validateProjectDirectory(string2, "Sources", true, true);
        if (string != null) {
            return string;
        }
        if (bl) {
            if (!file.isDirectory()) {
                return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
            }
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesEmpty");
            }
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed() && this.isProjectAlready(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesAlreadyProject");
        }
        string = this.validateSourcesAndCopyTarget();
        if (string != null) {
            return string;
        }
        switch (this.wizardType) {
            case NEW: {
                this.warnIfNotEmpty(string2, "Sources");
            }
        }
        return null;
    }

    private String validateSourcesAndCopyTarget() {
        Boolean bl = (Boolean)this.descriptor.getProperty("valid");
        if (bl != null && !bl.booleanValue()) {
            return null;
        }
        Boolean bl2 = (Boolean)this.descriptor.getProperty("copySrcFiles");
        if (bl2 == null || !bl2.booleanValue()) {
            return null;
        }
        LocalServer localServer = this.configureProjectPanelVisual.getSourcesLocation();
        String string = localServer.getSrcRoot();
        LocalServer localServer2 = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        File file = FileUtil.normalizeFile((File)new File(localServer2.getSrcRoot()));
        String string2 = file.getAbsolutePath();
        return Utils.validateSourcesAndCopyTarget(string, string2);
    }

    private void warnIfNotEmpty(String string, String string2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            String string3 = NbBundle.getMessage(ConfigureProjectPanel.class, (String)("MSG_" + string2 + "NotEmpty"));
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
        }
    }

    private void projectNameChanged() {
        assert (this.originalProjectName != null);
        String string = this.configureProjectPanelVisual.getProjectName();
        if (string.length() == 0) {
            return;
        }
        if (this.originalProjectName.equals(string)) {
            return;
        }
        this.adjustProjectFolder(this.originalProjectName, string);
        this.adjustSources(this.originalProjectName, string);
        this.originalProjectName = string;
    }

    private void adjustProjectFolder(String string, String string2) {
        File file = this.getProjectFolderFile();
        if (file == null) {
            return;
        }
        String string3 = file.getName();
        if (!string.equals(string3)) {
            return;
        }
        File file2 = new File(file.getParentFile(), string2);
        this.configureProjectPanelVisual.setProjectFolder(file2.getAbsolutePath());
    }

    private void adjustSources(String string, String string2) {
        LocalServer.ComboBoxModel comboBoxModel = (LocalServer.ComboBoxModel)this.configureProjectPanelVisual.getLocalServerModel();
        boolean bl = false;
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            LocalServer localServer = comboBoxModel.getElementAt(i);
            File file = new File(localServer.getSrcRoot());
            if (!string.equals(file.getName())) continue;
            File file2 = new File(file.getParentFile(), string2);
            localServer.setSrcRoot(file2.getAbsolutePath());
            bl = true;
        }
        if (bl) {
            comboBoxModel.fireContentsChanged();
        }
    }

    private void sourceFolderchanged() {
        String string;
        String string2;
        String string3 = this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot();
        if (string3.length() == 0) {
            return;
        }
        if (string3.equals(this.originalSources)) {
            return;
        }
        if (this.originalSources != null && !(string2 = new File(this.originalSources).getName()).equals(string = this.configureProjectPanelVisual.getProjectName())) {
            this.originalSources = string3;
            return;
        }
        this.originalSources = string3;
        string2 = new File(string3).getName();
        this.configureProjectPanelVisual.setProjectName(string2);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.removeListeners();
        switch (this.wizardType) {
            case NEW: {
                this.projectNameChanged();
                break;
            }
            case EXISTING: {
                this.sourceFolderchanged();
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.addListeners();
        this.fireChangeEvent();
    }
}

