/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunAsPanel
extends JPanel {
    private static final long serialVersionUID = -5723489817914071L;
    private static final Font JL_PLAIN_FONT = new JLabel().getFont().deriveFont(0);
    private static final Font JL_BOLD_FONT = JL_PLAIN_FONT.deriveFont(1);
    private final LinkedHashMap<String, InsidePanel> allInsidePanels;
    private final ComboModel comboBoxModel = new ComboModel();

    public RunAsPanel(InsidePanel[] insidePanelArray) {
        assert (insidePanelArray != null);
        this.allInsidePanels = new LinkedHashMap();
        for (InsidePanel insidePanel : insidePanelArray) {
            this.allInsidePanels.put(insidePanel.getDisplayName(), insidePanel);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.comboBoxModel.isInitialized) {
            Collection<InsidePanel> collection = this.allInsidePanels.values();
            this.initComboModel(collection);
            for (InsidePanel insidePanel : collection) {
                JComboBox jComboBox = insidePanel.getRunAsCombo();
                jComboBox.setModel(this.comboBoxModel);
            }
            this.comboBoxModel.setAsInitialized();
        }
    }

    private void initComboModel(Collection<InsidePanel> collection) {
        this.comboBoxModel.removeAllElements();
        for (InsidePanel insidePanel : collection) {
            this.add((Component)insidePanel, insidePanel.getDisplayName());
            this.comboBoxModel.addElement(insidePanel.getDisplayName());
        }
    }

    private void selectInsidePanel(String string) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        InsidePanel insidePanel = this.allInsidePanels.get(string);
        Dimension dimension = insidePanel.getPreferredSize();
        this.setPreferredSize(dimension);
        cardLayout.show(this, string);
    }

    private class ComboModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -569511034282161517L;
        private boolean isInitialized;

        private ComboModel() {
        }

        private void setAsInitialized() {
            this.isInitialized = true;
        }

        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
            if (this.isInitialized) {
                String string = (String)object;
                RunAsPanel.this.selectInsidePanel(string);
                InsidePanel insidePanel = (InsidePanel)RunAsPanel.this.allInsidePanels.get(string);
                if (insidePanel != null) {
                    insidePanel.loadFields();
                    insidePanel.validateFields();
                    insidePanel.putValue(insidePanel.currentCfg(), "run.as", insidePanel.getRunAsType().name());
                    insidePanel.markAsModified(insidePanel.getRunAsLabel(), "run.as", insidePanel.getRunAsType().name());
                }
            }
        }
    }

    public static abstract class InsidePanel
    extends JPanel
    implements ChangeListener {
        private final ConfigManager manager;

        public InsidePanel(ConfigManager configManager) {
            this.manager = configManager;
            configManager.addChangeListener(this);
        }

        protected abstract PhpProjectProperties.RunAsType getRunAsType();

        protected abstract String getDisplayName();

        protected abstract JComboBox getRunAsCombo();

        protected abstract JLabel getRunAsLabel();

        protected abstract void loadFields();

        protected abstract void validateFields();

        protected boolean isDefault() {
            return false;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            String string = this.getValue("run.as");
            if (string == null && this.isDefault() || string != null && string.equals(this.getRunAsType().name())) {
                JComboBox jComboBox = this.getRunAsCombo();
                jComboBox.getModel().setSelectedItem(this.getDisplayName());
            }
        }

        protected final String getCurrentValue(String string) {
            return this.getValue(this.currentCfg(), string);
        }

        protected final String getDefaultValue(String string) {
            return this.getValue(this.defaultCfg(), string);
        }

        protected final String getValue(String string) {
            String string2 = this.getCurrentValue(string);
            string2 = string2 == null ? this.getDefaultValue(string) : string2;
            return string2;
        }

        protected final void markAsModified(JLabel jLabel, String string, String string2) {
            String string3 = this.getDefaultValue(string);
            if (this.currentCfg().isDefault() || string2.equals(string3)) {
                jLabel.setFont(JL_PLAIN_FONT);
            } else {
                jLabel.setFont(JL_BOLD_FONT);
            }
        }

        protected final String getValue(ConfigManager.Configuration configuration, String string) {
            return configuration.getValue(string);
        }

        protected final void putValue(ConfigManager.Configuration configuration, String string, String string2) {
            configuration.putValue(string, string2);
        }

        protected final void putValue(String string, String string2) {
            String string3 = string2 = string2 != null ? string2.trim() : "";
            if (!this.currentCfg().isDefault() && string2.equals(this.getDefaultValue(string))) {
                string2 = null;
            }
            this.putValue(this.currentCfg(), string, string2);
        }

        protected final void putValueAndMarkAsModified(JLabel jLabel, String string, String string2) {
            string2 = string2 != null ? string2.trim() : "";
            this.putValue(string, string2);
            this.markAsModified(jLabel, string, string2);
        }

        protected final ConfigManager.Configuration currentCfg() {
            return this.getManager().currentConfiguration();
        }

        protected final ConfigManager.Configuration cfgFor(String string) {
            return this.getManager().configurationFor(string);
        }

        protected final ConfigManager.Configuration defaultCfg() {
            return this.getManager().defaultConfiguration();
        }

        protected final ConfigManager getManager() {
            return this.manager;
        }

        protected abstract class TextFieldUpdater
        implements DocumentListener {
            private final JLabel label;
            private final JTextField field;
            private final String propName;

            public TextFieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
                this.propName = string;
                this.label = jLabel;
                this.field = jTextField;
            }

            protected abstract String getDefaultValue();

            public final void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public final void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public final void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            protected final String getPropName() {
                return this.propName;
            }

            protected void processUpdate() {
                InsidePanel.this.putValue(this.propName, this.field.getText());
                InsidePanel.this.markAsModified(this.label, this.propName, this.field.getText());
                InsidePanel.this.validateFields();
            }
        }
    }
}

