/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.CopyFilesVisual;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.LocalServerController;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements SourcesFolderProvider,
HelpCtx.Provider {
    private static final long serialVersionUID = -58846951287474071L;
    private static final String DEFAULT_WEB_ROOT = NbBundle.getMessage(CustomizerSources.class, (String)"LBL_DefaultWebRoot");
    final ProjectCustomizer.Category category;
    final PhpProjectProperties properties;
    final PropertyEvaluator evaluator;
    String originalEncoding;
    boolean notified;
    private final CopyFilesVisual copyFilesVisual;
    private final boolean originalCopySrcFiles;
    private final String originalCopySrcTarget;
    private JPanel copyFilesPanel;
    private JComboBox encodingComboBox;
    private JLabel encodingLabel;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JLabel sourceFolderLabel;
    private JTextField sourceFolderTextField;
    private JButton webRootButton;
    private JLabel webRootLabel;
    private JTextField webRootTextField;

    public CustomizerSources(ProjectCustomizer.Category category, final PhpProjectProperties phpProjectProperties) {
        this.initComponents();
        this.category = category;
        this.properties = phpProjectProperties;
        this.evaluator = phpProjectProperties.getProject().getEvaluator();
        this.initEncoding();
        this.initProjectAndSources();
        this.webRootTextField.setText(this.getWebRoot());
        this.originalCopySrcFiles = this.initCopyFiles();
        LocalServer localServer = this.initCopyTarget();
        LocalServer[] localServerArray = this.getCopyTargets(localServer);
        this.originalCopySrcTarget = localServer.getSrcRoot();
        this.copyFilesVisual = new CopyFilesVisual(this, localServerArray);
        this.copyFilesVisual.selectLocalServer(localServer);
        this.copyFilesVisual.setCopyFiles(this.originalCopySrcFiles);
        this.copyFilesPanel.add("North", this.copyFilesVisual);
        this.encodingComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Charset charset = (Charset)CustomizerSources.this.encodingComboBox.getSelectedItem();
                String string = charset != null ? charset.name() : CustomizerSources.this.originalEncoding;
                if (!CustomizerSources.this.notified && string != null && !string.equals(CustomizerSources.this.originalEncoding)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
                    CustomizerSources.this.notified = true;
                }
                phpProjectProperties.setEncoding(string);
            }
        });
        DefaultChangeListener defaultChangeListener = new DefaultChangeListener();
        this.copyFilesVisual.addChangeListener(defaultChangeListener);
        this.webRootTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
        this.validateFields(category);
    }

    private void initEncoding() {
        this.originalEncoding = this.evaluator.getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encodingComboBox.setRenderer(new Utils.EncodingRenderer());
        this.encodingComboBox.setModel(new Utils.EncodingModel(this.originalEncoding));
        String string = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(string)) {
            this.encodingComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encodingComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                    jComboBox.setPopupVisible(false);
                }
            });
        }
    }

    private void initProjectAndSources() {
        PhpProject phpProject = this.properties.getProject();
        FileObject fileObject = phpProject.getProjectDirectory();
        String string = FileUtil.getFileDisplayName((FileObject)fileObject);
        this.projectFolderTextField.setText(string);
        this.sourceFolderTextField.setText(FileUtil.getFileDisplayName((FileObject)this.properties.getProject().getSourcesDirectory()));
    }

    private boolean initCopyFiles() {
        return Boolean.valueOf(this.evaluator.evaluate(this.properties.getCopySrcFiles()));
    }

    private LocalServer initCopyTarget() {
        String string = this.evaluator.evaluate(this.properties.getCopySrcTarget());
        if (string == null || string.length() == 0) {
            return new LocalServer("");
        }
        File file = FileUtil.normalizeFile((File)new File(string));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return new LocalServer(file.getAbsolutePath());
        }
        return new LocalServer(FileUtil.getFileDisplayName((FileObject)fileObject));
    }

    private LocalServer[] getCopyTargets(LocalServer localServer) {
        List<PhpEnvironment.DocumentRoot> list = PhpEnvironment.get().getDocumentRoots(this.getSourcesFolderName());
        int n = list.size() + 1;
        ArrayList<LocalServer> arrayList = new ArrayList<LocalServer>(n);
        arrayList.add(localServer);
        for (PhpEnvironment.DocumentRoot documentRoot : list) {
            LocalServer localServer2 = new LocalServer(documentRoot.getDocumentRoot());
            arrayList.add(localServer2);
        }
        return arrayList.toArray(new LocalServer[n]);
    }

    public String getSourcesFolderName() {
        return this.getSourcesFolder().getNameExt();
    }

    public FileObject getSourcesFolder() {
        return FileUtil.toFileObject((File)new File(this.projectFolderTextField.getText()));
    }

    void validateFields(ProjectCustomizer.Category category) {
        category.setErrorMessage(null);
        category.setValid(true);
        String string = null;
        File file = this.getSrcDir();
        if (!file.isDirectory()) {
            category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalSources"));
            category.setValid(false);
            return;
        }
        File file2 = this.getWebRootDir();
        if (!file2.exists()) {
            category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalWebRoot"));
            category.setValid(false);
            return;
        }
        File file3 = this.getCopyTargetDir();
        boolean bl = this.copyFilesVisual.isCopyFiles();
        if (bl) {
            if (file3 == null) {
                category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalFolderName"));
                category.setValid(false);
                return;
            }
            string = LocalServerController.validateLocalServer(this.copyFilesVisual.getLocalServer(), "Folder", this.allowNonEmptyDirectory(file3.getAbsolutePath(), file.getAbsolutePath()), true);
            if (string != null) {
                category.setErrorMessage(string);
                category.setValid(false);
                return;
            }
            string = Utils.validateSourcesAndCopyTarget(file.getAbsolutePath(), file3.getAbsolutePath());
            if (string != null) {
                category.setErrorMessage(string);
                category.setValid(false);
                return;
            }
        }
        this.properties.setCopySrcFiles(String.valueOf(bl));
        this.properties.setCopySrcTarget(file3 == null ? "" : file3.getAbsolutePath());
        String string2 = PropertyUtils.relativizeFile((File)file, (File)file2);
        assert (string2 != null && !string2.startsWith("../")) : "WebRoot must be underneath Sources";
        this.properties.setWebRoot(string2);
    }

    private File getSrcDir() {
        return new File(this.sourceFolderTextField.getText());
    }

    private File getWebRootDir() {
        String string = this.webRootTextField.getText();
        if (CustomizerSources.isDefaultWebRoot(string)) {
            return this.getSrcDir();
        }
        return FileUtil.normalizeFile((File)new File(this.getSrcDir(), string));
    }

    private String getWebRoot() {
        String string = this.properties.getWebRoot();
        if (CustomizerSources.isDefaultWebRoot(string)) {
            return DEFAULT_WEB_ROOT;
        }
        return string;
    }

    private static boolean isDefaultWebRoot(String string) {
        return string == null || string.trim().length() == 0 || string.equals(".") || DEFAULT_WEB_ROOT.equals(string);
    }

    private File getCopyTargetDir() {
        LocalServer localServer = this.copyFilesVisual.getLocalServer();
        String string = localServer.getSrcRoot();
        if (string == null || string.length() == 0) {
            return null;
        }
        return FileUtil.normalizeFile((File)new File(string));
    }

    private boolean allowNonEmptyDirectory(String string, String string2) {
        return this.originalCopySrcFiles && this.originalCopySrcTarget.equals(string);
    }

    private void initComponents() {
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.sourceFolderLabel = new JLabel();
        this.sourceFolderTextField = new JTextField();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.copyFilesPanel = new JPanel();
        this.webRootLabel = new JLabel();
        this.webRootButton = new JButton();
        this.webRootTextField = new JTextField();
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/php/project/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)resourceBundle.getString("LBL_ProjectFolder"));
        this.projectFolderTextField.setEditable(false);
        this.sourceFolderLabel.setLabelFor(this.sourceFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)resourceBundle.getString("LBL_SourceFolder"));
        this.sourceFolderTextField.setEditable(false);
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_Encoding"));
        this.copyFilesPanel.setLayout(new BorderLayout());
        this.webRootLabel.setLabelFor(this.webRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.webRootLabel, (String)resourceBundle.getString("LBL_WebRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.webRootButton, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_BrowseWebRoot"));
        this.webRootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerSources.this.webRootButtonActionPerformed(actionEvent);
            }
        });
        this.webRootTextField.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectFolderLabel).add((Component)this.sourceFolderLabel).add((Component)this.webRootLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectFolderTextField, -1, 280, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.webRootTextField, -1, 185, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.webRootButton)).add((Component)this.sourceFolderTextField, -1, 280, Short.MAX_VALUE))).add(2, (Component)this.copyFilesPanel, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encodingLabel).add(40, 40, 40).add((Component)this.encodingComboBox, 0, 280, Short.MAX_VALUE))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectFolderLabel).add((Component)this.projectFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sourceFolderLabel).add((Component)this.sourceFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.webRootLabel).add((Component)this.webRootButton).add((Component)this.webRootTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.copyFilesPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.encodingComboBox, -2, -1, -2).add((Component)this.encodingLabel)).addContainerGap(18, Short.MAX_VALUE)));
    }

    private void webRootButtonActionPerformed(ActionEvent actionEvent) {
        String string = Utils.browseSourceFolder((Project)this.properties.getProject(), this.webRootTextField.getText());
        if (CustomizerSources.isDefaultWebRoot(string)) {
            string = DEFAULT_WEB_ROOT;
        }
        this.webRootTextField.setText(string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CustomizerSources.this.validateFields(CustomizerSources.this.category);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CustomizerSources.this.validateFields(CustomizerSources.this.category);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CustomizerSources.this.validateFields(CustomizerSources.this.category);
        }
    }

    private class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CustomizerSources.this.validateFields(CustomizerSources.this.category);
        }
    }
}

