/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.php.project.connections.ui.SortColumnHeaderRenderer;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;

final class TransferFilterTable
extends JTable {
    private TransferFileTableModel model = null;
    private static final int DARKER_COLOR_COMPONENT = 10;
    private TableCellRenderer enableRenderer = null;
    private int rowHeightFontBase = -1;

    TransferFilterTable(TransferFileTableModel transferFileTableModel) {
        super(transferFileTableModel);
        this.model = transferFileTableModel;
        this.setShowGrid(false);
        this.setColumnsSize();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.revalidate();
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().setBackground(this.getBackground());
    }

    public void removeNotify() {
        super.removeNotify();
        this.enableRenderer = null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        int n3 = this.convertColumnIndexToModel(n2);
        TransferFileTableModel transferFileTableModel = (TransferFileTableModel)this.getModel();
        string = transferFileTableModel.getToolTipText(n, n3);
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    void resetEnableRenderer() {
        if (this.enableRenderer != null) {
            this.setEnableRenderer(this.enableRenderer);
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer(String.class);
        }
    }

    void setEnableRenderer(TableCellRenderer tableCellRenderer) {
        this.enableRenderer = tableCellRenderer;
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer);
    }

    void resortByDefault() {
        ((MyTableHeader)this.getTableHeader()).setDefaultSorting();
    }

    void setColumnsSize() {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.model.getPreferredWidth(this.getTableHeader(), i));
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Color color = this.getBackground();
        Color color2 = TransferFilterTable.getDarkerColor(color);
        TransferFileUnit transferFileUnit = this.model.getUnitAtRow(n);
        if (transferFileUnit != null && !transferFileUnit.canBeMarked()) {
            component.setForeground(Color.gray);
        } else {
            component.setFont(this.getFont());
            if (this.isRowSelected(n)) {
                component.setForeground(this.getSelectionForeground());
            } else {
                component.setForeground(this.getForeground());
            }
        }
        if (!this.isCellSelected(n, n2)) {
            if (n % 2 == 0) {
                component.setBackground(color2);
            } else {
                component.setBackground(color);
            }
        }
        if (this.rowHeightFontBase < 0) {
            Font font = component.getFont();
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n3 = new JTable().getRowHeight();
            this.rowHeightFontBase = Math.max(n3, fontMetrics.getHeight());
            this.setRowHeight(this.rowHeightFontBase);
        }
        return component;
    }

    static Color getDarkerColor(Color color) {
        return new Color(Math.abs(color.getRed() - 10), Math.abs(color.getGreen() - 10), Math.abs(color.getBlue() - 10));
    }

    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader(this.columnModel);
    }

    private class MyTableHeader
    extends JTableHeader {
        private SortColumnHeaderRenderer sortingRenderer;

        public MyTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() != 1) return;
                    if (!TransferFilterTable.this.isEnabled()) {
                        return;
                    }
                    int n2 = MyTableHeader.this.columnAtPoint(mouseEvent.getPoint());
                    if (MyTableHeader.this.sortingRenderer == null) return;
                    TransferFileUnit transferFileUnit = null;
                    TransferFileTableModel transferFileTableModel = null;
                    try {
                        Object object;
                        transferFileTableModel = (TransferFileTableModel)TransferFilterTable.this.getModel();
                        int n3 = TransferFilterTable.this.getSelectedRow();
                        if (n3 > -1) {
                            transferFileUnit = transferFileTableModel.getUnitAtRow(n3);
                        }
                        if (transferFileTableModel.isSortAllowed(object = MyTableHeader.this.getColumnModel().getColumn(n2).getIdentifier())) {
                            MyTableHeader.this.sortingRenderer.setSorting(object);
                            MyTableHeader.this.repaint();
                        }
                        Object var8_7 = null;
                        if (transferFileUnit == null) return;
                        List<TransferFileUnit> list = transferFileTableModel.getVisibleFileUnits();
                        if (transferFileUnit == null) return;
                        n = list.indexOf(transferFileUnit);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (transferFileUnit == null) throw throwable;
                        List<TransferFileUnit> list = transferFileTableModel.getVisibleFileUnits();
                        int n4 = transferFileUnit != null ? list.indexOf(transferFileUnit) : -1;
                        if (n4 <= -1) throw throwable;
                        TransferFileUnit transferFileUnit2 = transferFileTableModel.getUnitAtRow(n4);
                        if (transferFileUnit2 == null) throw throwable;
                        if (!transferFileUnit.getId().equals(transferFileUnit2.getId())) throw throwable;
                        TransferFilterTable.this.getSelectionModel().setSelectionInterval(n4, n4);
                        Rectangle rectangle = TransferFilterTable.this.getCellRect(n4, 0, true);
                        TransferFilterTable.this.scrollRectToVisible(rectangle);
                        throw throwable;
                    }
                    int n5 = n;
                    if (n5 <= -1) return;
                    TransferFileUnit transferFileUnit3 = transferFileTableModel.getUnitAtRow(n5);
                    if (transferFileUnit3 == null) return;
                    if (!transferFileUnit.getId().equals(transferFileUnit3.getId())) return;
                    TransferFilterTable.this.getSelectionModel().setSelectionInterval(n5, n5);
                    Rectangle rectangle = TransferFilterTable.this.getCellRect(n5, 0, true);
                    TransferFilterTable.this.scrollRectToVisible(rectangle);
                }
            });
            this.setReorderingAllowed(false);
        }

        public void setDraggedColumn(TableColumn tableColumn) {
            if (null != tableColumn && tableColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(tableColumn);
        }

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            if (!(tableCellRenderer instanceof SortColumnHeaderRenderer)) {
                this.sortingRenderer = new SortColumnHeaderRenderer((TransferFileTableModel)TransferFilterTable.this.getModel(), tableCellRenderer);
                tableCellRenderer = this.sortingRenderer;
            }
            super.setDefaultRenderer(tableCellRenderer);
        }

        public void setResizingColumn(TableColumn tableColumn) {
            if (null == this.getResizingColumn() || null == tableColumn) {
                // empty if block
            }
            super.setResizingColumn(tableColumn);
        }

        public void setDefaultSorting() {
            if (this.sortingRenderer != null) {
                this.sortingRenderer.setDefaultSorting();
            }
        }
    }
}

