/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteConnectionsPanel
extends JPanel {
    private static final long serialVersionUID = -286345875298064616L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ConfigListModel configListModel = new ConfigListModel();
    private JButton addButton;
    private JCheckBox anonymousCheckBox;
    private JList configList;
    private JScrollPane configScrollPane;
    private JLabel connectionLabel;
    private JTextField connectionTextField;
    private JPanel detailsPanel;
    private JLabel errorLabel;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JCheckBox passiveModeCheckBox;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JButton removeButton;
    private JSeparator separator;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JLabel userLabel;
    private JTextField userTextField;
    private JLabel warningLabel;

    RemoteConnectionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.warningLabel.setText(" ");
        this.configList.setModel(this.configListModel);
        this.configList.setCellRenderer(new ConfigListRenderer());
        this.setEnabledLoginCredentials();
        this.setEnabledRemoveButton();
        for (RemoteConnections.ConnectionType connectionType : RemoteConnections.ConnectionType.values()) {
            this.typeComboBox.addItem(connectionType);
        }
        this.setEnabledFields(false);
        this.registerListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void addAddButtonActionListener(ActionListener actionListener) {
        this.addButton.addActionListener(actionListener);
    }

    public void removeAddButtonActionListener(ActionListener actionListener) {
        this.addButton.removeActionListener(actionListener);
    }

    public void addRemoveButtonActionListener(ActionListener actionListener) {
        this.removeButton.addActionListener(actionListener);
    }

    public void removeRemoveButtonActionListener(ActionListener actionListener) {
        this.removeButton.removeActionListener(actionListener);
    }

    public void addConfigListListener(ListSelectionListener listSelectionListener) {
        this.configList.addListSelectionListener(listSelectionListener);
    }

    public void removeConfigListListener(ListSelectionListener listSelectionListener) {
        this.configList.removeListSelectionListener(listSelectionListener);
    }

    public void addConfiguration(ConfigManager.Configuration configuration) {
        this.addConfiguration(configuration, true);
    }

    public void addConfiguration(ConfigManager.Configuration configuration, boolean bl) {
        assert (this.configListModel.indexOf(configuration) == -1) : "Configuration already in the list: " + configuration;
        this.configListModel.addElement(configuration);
        if (bl) {
            this.configList.setSelectedValue(configuration, true);
        }
    }

    public void selectConfiguration(int n) {
        this.configList.setSelectedIndex(n);
    }

    public void selectConfiguration(String string) {
        this.configList.setSelectedValue(this.configListModel.getElement(string), true);
    }

    public ConfigManager.Configuration getSelectedConfiguration() {
        return (ConfigManager.Configuration)this.configList.getSelectedValue();
    }

    public List<ConfigManager.Configuration> getConfigurations() {
        return this.configListModel.getElements();
    }

    public void setConfigurations(List<ConfigManager.Configuration> list) {
        this.configListModel.setElements(list);
    }

    public void removeConfiguration(ConfigManager.Configuration configuration) {
        assert (this.configListModel.indexOf(configuration) != -1) : "Configuration not in the list: " + configuration;
        int n = -1;
        int n2 = this.configListModel.indexOf(configuration);
        if (n2 + 1 < this.configListModel.getSize()) {
            n = n2;
        } else if (this.configListModel.getSize() > 1) {
            n = n2 - 1;
        }
        this.configListModel.removeElement(configuration);
        if (n != -1) {
            this.configList.setSelectedIndex(n);
        }
    }

    public void setEnabledFields(boolean bl) {
        this.typeComboBox.setEnabled(bl);
        this.hostTextField.setEnabled(bl);
        this.portTextField.setEnabled(bl);
        this.userTextField.setEnabled(bl);
        this.passwordTextField.setEnabled(bl);
        this.anonymousCheckBox.setEnabled(bl);
        this.initialDirectoryTextField.setEnabled(bl);
        this.timeoutTextField.setEnabled(bl);
        this.passiveModeCheckBox.setEnabled(bl);
    }

    public void resetFields() {
        this.connectionTextField.setText(null);
        this.hostTextField.setText(null);
        this.portTextField.setText(null);
        this.userTextField.setText(null);
        this.passwordTextField.setText(null);
        this.anonymousCheckBox.setSelected(false);
        this.initialDirectoryTextField.setText(null);
        this.timeoutTextField.setText(null);
        this.passiveModeCheckBox.setSelected(false);
        this.setWarning(null);
        this.setError(null);
    }

    public void setError(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(string);
    }

    public void setWarning(String string) {
        this.warningLabel.setText(" ");
        this.warningLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.warningLabel.setText(string);
    }

    private void registerListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.typeComboBox.addActionListener(defaultActionListener);
        this.hostTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.portTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.userTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.passwordTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.anonymousCheckBox.addActionListener(defaultActionListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.timeoutTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.passiveModeCheckBox.addActionListener(defaultActionListener);
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnectionsPanel.this.setEnabledLoginCredentials();
            }
        });
        this.configList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RemoteConnectionsPanel.this.setEnabledRemoveButton();
            }
        });
    }

    void refreshConfigList() {
        this.configList.repaint();
    }

    void setEnabledRemoveButton() {
        this.setEnabledRemoveButton(this.configList.getSelectedIndex() != -1);
    }

    private void setEnabledRemoveButton(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    void setEnabledLoginCredentials() {
        this.setEnabledLoginCredentials(!this.anonymousCheckBox.isSelected());
    }

    void fireChange() {
        this.changeSupport.fireChange();
        this.refreshConfigList();
    }

    private void setEnabledLoginCredentials(boolean bl) {
        this.userTextField.setEnabled(bl);
        this.passwordTextField.setEnabled(bl);
    }

    private void initComponents() {
        this.configScrollPane = new JScrollPane();
        this.configList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.detailsPanel = new JPanel();
        this.connectionLabel = new JLabel();
        this.connectionTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.anonymousCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.passiveModeCheckBox = new JCheckBox();
        this.separator = new JSeparator();
        this.warningLabel = new JLabel();
        this.passwordLabelInfo = new JLabel();
        this.errorLabel = new JLabel();
        this.configList.setSelectionMode(0);
        this.configScrollPane.setViewportView(this.configList);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Remove"));
        this.connectionLabel.setLabelFor(this.connectionTextField);
        Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_ConnectionName"));
        this.connectionTextField.setEnabled(false);
        this.typeLabel.setLabelFor(this.typeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Type"));
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_HostName"));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Port"));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_UserName"));
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousCheckBox, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_AnonymousLogin"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Password"));
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_InitialDirectory"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Timeout"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        Mnemonics.setLocalizedText((AbstractButton)this.passiveModeCheckBox, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_PassiveMode"));
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)"warning");
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"TXT_PasswordInfo"));
        this.passwordLabelInfo.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.detailsPanel);
        this.detailsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.separator, -1, 434, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.connectionLabel).add((Component)this.typeLabel).add((Component)this.hostLabel).add((Component)this.userLabel).add((Component)this.passwordLabel).add((Component)this.initialDirectoryLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.typeComboBox, 0, 309, Short.MAX_VALUE).add((Component)this.connectionTextField, -1, 309, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.userTextField, -1, 73, Short.MAX_VALUE).add((Component)this.hostTextField, -1, 73, Short.MAX_VALUE).add((Component)this.passwordTextField, -1, 73, Short.MAX_VALUE).add((Component)this.initialDirectoryTextField, -1, 73, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.portLabel).addPreferredGap(0).add((Component)this.portTextField, -1, 99, Short.MAX_VALUE)).add(1, (Component)this.anonymousCheckBox).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.timeoutLabel).addPreferredGap(1).add((Component)this.timeoutTextField, -1, -1, Short.MAX_VALUE)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.passwordLabelInfo).addPreferredGap(0)))).add((Component)this.warningLabel).add((Component)this.passiveModeCheckBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionLabel).add((Component)this.connectionTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.typeLabel).add((Component)this.typeComboBox, -2, -1, -2)).add(18, 18, 18).add((Component)this.separator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.portLabel).add((Component)this.portTextField, -2, -1, -2).add((Component)this.hostTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.anonymousCheckBox).add((Component)this.userTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.passwordLabelInfo).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.initialDirectoryLabel).add((Component)this.timeoutLabel).add((Component)this.initialDirectoryTextField, -2, -1, -2).add((Component)this.timeoutTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.passiveModeCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.warningLabel).addContainerGap()));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"error");
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton)).add((Component)this.configScrollPane, 0, 0, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.detailsPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(12, 12, 12).add((Component)this.errorLabel))).addContainerGap()));
        groupLayout2.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.detailsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.configScrollPane, -1, 264, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.errorLabel)).addContainerGap()));
    }

    public String getConnectionName() {
        return this.connectionTextField.getText();
    }

    public void setConnectionName(String string) {
        this.connectionTextField.setText(string);
    }

    public RemoteConnections.ConnectionType getType() {
        return (RemoteConnections.ConnectionType)((Object)this.typeComboBox.getSelectedItem());
    }

    public void setType(RemoteConnections.ConnectionType connectionType) {
        this.typeComboBox.setSelectedItem((Object)connectionType);
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String string) {
        this.hostTextField.setText(string);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String string) {
        this.portTextField.setText(string);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String string) {
        this.userTextField.setText(string);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String string) {
        this.passwordTextField.setText(string);
    }

    public boolean isAnonymousLogin() {
        return this.anonymousCheckBox.isSelected();
    }

    public void setAnonymousLogin(boolean bl) {
        this.anonymousCheckBox.setSelected(bl);
        this.setEnabledLoginCredentials();
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String string) {
        this.initialDirectoryTextField.setText(string);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String string) {
        this.timeoutTextField.setText(string);
    }

    public boolean isPassiveMode() {
        return this.passiveModeCheckBox.isSelected();
    }

    public void setPassiveMode(boolean bl) {
        this.passiveModeCheckBox.setSelected(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -1945188556310432557L;
        private final List<ConfigManager.Configuration> data = new ArrayList<ConfigManager.Configuration>();

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public ConfigManager.Configuration getElementAt(int n) {
            return this.data.get(n);
        }

        public boolean addElement(ConfigManager.Configuration configuration) {
            assert (configuration != null);
            if (!this.data.add(configuration)) {
                return false;
            }
            Collections.sort(this.data, ConfigManager.getConfigurationComparator());
            int n = this.indexOf(configuration);
            this.fireIntervalAdded(this, n, n);
            return true;
        }

        public int indexOf(ConfigManager.Configuration configuration) {
            return this.data.indexOf(configuration);
        }

        public boolean removeElement(ConfigManager.Configuration configuration) {
            int n = this.indexOf(configuration);
            if (n == -1) {
                return false;
            }
            boolean bl = this.data.remove(configuration);
            assert (bl);
            this.fireIntervalRemoved(this, n, n);
            return true;
        }

        public List<ConfigManager.Configuration> getElements() {
            return Collections.unmodifiableList(this.data);
        }

        public void setElements(List<ConfigManager.Configuration> list) {
            int n = this.data.size();
            this.data.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            if (list.size() > 0) {
                this.data.addAll(list);
                Collections.sort(this.data, ConfigManager.getConfigurationComparator());
                this.fireIntervalAdded(this, 0, this.data.size() - 1);
            }
        }

        public ConfigManager.Configuration getElement(String string) {
            assert (string != null);
            for (ConfigManager.Configuration configuration : this.data) {
                if (!string.equals(configuration.getName())) continue;
                return configuration;
            }
            return null;
        }
    }

    public static class ConfigListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 3196531352192214602L;

        public ConfigListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof ConfigManager.Configuration);
            this.setName("ComboBox.listRenderer");
            Color color = UIManager.getColor("nb.errorForeground");
            ConfigManager.Configuration configuration = (ConfigManager.Configuration)object;
            this.setText(configuration.getDisplayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(configuration.isValid() ? jList.getSelectionForeground() : color);
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(configuration.isValid() ? jList.getForeground() : color);
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteConnectionsPanel.this.fireChange();
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            RemoteConnectionsPanel.this.fireChange();
        }
    }
}

