/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonPhpSourcePath {
    private static List<FileObject> internalFolders = null;

    private CommonPhpSourcePath() {
    }

    public static synchronized List<FileObject> getInternalPath() {
        if (internalFolders == null) {
            internalFolders = CommonPhpSourcePath.getInternalFolders();
        }
        return internalFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileObject> getInternalFolders() {
        assert (Thread.holdsLock(CommonPhpSourcePath.class));
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("PHP/RuntimeLibraries");
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (FileUtil.toFile((FileObject)fileObject2) != null) continue;
            InputStream inputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                inputStream = fileObject2.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                try {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (Throwable throwable) {
                    CommonPhpSourcePath.closeStreams(inputStream);
                    throw throwable;
                }
                CommonPhpSourcePath.closeStreams(inputStream);
            }
            CommonPhpSourcePath.closeStreams(inputStream);
            OutputStream iOException = null;
            try {
                iOException = fileObject2.getOutputStream();
                iOException.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException throwable) {
                try {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                catch (Throwable throwable2) {
                    CommonPhpSourcePath.closeStreams(iOException, byteArrayOutputStream);
                    throw throwable2;
                }
                CommonPhpSourcePath.closeStreams(iOException, byteArrayOutputStream);
                continue;
            }
            CommonPhpSourcePath.closeStreams(iOException, byteArrayOutputStream);
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        assert (file != null) : "Folder PHP/RuntimeLibraries cannot be resolved as a java.io.File";
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        arrayList.add(fileObject);
        arrayList.addAll(PhpSourcePath.getPreindexedFolders());
        return arrayList;
    }

    private static void closeStreams(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

