/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewMakeProjectWizardIterator;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener,
HelpCtx.Provider {
    public static final String PROP_PROJECT_NAME = "projectName";
    private PanelConfigureProject panel;
    private String templateName;
    private String name;
    private boolean makefileNameChanged = false;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel makefileLabel;
    private JTextField makefileTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private static ResourceBundle bundle;

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject, String string, boolean bl) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.name = string;
        this.templateName = string;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        if (bl) {
            this.makefileTextField.getDocument().addDocumentListener(this);
            this.makefileTextField.getDocument().addDocumentListener(new MakefileDocumentListener());
        } else {
            this.makefileTextField.setVisible(false);
            this.makefileLabel.setVisible(false);
        }
        this.makefileTextField.getAccessibleContext().setAccessibleDescription(PanelProjectLocationVisual.getString("AD_MAKEFILE"));
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewAppWizard");
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.makefileLabel = new JLabel();
        this.makefileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.projectNameLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_projectNameLabel"));
        this.projectNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 4, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_projectLocationLabel"));
        this.projectLocationTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_browseButton"));
        this.createdFolderLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MN_NWP1_CreatedProjectFolder_Lablel").charAt(0));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_createdFolderLabel"));
        this.createdFolderTextField.setColumns(20);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.makefileLabel.setLabelFor(this.makefileTextField);
        Mnemonics.setLocalizedText((JLabel)this.makefileLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_MAKEFILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 12, 0);
        this.add((Component)this.makefileLabel, gridBagConstraints);
        this.makefileTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 12, 0);
        this.add((Component)this.makefileTextField, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(file.getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    private boolean isValidProjectName(String string) {
        if (string.length() == 0 || string.startsWith(" ") || string.contains("\\") || string.contains("/") || string.contains(":") || string.contains("*") || string.contains("?") || string.contains("\"") || string.contains("<") || string.contains(">") || string.contains("|")) {
            return false;
        }
        boolean bl = false;
        try {
            File file = File.createTempFile(string + "dummy", "");
            bl = true;
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        if (!this.isValidProjectName(this.projectNameTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file2) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File file3 = PanelProjectLocationVisual.getCanonicalFile(new File(this.createdFolderTextField.getText()).getAbsoluteFile());
        if (file3 == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        if (this.makefileTextField.getText().indexOf(" ") >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_SpacesInMakefile"));
            return false;
        }
        if (this.makefileTextField.getText().indexOf("/") >= 0 || this.makefileTextField.getText().indexOf("\\") >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalMakefileName"));
            return false;
        }
        for (file = file3; file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        File[] fileArray = file3.listFiles();
        if (file3.exists()) {
            if (file3.isFile()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_NotAFolder", (Object)this.makefileTextField.getText()));
                return false;
            }
            if (new File(file3.getPath() + File.separator + this.makefileTextField.getText()).exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_MakefileExists", (Object)this.makefileTextField.getText()));
                return false;
            }
            if (new File(file3.getPath() + File.separator + "nbproject").exists() || new File(file3.getPath() + File.separator + "build").exists() || new File(file3.getPath() + File.separator + "dist").exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
                return false;
            }
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.projectLocationTextField.getText().trim();
        String string3 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string3));
        wizardDescriptor.putProperty("name", (Object)string);
        wizardDescriptor.putProperty("makefilename", (Object)this.makefileTextField.getText());
        File file = new File(this.projectLocationTextField.getText());
        if (file.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("displayName");
        if (string == null) {
            String string2 = (String)wizardDescriptor.getProperty("buildCommandWorkingDirTextField");
            if (string2 != null && string2.length() > 0 && this.templateName.equals(NewMakeProjectWizardIterator.MAKEFILEPROJECT_PROJECT_NAME)) {
                this.name = IpeUtils.getBaseName((String)string2);
            }
            int n = 1;
            String string3 = this.name + "_{0}";
            while ((string = this.validFreeProjectName(file, string3, n)) == null) {
                ++n;
            }
            wizardDescriptor.putProperty("nameIndex", (Object)new Integer(n));
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setName("Select Project Directory");
        return jFileChooser;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private String contructProjectMakefileName(int n) {
        String string = this.projectNameTextField.getText() + "-" + MakeConfigurationDescriptor.DEFAULT_PROJECT_MAKFILE_NAME;
        string = n > 0 ? string + "" + n + ".mk" : string + ".mk";
        return string;
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText().trim();
            String string2 = this.projectLocationTextField.getText().trim();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
            if (!this.makefileNameChanged) {
                String string3;
                String string4 = !this.templateName.equals(NewMakeProjectWizardIterator.MAKEFILEPROJECT_PROJECT_NAME) ? MakeConfigurationDescriptor.DEFAULT_PROJECT_MAKFILE_NAME : this.contructProjectMakefileName(0);
                int n = 0;
                while (new File(string3 = this.createdFolderTextField.getText() + File.separatorChar + string4).exists() || new File(string3.toLowerCase()).exists() || new File(string3.toUpperCase()).exists()) {
                    string4 = this.contructProjectMakefileName(n++);
                }
                this.makefileTextField.setText(string4);
                this.makefileNameChanged = false;
            }
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PanelProjectLocationVisual.class);
        }
        return bundle.getString(string);
    }

    class MakefileDocumentListener
    implements DocumentListener {
        MakefileDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }
    }
}

