/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.ui.options.CodeAssistancePanelController;
import org.netbeans.modules.cnd.makeproject.ui.options.PredefinedPanel;
import org.netbeans.modules.cnd.ui.options.IsChangedListener;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ParserSettingsPanel
extends JPanel
implements ChangeListener,
ActionListener,
IsChangedListener {
    private HashMap predefinedPanels = new HashMap();
    private boolean updating = false;
    private boolean modified = false;
    private ToolsPanel tp;
    private boolean initialized = false;
    private JPanel collectionPanel;
    private JComboBox compilerCollectionComboBox;
    private JLabel compilerCollectionLabel;
    private JScrollPane scrollPane;
    private JPanel tabPanel;
    private JTabbedPane tabbedPane;

    public ParserSettingsPanel() {
        this.setName("TAB_CodeAssistanceTab");
        this.initComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("MANAGE_COMPILERS_SETTINGS_AD"));
        this.compilerCollectionComboBox.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("COMPILER_COLLECTION_AD"));
        this.tp = ToolsPanel.getToolsPanel();
        if (this.tp != null) {
            ToolsPanel.addCompilerSetChangeListener((ChangeListener)this);
            ToolsPanel.addIsChangedListener((IsChangedListener)this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updating && this.isShowing()) {
            this.updateTabs();
        }
    }

    private void updateCompilerCollections(CompilerSet compilerSet) {
        this.compilerCollectionComboBox.removeAllItems();
        CompilerSetPresenter compilerSetPresenter = null;
        ArrayList<CompilerSetPresenter> arrayList = new ArrayList<CompilerSetPresenter>();
        ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        if (serverList != null) {
            String[] stringArray = serverList.getServerNames();
            if (stringArray.length > 1) {
                for (Object object : stringArray) {
                    for (CompilerSet compilerSet2 : CompilerSetManager.getDefault((String)object).getCompilerSets()) {
                        CompilerSetPresenter compilerSetPresenter2 = new CompilerSetPresenter(compilerSet2, (String)object + " : " + compilerSet2.getName());
                        if (compilerSet == compilerSet2) {
                            compilerSetPresenter = compilerSetPresenter2;
                        }
                        arrayList.add(compilerSetPresenter2);
                    }
                }
            } else assert ("localhost".equals(stringArray[0]));
        }
        if (arrayList.size() == 0) {
            for (CompilerSet compilerSet3 : CompilerSetManager.getDefault((String)"localhost").getCompilerSets()) {
                CompilerSetPresenter compilerSetPresenter3 = new CompilerSetPresenter(compilerSet3, compilerSet3.getName());
                if (compilerSet == compilerSet3) {
                    compilerSetPresenter = compilerSetPresenter3;
                }
                arrayList.add(compilerSetPresenter3);
            }
        }
        for (CompilerSetPresenter compilerSetPresenter4 : arrayList) {
            this.compilerCollectionComboBox.addItem(compilerSetPresenter4);
        }
        if (compilerSetPresenter == null) {
            if (this.compilerCollectionComboBox.getItemCount() > 0) {
                this.compilerCollectionComboBox.setSelectedIndex(0);
            }
        } else {
            this.compilerCollectionComboBox.setSelectedItem(compilerSetPresenter);
        }
        this.updateTabs();
    }

    private synchronized void updateTabs() {
        Tool tool;
        this.tabbedPane.removeAll();
        CompilerSetPresenter compilerSetPresenter = (CompilerSetPresenter)this.compilerCollectionComboBox.getSelectedItem();
        if (compilerSetPresenter == null || compilerSetPresenter.cs == null) {
            return;
        }
        CompilerSet compilerSet = compilerSetPresenter.cs;
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        Tool tool2 = compilerSet.getTool(0);
        if (tool2 != null && tool2.getPath().length() > 0) {
            arrayList.add(tool2);
        }
        if ((tool = compilerSet.getTool(1)) != null && tool.getPath().length() > 0) {
            arrayList.add(tool);
        }
        for (Tool tool3 : arrayList) {
            PredefinedPanel predefinedPanel = (PredefinedPanel)this.predefinedPanels.get(compilerSet.getName() + tool3.getPath());
            if (predefinedPanel == null) {
                predefinedPanel = new PredefinedPanel((CCCCompiler)tool3, this);
                this.predefinedPanels.put(compilerSet.getName() + tool3.getPath(), predefinedPanel);
            }
            this.tabbedPane.addTab(tool3.getDisplayName(), predefinedPanel);
        }
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void fireFilesPropertiesChanged() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("fireFilesPropertiesChanged for ParserSettingsPanel");
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            NativeProjectProvider nativeProjectProvider = (NativeProjectProvider)projectArray[i].getLookup().lookup(NativeProjectProvider.class);
            if (nativeProjectProvider == null) continue;
            nativeProjectProvider.fireFilesPropertiesChanged();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof CompilerSet) {
            this.updateCompilerCollections((CompilerSet)object);
        } else {
            this.updateCompilerCollections(null);
        }
    }

    private void initComponents() {
        this.collectionPanel = new JPanel();
        this.compilerCollectionLabel = new JLabel();
        this.compilerCollectionComboBox = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.tabPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.collectionPanel.setOpaque(false);
        this.compilerCollectionLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("COMPILER_COLLECTION_MN").charAt(0));
        this.compilerCollectionLabel.setLabelFor(this.compilerCollectionComboBox);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle");
        this.compilerCollectionLabel.setText(resourceBundle.getString("COMPILER_COLLECTION_LBL"));
        GroupLayout groupLayout = new GroupLayout((Container)this.collectionPanel);
        this.collectionPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.compilerCollectionLabel).addPreferredGap(0).add((Component)this.compilerCollectionComboBox, 0, 310, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.compilerCollectionLabel).add((Component)this.compilerCollectionComboBox, -2, -1, -2)));
        this.scrollPane.setOpaque(false);
        this.tabPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.tabPanel);
        this.tabPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.tabbedPane, -1, 397, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.tabbedPane, -1, 362, Short.MAX_VALUE));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AN"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AD"));
        this.scrollPane.setViewportView(this.tabPanel);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.collectionPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(0, 0, 0).add((Component)this.scrollPane, -1, 397, Short.MAX_VALUE).add(0, 0, 0))));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.collectionPanel, -2, -1, -2).addContainerGap(272, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(36, 36, 36).add((Component)this.scrollPane, -1, 256, Short.MAX_VALUE).add(0, 0, 0))));
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ParserSettingsPanel.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for ParserSettingsPanel");
        }
        try {
            this.updating = true;
            this.init();
            this.compilerCollectionComboBox.removeActionListener(this);
            this.updateCompilerCollections(this.tp.getCurrentCompilerSet());
            this.compilerCollectionComboBox.addActionListener(this);
            PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
            for (int i = 0; i < predefinedPanelArray.length; ++i) {
                predefinedPanelArray[i].update();
            }
        }
        finally {
            this.updating = false;
        }
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for ParserSettingsPanel");
        }
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            predefinedPanelArray[i].cancel();
        }
    }

    boolean isDataValid() {
        boolean bl = true;
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl &= predefinedPanelArray[i].isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for ParserSettingsPanel is " + bl);
        }
        return bl;
    }

    public boolean isChanged() {
        boolean bl = false;
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl |= predefinedPanelArray[i].isChanged();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for ParserSettingsPanel is " + bl);
        }
        return bl;
    }

    public void save() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("save for ParserSettingsPanel");
        }
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        boolean bl = false;
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl |= predefinedPanelArray[i].save();
        }
        if (bl || this.modified) {
            if (CodeAssistancePanelController.TRACE_CODEASSIST) {
                System.err.println("fireFilesPropertiesChanged in save for ParserSettingsPanel");
            }
            this.fireFilesPropertiesChanged();
            this.modified = false;
        } else if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("not need to fireFilesPropertiesChanged in save for ParserSettingsPanel");
        }
    }

    private PredefinedPanel[] getPredefinedPanels() {
        return this.predefinedPanels.values().toArray(new PredefinedPanel[this.predefinedPanels.size()]);
    }

    private synchronized void init() {
        ServerRecord serverRecord;
        ServerList serverList;
        if (!this.initialized && (serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class)) != null && (serverRecord = serverList.getDefaultRecord()) != null) {
            Logger logger = Logger.getLogger("cnd.remote.logger");
            logger.fine("ParserSettingsPanel<Init>: Validating " + serverRecord.getName());
            serverRecord.validate();
        }
        this.initialized = true;
    }

    private static class CompilerSetPresenter {
        public CompilerSet cs;
        private String displayName;

        public CompilerSetPresenter(CompilerSet compilerSet, String string) {
            this.cs = compilerSet;
            this.displayName = string;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

