/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.api.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.api.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.ui.BrokenIncludes;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProviders;
import org.netbeans.modules.cnd.makeproject.ui.AddExternalItemAction;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.CompileSingleAction;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.netbeans.modules.cnd.makeproject.ui.SetConfigurationAction;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;

public class MakeLogicalViewProvider
implements LogicalViewProvider {
    private final Project project;
    private FilterNode projectNode = null;
    private final SubprojectProvider spp;
    private static final MessageFormat ITEM_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd; class=org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider$ViewItemNode; mask={0}");
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-org-netbeans-modules-cnd-makeproject-uidnd";
    static final String MASK = "mask";
    private boolean findPathMode = false;
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif");
    private static Image brokenIncludeBadge = Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.gif");
    private static final int WAIT_DELAY = 50;

    public MakeLogicalViewProvider(Project project, SubprojectProvider subprojectProvider) {
        this.project = project;
        assert (project != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
    }

    public Node createLogicalView() {
        if (this.getMakeConfigurationDescriptor() == null) {
            return new MakeLogicalViewRootNodeBroken();
        }
        return new MakeLogicalViewRootNode(this.getMakeConfigurationDescriptor().getLogicalFolders());
    }

    private boolean isFindPathMode() {
        return this.findPathMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findPath(Node node, Object object) {
        Node node2 = null;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof DataObject) {
            object = ((DataObject)object).getPrimaryFile();
        }
        if (!(object instanceof FileObject)) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)((FileObject)object));
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null || file == null) {
            return null;
        }
        Item item = makeConfigurationDescriptor.findProjectItemByPath(file.getAbsolutePath());
        if (item == null && (item = makeConfigurationDescriptor.findExternalItemByPath(file.getAbsolutePath())) == null && (item = makeConfigurationDescriptor.findItemByFile(file)) == null) {
            return null;
        }
        try {
            this.findPathMode = true;
            Node node3 = MakeLogicalViewProvider.findFolderNode(node, item.getFolder());
            if (node3 != null) {
                Item item2;
                Node[] nodeArray = node3.getChildren().getNodes(true);
                int n = 0;
                for (n = 0; n < nodeArray.length && (item2 = (Item)nodeArray[n].getValue("Item")) != item; ++n) {
                }
                if (nodeArray.length > 0 && n < nodeArray.length) {
                    node2 = nodeArray[n];
                }
            }
        }
        finally {
            this.findPathMode = false;
        }
        return node2;
    }

    private static Node findFolderNode(Node node, Folder folder) {
        if (node.getValue("Folder") == folder) {
            return node;
        }
        Folder folder2 = folder.getParent();
        if (folder2 == null) {
            return node;
        }
        Node node2 = MakeLogicalViewProvider.findFolderNode(node, folder2);
        if (node2 == null) {
            return null;
        }
        Node[] nodeArray = node2.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getValue("Folder") != folder) continue;
            return nodeArray[i];
        }
        return null;
    }

    private static Node findItemNode(Node node, Item item) {
        Node node2 = MakeLogicalViewProvider.findFolderNode(node, item.getFolder());
        if (node2 != null) {
            Node[] nodeArray = node2.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].getValue("Item") != item) continue;
                return nodeArray[i];
            }
        }
        return null;
    }

    public static void setVisible(Project project, Folder folder) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        Node node2 = MakeLogicalViewProvider.findProjectNode(node, project);
        if (node2 == null) {
            return;
        }
        Node node3 = MakeLogicalViewProvider.findFolderNode(node2, folder);
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[]{node3});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setVisible(Project project, Item item) {
        MakeLogicalViewProvider.setVisible(project, new Item[]{item});
    }

    public static void setVisible(Project project, Item[] itemArray) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < itemArray.length; ++i) {
            Node node2 = MakeLogicalViewProvider.findProjectNode(node, project);
            if (node2 == null) continue;
            arrayList.add(MakeLogicalViewProvider.findItemNode(node2, itemArray[i]));
        }
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(arrayList.toArray(new Node[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkForChangedItems(final Project project, Folder folder, final Item item) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                Node node;
                if (item == null) {
                    MakeLogicalViewProvider.checkForChangedItems(project);
                    return;
                }
                Node node2 = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node node3 = MakeLogicalViewProvider.findProjectNode(node2, project);
                if (node3 != null && (node = MakeLogicalViewProvider.findItemNode(node3, item)) instanceof FilterNode && (object = node.getLookup().lookup(ViewItemNode.class)) != null) {
                    ((ChangeListener)object).stateChanged(null);
                }
            }
        });
    }

    private static void checkForChangedItems(Project project) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        MakeLogicalViewProvider.checkForChangedItems(MakeLogicalViewProvider.findProjectNode(node, project));
    }

    private static void checkForChangedItems(Node node) {
        if (node != null) {
            for (Node node2 : node.getChildren().getNodes(true)) {
                Object object;
                MakeLogicalViewProvider.checkForChangedItems(node2);
                if (!(node2 instanceof FilterNode) || (object = node2.getLookup().lookup(ViewItemNode.class)) == null) continue;
                ((ChangeListener)object).stateChanged(null);
            }
        }
    }

    private static Node findProjectNode(Node node, Project project) {
        Node[] nodeArray = node.getChildren().getNodes(true);
        Lookup.Template template = new Lookup.Template(null, null, (Object)project);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getLookup().lookupItem(template) == null) continue;
            return nodeArray[i];
        }
        return null;
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public static boolean hasBrokenLinks() {
        return false;
    }

    private static Node getWaitNode() {
        return new LoadingNode();
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
        return makeConfigurationDescriptor;
    }

    class FolderSearchInfo
    implements SearchInfo {
        Folder folder;

        FolderSearchInfo(Folder folder) {
            this.folder = folder;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            return this.folder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    class RefreshItemAction
    extends AbstractAction {
        private Children.Keys childrenKeys;
        private Folder folder;
        private Item item;

        public RefreshItemAction(Children.Keys keys, Folder folder, Item item) {
            this.childrenKeys = keys;
            this.folder = folder;
            this.item = item;
            this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_Refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.item != null) {
                this.refresh(this.item);
            } else {
                Item[] itemArray = this.folder.getItemsAsArray();
                for (int i = 0; i < itemArray.length; ++i) {
                    this.refresh(itemArray[i]);
                }
            }
        }

        private void refresh(Item item) {
            if (this.childrenKeys instanceof ExternalFilesChildren) {
                ((ExternalFilesChildren)this.childrenKeys).refreshItem(item);
            } else if (this.childrenKeys instanceof LogicalViewChildren) {
                ((LogicalViewChildren)this.childrenKeys).refreshItem(item);
            }
        }
    }

    private final class BrokenViewItemNode
    extends AbstractNode {
        private boolean broken;
        private Children.Keys childrenKeys;
        private Folder folder;
        private Item item;

        public BrokenViewItemNode(Children.Keys keys, Folder folder, Item item) {
            super(Children.LEAF);
            this.childrenKeys = keys;
            this.folder = folder;
            this.item = item;
            File file = item.getCanonicalFile();
            this.setName(file.getPath());
            this.setDisplayName(file.getName());
            this.setShortDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"BrokenTxt", (Object)file.getPath()));
            this.broken = true;
        }

        public Image getIcon(int n) {
            int n2 = this.item.getDefaultTool();
            Image image = n2 == 0 ? Utilities.loadImage((String)"org/netbeans/modules/cnd/loaders/CSrcIcon.gif") : (n2 == 1 ? Utilities.loadImage((String)"org/netbeans/modules/cnd/loaders/CCSrcIcon.gif") : (n2 == 2 ? Utilities.loadImage((String)"org/netbeans/modules/cnd/loaders/FortranSrcIcon.gif") : Utilities.loadImage((String)"org/netbeans/modules/cnd/loaders/unknown.gif")));
            return this.broken ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)11, (int)0) : image;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(RemoveItemAction.class), new RefreshItemAction(this.childrenKeys, null, this.item), null, SystemAction.get(PropertiesItemAction.class)};
        }

        public boolean canRename() {
            return false;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(string);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("Item")) {
                return this.item;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }
    }

    static class ViewItemTransferable
    extends ExTransferable.Single {
        private ViewItemNode node;

        public ViewItemTransferable(ViewItemNode viewItemNode, int n) throws ClassNotFoundException {
            super(new DataFlavor(ITEM_VIEW_FLAVOR.format(new Object[]{new Integer(n)}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = viewItemNode;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private class ViewItemNode
    extends FilterNode
    implements ChangeListener {
        Children.Keys childrenKeys;
        private Folder folder;
        private Item item;

        public ViewItemNode(Children.Keys keys, Folder folder, Item item, DataObject dataObject) {
            super(dataObject.getNodeDelegate());
            this.childrenKeys = keys;
            this.folder = folder;
            this.item = item;
            File file = item.getCanonicalFile();
            this.setShortDescription(file.getPath());
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Item getItem() {
            return this.item;
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return true;
        }

        public boolean canCopy() {
            return true;
        }

        public Transferable clipboardCopy() throws IOException {
            return this.addViewItemTransferable(super.clipboardCopy(), 1);
        }

        public Transferable clipboardCut() throws IOException {
            return this.addViewItemTransferable(super.clipboardCut(), 2);
        }

        public Transferable drag() throws IOException {
            return this.addViewItemTransferable(super.drag(), 0);
        }

        private ExTransferable addViewItemTransferable(Transferable transferable, int n) {
            try {
                ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                ViewItemTransferable viewItemTransferable = new ViewItemTransferable(this, n);
                exTransferable.put((ExTransferable.Single)viewItemTransferable);
                return exTransferable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public void destroy() throws IOException {
            this.folder.removeItemAction(this.item);
            super.destroy();
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(string);
            }
            if (string.equals("Folder")) {
                return this.getFolder();
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("Item")) {
                return this.getItem();
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray = super.getActions(false);
            Vector<Action> vector = new Vector<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (actionArray[i] != null && actionArray[i] instanceof OpenAction) {
                    vector.add(actionArray[i]);
                    vector.add(null);
                    vector.add(new RefreshItemAction(this.childrenKeys, null, this.getItem()));
                    vector.add(null);
                    vector.add((Action)SystemAction.get(CompileSingleAction.class));
                    vector.add(null);
                    continue;
                }
                if (actionArray[i] != null && actionArray[i] instanceof DeleteAction) {
                    vector.add((Action)SystemAction.get(RemoveItemAction.class));
                    vector.add((Action)SystemAction.get(DeleteAction.class));
                    continue;
                }
                if (actionArray[i] != null && actionArray[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                    vector.add((Action)SystemAction.get(PropertiesItemAction.class));
                    continue;
                }
                vector.add(actionArray[i]);
            }
            return vector.toArray(new Action[vector.size()]);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.isExcluded() && image instanceof BufferedImage) {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
                image = colorConvertOp.filter((BufferedImage)image, null);
            }
            return image;
        }

        public String getHtmlDisplayName() {
            if (this.isExcluded()) {
                return "<font color='!controlShadow'>" + this.getDisplayName();
            }
            return super.getHtmlDisplayName();
        }

        private boolean isExcluded() {
            if (this.item == null || this.item.getFolder() == null || this.item.getFolder().getConfigurationDescriptor() == null || this.item.getFolder().getConfigurationDescriptor().getConfs() == null) {
                return false;
            }
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.item.getFolder().getConfigurationDescriptor().getConfs().getActive();
            ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
            if (itemConfiguration == null) {
                return false;
            }
            BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
            return booleanConfiguration.getValue();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            String string = this.getDisplayName();
            this.fireDisplayNameChange(string, "");
            this.fireDisplayNameChange("", string);
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    private class ExternalFilesChildren
    extends BaseMakeViewChildren {
        private final Project project;

        public ExternalFilesChildren(Project project, Folder folder) {
            super(folder);
            this.project = project;
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof LoadingNode) {
                return new Node[]{(Node)object};
            }
            if (!(object instanceof Item)) {
                System.err.println("wrong item in external files folder " + object);
                return null;
            }
            Item item = (Item)object;
            DataObject dataObject = item.getDataObject();
            Object object2 = dataObject != null ? new ViewItemNode(this, this.getFolder(), item, dataObject) : new BrokenViewItemNode(this, this.getFolder(), item);
            return new Node[]{object2};
        }

        protected Collection getKeys() {
            return this.getFolder().getElements();
        }
    }

    private abstract class BaseMakeViewChildren
    extends Children.Keys
    implements ChangeListener {
        private final Folder folder;

        public BaseMakeViewChildren(Folder folder) {
            this.folder = folder;
        }

        protected void addNotify() {
            if (MakeLogicalViewProvider.this.isFindPathMode()) {
                super.addNotify();
                this.folder.addChangeListener(this);
                this.setKeys(this.getKeys());
            } else if (SwingUtilities.isEventDispatchThread()) {
                super.addNotify();
                this.setKeys(new Object[]{MakeLogicalViewProvider.getWaitNode()});
                this.folder.addChangeListener(this);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (MakeLogicalViewProvider.this.project.getProjectDirectory() != null && MakeLogicalViewProvider.this.project.getProjectDirectory().isValid()) {
                            BaseMakeViewChildren.this.setKeys(BaseMakeViewChildren.this.getKeys());
                        }
                    }
                }, 50);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseMakeViewChildren.this.addNotify();
                    }
                });
            }
        }

        public void refreshItem(Item item) {
            this.refreshKey(item);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.folder.removeChangeListener(this);
            super.removeNotify();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof Item) {
                Item[] itemArray = this.getFolder().getItemsAsArray();
                for (int i = 0; i < itemArray.length; ++i) {
                    if (changeEvent.getSource() != itemArray[i]) continue;
                    this.refreshItem(itemArray[i]);
                }
            } else {
                this.setKeys(this.getKeys());
            }
        }

        protected abstract Collection getKeys();

        public Folder getFolder() {
            return this.folder;
        }
    }

    private final class ExternalFilesNode
    extends AbstractNode {
        private Image icon;
        private Lookup lookup;
        private Action brokenLinksAction;
        private boolean broken;
        private Folder folder;

        public ExternalFilesNode(Folder folder) {
            super((Children)new ExternalFilesChildren(MakeLogicalViewProvider.this.project, folder), Lookups.fixed((Object[])new Object[]{MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.setName(folder.getName());
            this.setDisplayName(folder.getDisplayName());
            this.setShortDescription(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("ONLY_REFERENCE_TXT"));
            this.folder = folder;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(string);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        private FilterNode getProjectNode() {
            if (MakeLogicalViewProvider.this.projectNode == null) {
                DataObject dataObject;
                FileObject fileObject = MakeLogicalViewProvider.this.project.getProjectDirectory();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw new AssertionError((Object)dataObjectNotFoundException);
                }
                MakeLogicalViewProvider.this.projectNode = new FilterNode(dataObject.getNodeDelegate());
            }
            return MakeLogicalViewProvider.this.projectNode;
        }

        public Image getIcon(int n) {
            return this.getProjectNode().getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.getProjectNode().getOpenedIcon(n);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new AddExternalItemAction(MakeLogicalViewProvider.this.project), null, SystemAction.get(FindAction.class)};
        }

        public boolean canRename() {
            return false;
        }
    }

    class ViewItemPasteType
    extends PasteType {
        Folder toFolder;
        ViewItemNode viewItemNode;
        int type;

        public ViewItemPasteType(Folder folder, ViewItemNode viewItemNode, int n) {
            this.toFolder = folder;
            this.viewItemNode = viewItemNode;
            this.type = n;
        }

        private void copyItemConfigurations(ItemConfiguration[] itemConfigurationArray, ItemConfiguration[] itemConfigurationArray2) {
            assert (itemConfigurationArray.length == itemConfigurationArray2.length);
            for (int i = 0; i < itemConfigurationArray.length; ++i) {
                itemConfigurationArray[i].assignValues(itemConfigurationArray2[i]);
            }
        }

        public Transferable paste() throws IOException {
            Item item = this.viewItemNode.getItem();
            ItemConfiguration[] itemConfigurationArray = item.getItemConfigurations();
            if (this.type == 2) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    this.viewItemNode.getFolder().removeItem(item);
                    this.toFolder.addItem(item);
                    this.copyItemConfigurations(item.getItemConfigurations(), itemConfigurationArray);
                } else if (IpeUtils.isPathAbsolute((String)item.getPath())) {
                    this.viewItemNode.getFolder().removeItem(item);
                    this.toFolder.addItem(item);
                } else if (item.getPath().startsWith("..")) {
                    String string = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String string2 = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String string3 = IpeUtils.getRelativePath((String)string2, (String)string) + "/";
                    string3 = FilePathAdaptor.normalize(string3);
                    String string4 = string3 + item.getPath();
                    string4 = IpeUtils.trimDotDot((String)string4);
                    this.viewItemNode.getFolder().removeItemAction(item);
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string4)));
                } else {
                    Project project = this.toFolder.getProject();
                    FileObject fileObject = item.getFileObject();
                    FileObject fileObject2 = fileObject.copy(project.getProjectDirectory(), fileObject.getName(), fileObject.getExt());
                    String string = IpeUtils.toRelativePath((String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath(), (String)FileUtil.toFile((FileObject)fileObject2).getPath());
                    this.viewItemNode.getFolder().removeItemAction(item);
                    fileObject.delete();
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string)));
                }
            } else if (this.type == 1) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    if (IpeUtils.isPathAbsolute((String)item.getPath()) || item.getPath().startsWith("..")) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        FileObject fileObject = FileUtil.toFileObject((File)item.getCanonicalFile());
                        String string = FileUtil.toFile((FileObject)fileObject.getParent()).getPath();
                        String string5 = fileObject.getExt();
                        String string6 = IpeUtils.createUniqueFileName((String)string, (String)fileObject.getName(), (String)string5);
                        fileObject.copy(fileObject.getParent(), string6, string5);
                        String string7 = string + "/" + string6;
                        if (string5.length() > 0) {
                            string7 = string7 + "." + string5;
                        }
                        string7 = IpeUtils.toRelativePath((String)FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath(), (String)string7);
                        Item item2 = new Item(FilePathAdaptor.normalize(string7));
                        this.toFolder.addItemAction(item2);
                        this.copyItemConfigurations(item2.getItemConfigurations(), itemConfigurationArray);
                    }
                } else if (IpeUtils.isPathAbsolute((String)item.getPath())) {
                    this.toFolder.addItem(new Item(item.getPath()));
                } else if (item.getPath().startsWith("..")) {
                    String string = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String string8 = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String string9 = IpeUtils.getRelativePath((String)string8, (String)string) + "/";
                    string9 = FilePathAdaptor.normalize(string9);
                    String string10 = string9 + item.getPath();
                    string10 = IpeUtils.trimDotDot((String)string10);
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string10)));
                } else {
                    Project project = this.toFolder.getProject();
                    String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath();
                    FileObject fileObject = item.getFileObject();
                    String string11 = fileObject.getExt();
                    String string12 = IpeUtils.createUniqueFileName((String)string, (String)fileObject.getName(), (String)string11);
                    FileObject fileObject3 = fileObject.copy(project.getProjectDirectory(), string12, string11);
                    String string13 = string12;
                    if (string11.length() > 0) {
                        string13 = string13 + "." + string11;
                    }
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string13)));
                }
            }
            return null;
        }
    }

    public class LogicalFolderNode
    extends AnnotatedNode
    implements ChangeListener {
        private Folder folder;

        public LogicalFolderNode(Node node, Folder folder) {
            super((Children)new LogicalViewChildren(folder), Lookups.fixed((Object[])new Object[]{folder, MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.folder = folder;
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
        }

        private void updateAnnotationFiles() {
            RequestProcessor.getDefault().post((Runnable)new UpdateAnnotationFilesTHread(this));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateAnnotationFiles();
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(string);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Image getIcon(int n) {
            return this.annotateIcon(Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolder.gif"), n);
        }

        public Image getOpenedIcon(int n) {
            return this.annotateIcon(Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolderOpened.gif"), n);
        }

        public String getName() {
            return this.folder.getDisplayName();
        }

        public String getDisplayName() {
            return this.annotateName(this.folder.getDisplayName());
        }

        public void setName(String string) {
            String string2 = this.folder.getDisplayName();
            if (this.folder.getParent() != null && this.folder.getParent().findFolderByDisplayName(string) != null) {
                String string3 = NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"CANNOT_RENAME", (Object)string2, (Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3));
                return;
            }
            this.folder.setDisplayName(string);
            this.fireDisplayNameChange(string2, string);
        }

        public void setDisplayName(String string) {
            this.setDisplayName(string);
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, n, n2);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(dataFlavorArray[i]);
                    int n = new Integer(dataFlavorArray[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, n));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        public void newLogicalFolder() {
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(NewFolderAction.class), null, new RefreshItemAction((LogicalViewChildren)this.getChildren(), this.folder, null), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), SystemAction.get(RemoveFolderAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PropertiesFolderAction.class)};
        }

        class UpdateAnnotationFilesTHread
        extends Thread {
            LogicalFolderNode logicalFolderNode;

            UpdateAnnotationFilesTHread(LogicalFolderNode logicalFolderNode2) {
                this.logicalFolderNode = logicalFolderNode2;
            }

            public void run() {
                LogicalFolderNode.this.setFiles(Collections.EMPTY_SET);
                Vector<Folder> vector = new Vector<Folder>();
                vector.add(LogicalFolderNode.this.folder);
                vector.addAll(LogicalFolderNode.this.folder.getAllFolders(true));
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ((Folder)iterator.next()).addChangeListener(this.logicalFolderNode);
                }
            }
        }
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private Project project;
        private String nodeName;

        public PreselectPropertiesAction(Project project, String string) {
            super(NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MakeCustomizerProvider makeCustomizerProvider = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class);
            if (makeCustomizerProvider != null) {
                makeCustomizerProvider.showCustomizer(this.nodeName);
            }
        }
    }

    private class LogicalViewChildren
    extends BaseMakeViewChildren {
        public LogicalViewChildren(Folder folder) {
            super(folder);
        }

        protected Node[] createNodes(Object object) {
            Object object2 = null;
            if (object instanceof LoadingNode) {
                object2 = (Node)object;
            } else if (object instanceof Node) {
                object2 = (Node)object;
            } else if (object instanceof Folder) {
                Folder folder = (Folder)object;
                if (folder.isProjectFiles()) {
                    DataObject dataObject;
                    FileObject fileObject = MakeLogicalViewProvider.this.project.getProjectDirectory();
                    try {
                        dataObject = DataObject.find((FileObject)fileObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        throw new AssertionError((Object)dataObjectNotFoundException);
                    }
                    object2 = new LogicalFolderNode(((DataFolder)dataObject).getNodeDelegate(), folder);
                } else {
                    object2 = new ExternalFilesNode(folder);
                }
            } else if (object instanceof Item) {
                Item item = (Item)object;
                DataObject dataObject = item.getDataObject();
                object2 = dataObject != null ? new ViewItemNode(this, this.getFolder(), item, dataObject) : new BrokenViewItemNode(this, this.getFolder(), item);
            } else if (object instanceof AbstractNode) {
                object2 = (AbstractNode)object;
            }
            return new Node[]{object2};
        }

        protected Collection getKeys() {
            LogicalViewNodeProvider[] logicalViewNodeProviderArray;
            Vector vector = this.getFolder().getElements();
            if (this.getFolder().getName() == "root" && (logicalViewNodeProviderArray = LogicalViewNodeProviders.getInstance().getProvidersAsArray()).length > 0) {
                for (int i = 0; i < logicalViewNodeProviderArray.length; ++i) {
                    AbstractNode abstractNode = logicalViewNodeProviderArray[i].getLogicalViewNode(MakeLogicalViewProvider.this.project);
                    if (abstractNode == null) continue;
                    vector.add(abstractNode);
                }
            }
            return vector;
        }
    }

    private final class MakeLogicalViewRootNodeBroken
    extends AbstractNode {
        public MakeLogicalViewRootNodeBroken() {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{MakeLogicalViewProvider.this.project}));
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)MakeLogicalViewProvider.this.project).getDisplayName());
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Action[] getActions(boolean bl) {
            Vector<Action> vector = new Vector<Action>();
            vector.add(CommonProjectActions.closeProjectAction());
            return vector.toArray(new Action[vector.size()]);
        }

        public boolean canRename() {
            return false;
        }
    }

    private final class MakeLogicalViewRootNode
    extends AnnotatedNode
    implements ChangeListener,
    LookupListener {
        private Image icon;
        private Lookup lookup;
        private Action brokenLinksAction;
        private boolean brokenLinks;
        private boolean brokenIncludes;
        private Folder folder;
        private final Lookup.Result<BrokenIncludes> brokenIncludesResult;

        public MakeLogicalViewRootNode(Folder folder) {
            super((Children)new LogicalViewChildren(folder), Lookups.fixed((Object[])new Object[]{folder, MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.folder = folder;
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)MakeLogicalViewProvider.this.project).getDisplayName());
            this.brokenIncludesResult = Lookup.getDefault().lookup(new Lookup.Template(BrokenIncludes.class));
            this.brokenIncludesResult.addLookupListener((LookupListener)this);
            this.resultChanged(null);
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(MakeLogicalViewProvider.this.project);
            this.brokenLinksAction = new BrokenLinksAction();
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
        }

        public Folder getFolder() {
            return this.folder;
        }

        private void updateAnnotationFiles() {
            Object object;
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            if (MakeLogicalViewProvider.this.project.getProjectDirectory() == null) {
                Logger.getLogger("cnd.makeproject").warning("project.getProjectDirectory() == null - " + MakeLogicalViewProvider.this.project);
            }
            hashSet.add(MakeLogicalViewProvider.this.project.getProjectDirectory());
            Configuration[] configurationArray = MakeLogicalViewProvider.this.getMakeConfigurationDescriptor().getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                MakefileConfiguration makefileConfiguration;
                String string;
                File file;
                object = (MakeConfiguration)configurationArray[i];
                if (!((MakeConfiguration)object).isMakefileConfiguration() || !(file = new File(string = (makefileConfiguration = ((MakeConfiguration)object).getMakefileConfiguration()).getAbsBuildCommandWorkingDir())).exists()) continue;
                try {
                    hashSet.add(FileUtil.toFileObject((File)file.getCanonicalFile()));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.setFiles(hashSet);
            Vector<Folder> vector = new Vector<Folder>();
            vector.add(this.folder);
            vector.addAll(this.folder.getAllFolders(true));
            object = vector.iterator();
            while (object.hasNext()) {
                ((Folder)object.next()).addChangeListener(this);
            }
        }

        public String getShortDescription() {
            if (this.brokenIncludes) {
                return NbBundle.getMessage(this.getClass(), (String)"BrokenIncludeTxt");
            }
            return super.getShortDescription();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(MakeLogicalViewProvider.this.project);
            this.updateAnnotationFiles();
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(string);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Image getIcon(int n) {
            return this.mergeBadge(this.annotateIcon(super.getIcon(n), n));
        }

        private Image mergeBadge(Image image) {
            if (this.brokenLinks) {
                return Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            if (this.brokenIncludes) {
                return Utilities.mergeImages((Image)image, (Image)brokenIncludeBadge, (int)8, (int)0);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            return this.mergeBadge(this.annotateIcon(super.getOpenedIcon(n), n));
        }

        public Action[] getActions(boolean bl) {
            MakeLogicalViewProvider.this.getMakeConfigurationDescriptor().getLogicalFolders();
            Vector<Action> vector = new Vector<Action>();
            Action[] actionArray = this.getAdditionalActions();
            for (int i = 0; i < actionArray.length; ++i) {
                vector.add(actionArray[i]);
            }
            vector.add(null);
            vector.addAll(Utilities.actionsForPath((String)"NativeProjects/Menu"));
            vector.add(null);
            vector.add((Action)SystemAction.get(FindAction.class));
            vector.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            vector.add(null);
            vector.add(CommonProjectActions.customizeProjectAction());
            return vector.toArray(new Action[vector.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, n, n2);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(dataFlavorArray[i]);
                    int n = new Integer(dataFlavorArray[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, n));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(NewFolderAction.class), new AddExternalItemAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"batch_build", (String)resourceBundle.getString("LBL_BatchBuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)resourceBundle.getString("LBL_BuildPackagesAction_Name"), null), new SetConfigurationAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)resourceBundle.getString("LBL_DebugAction_Step_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
        }

        public void resultChanged(LookupEvent lookupEvent) {
            for (BrokenIncludes brokenIncludes : this.brokenIncludesResult.allInstances()) {
                brokenIncludes.addChangeListener(this);
            }
        }

        private boolean hasBrokenIncludes(Project project) {
            NativeProject nativeProject;
            BrokenIncludes brokenIncludes = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
            if (brokenIncludes != null && (nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
                return brokenIncludes.isBroken(nativeProject);
            }
            return false;
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private PropertyChangeListener weakPCL;

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (this.task == null) {
                    this.task = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.task.schedule(100);
            }

            public synchronized void run() {
                boolean bl = MakeLogicalViewRootNode.this.brokenLinks;
                MakeLogicalViewRootNode.this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
                if (bl != MakeLogicalViewRootNode.this.brokenLinks) {
                    this.setEnabled(MakeLogicalViewRootNode.this.brokenLinks);
                    MakeLogicalViewRootNode.this.fireIconChange();
                    MakeLogicalViewRootNode.this.fireOpenedIconChange();
                }
            }
        }
    }

    private static class LoadingNode
    extends AbstractNode {
        public LoadingNode() {
            super(Children.LEAF);
            this.setName("dummy");
            this.setDisplayName(NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"Tree_Loading"));
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/waitNode.gif");
        }
    }
}

