/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.loaders.CoreElfObject;
import org.netbeans.modules.cnd.loaders.ExeObject;
import org.netbeans.modules.cnd.loaders.OrphanedElfObject;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFilesOuterPanel;
import org.netbeans.modules.cnd.makeproject.packaging.FileElement;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingFilesPanel
extends ListEditorPanel {
    private String baseDir;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private JButton addButton;
    private JButton addFileOrDirectoryButton;
    private JButton addFilesButton;
    private PackagingFilesOuterPanel packagingFilesOuterPanel;
    private static ResourceBundle bundle;

    public PackagingFilesPanel(List<FileElement> list, String string) {
        super(list.toArray(), new JButton[]{new JButton(), new JButton(), new JButton()});
        this.getAddButton().setVisible(false);
        this.baseDir = string;
        this.addButton = this.extraButtons[0];
        this.addFileOrDirectoryButton = this.extraButtons[1];
        this.addFilesButton = this.extraButtons[2];
        this.addButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.text"));
        this.addButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.mn").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.ad"));
        this.addButton.addActionListener(new AddButtonAction());
        this.addFileOrDirectoryButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.text"));
        this.addFileOrDirectoryButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.mn").charAt(0));
        this.addFileOrDirectoryButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.ad"));
        this.addFileOrDirectoryButton.addActionListener(new AddFileOrDirectoryButtonAction());
        this.addFilesButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.text"));
        this.addFilesButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.mn").charAt(0));
        this.addFilesButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.ad"));
        this.addFilesButton.addActionListener(new AddFilesButtonAction());
        this.getEditButton().setVisible(false);
        this.getDefaultButton().setVisible(false);
    }

    public void setOuterPanel(PackagingFilesOuterPanel packagingFilesOuterPanel) {
        this.packagingFilesOuterPanel = packagingFilesOuterPanel;
    }

    private boolean isExecutable(File file) {
        FileObject fileObject = null;
        if (file.getName().endsWith(".exe")) {
            return true;
        }
        try {
            fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
        if (dataObject instanceof ExeObject || dataObject instanceof ShellDataObject) {
            return !(dataObject instanceof OrphanedElfObject) && !(dataObject instanceof CoreElfObject);
        }
        return false;
    }

    @Override
    public Object copyAction(Object object) {
        FileElement fileElement = (FileElement)object;
        return new FileElement(fileElement.getType(), new String(fileElement.getFrom()), new String(fileElement.getTo()));
    }

    @Override
    public String getCopyButtonText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.text");
    }

    @Override
    public char getCopyButtonMnemonics() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.mn").charAt(0);
    }

    @Override
    public String getCopyButtonAD() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.ad");
    }

    @Override
    public String getListLabelText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.text");
    }

    @Override
    public char getListLabelMnemonic() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.mn").charAt(0);
    }

    @Override
    public int getSelectedIndex() {
        int n = this.getTargetList().getSelectedRow();
        if (n >= 0 && n < this.listData.size()) {
            return n;
        }
        return 0;
    }

    @Override
    protected void setSelectedIndex(int n) {
        this.getTargetList().getSelectionModel().setSelectionInterval(n, n);
    }

    @Override
    protected void setData(Vector vector) {
        this.getTargetList().setModel(new MyTableModel());
        this.getTargetList().getColumnModel().getColumn(0).setPreferredWidth(40);
        this.getTargetList().getColumnModel().getColumn(0).setMaxWidth(40);
        if (this.getTargetList().getColumnModel().getColumnCount() >= 4) {
            this.getTargetList().getColumnModel().getColumn(3).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(3).setMaxWidth(50);
        }
        if (this.getTargetList().getColumnModel().getColumnCount() >= 6) {
            this.getTargetList().getColumnModel().getColumn(4).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(4).setMaxWidth(50);
            this.getTargetList().getColumnModel().getColumn(5).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(5).setMaxWidth(50);
        }
        this.getTargetList().getSelectionModel().setSelectionMode(0);
        this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    @Override
    protected void ensureIndexIsVisible(int n) {
    }

    @Override
    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.setData(null);
            this.getListLabel().setLabelFor(this.targetList);
        }
        return this.targetList;
    }

    public int getActualColumnCount() {
        return 6;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingFilesPanel.class);
        }
        return bundle.getString(string);
    }

    class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.0.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.1.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.2.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.3.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.4.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.5.text")};

        MyTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return PackagingFilesPanel.this.getActualColumnCount();
        }

        public int getRowCount() {
            return PackagingFilesPanel.this.listData.size();
        }

        public Object getValueAt(int n, int n2) {
            FileElement fileElement = (FileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                return fileElement.getType();
            }
            if (n2 == 2) {
                if (fileElement.getType() == FileElement.FileType.DIRECTORY) {
                    return "";
                }
                return fileElement.getFrom();
            }
            if (n2 == 1) {
                return fileElement.getTo();
            }
            if (n2 == 3) {
                return fileElement.getPermission();
            }
            if (n2 == 4) {
                return fileElement.getOwner();
            }
            if (n2 == 5) {
                return fileElement.getGroup();
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            FileElement fileElement = (FileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                FileElement.FileType fileType = (FileElement.FileType)((Object)object);
                if (fileType == FileElement.FileType.FILE) {
                    fileElement.setType(fileType);
                    fileElement.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText());
                    fileElement.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    fileElement.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == FileElement.FileType.DIRECTORY) {
                    fileElement.setType(fileType);
                    fileElement.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText());
                    fileElement.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    fileElement.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == FileElement.FileType.SOFTLINK) {
                    fileElement.setType(fileType);
                    fileElement.setPermission("");
                    fileElement.setOwner("");
                    fileElement.setGroup("");
                } else assert (false);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 2) {
                fileElement.setFrom((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 1) {
                fileElement.setTo((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 3) {
                fileElement.setPermission((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 4) {
                fileElement.setOwner((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 5) {
                fileElement.setGroup((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else assert (false);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            FileElement fileElement = (FileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                jLabel.setText(fileElement.getType().toString());
            } else {
                if (n2 == 1) {
                    if (fileElement.getType() == FileElement.FileType.SOFTLINK) {
                        jLabel.setToolTipText((Object)((Object)fileElement.getType()) + ": " + fileElement.getTo() + "->" + fileElement.getFrom());
                    } else if (fileElement.getType() == FileElement.FileType.DIRECTORY) {
                        jLabel.setToolTipText((Object)((Object)fileElement.getType()) + ": " + fileElement.getTo());
                    } else if (fileElement.getType() == FileElement.FileType.FILE) {
                        jLabel.setToolTipText((Object)((Object)fileElement.getType()) + ": " + new File(IpeUtils.toAbsolutePath((String)PackagingFilesPanel.this.baseDir, (String)fileElement.getFrom())).getAbsolutePath());
                    }
                    return jLabel;
                }
                if (n2 == 2) {
                    if (fileElement.getType() == FileElement.FileType.DIRECTORY) {
                        return jLabel;
                    }
                    if (fileElement.getType() == FileElement.FileType.SOFTLINK) {
                        return jLabel;
                    }
                    if (!bl) {
                        jLabel = new JLabel();
                    }
                    File file = new File(IpeUtils.toAbsolutePath((String)PackagingFilesPanel.this.baseDir, (String)fileElement.getFrom()));
                    if (!bl && !file.exists()) {
                        jLabel.setForeground(Color.RED);
                    }
                    jLabel.setText(fileElement.getFrom());
                }
            }
            return jLabel;
        }
    }

    class MyTable
    extends JTable {
        public MyTable() {
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
        }

        public Color getGridColor() {
            return new Color(225, 225, 225);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return PackagingFilesPanel.this.myTableCellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                FileElement fileElement = (FileElement)PackagingFilesPanel.this.listData.elementAt(n);
                JComboBox<FileElement.FileType> jComboBox = new JComboBox<FileElement.FileType>();
                jComboBox.addItem(FileElement.FileType.FILE);
                jComboBox.addItem(FileElement.FileType.DIRECTORY);
                jComboBox.addItem(FileElement.FileType.SOFTLINK);
                if (fileElement.getType() == FileElement.FileType.DIRECTORY) {
                    jComboBox.setSelectedIndex(1);
                } else if (fileElement.getType() == FileElement.FileType.SOFTLINK) {
                    jComboBox.setSelectedIndex(2);
                } else {
                    jComboBox.setSelectedIndex(0);
                }
                return new DefaultCellEditor(jComboBox);
            }
            return super.getCellEditor(n, n2);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            PackagingFilesPanel.this.checkSelection();
        }
    }

    class AddFilesButtonAction
    implements ActionListener {
        AddFilesButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = PackagingFilesPanel.this.baseDir;
            }
            FileChooser fileChooser = new FileChooser(PackagingFilesPanel.getString("FileChooserFilesTitle"), PackagingFilesPanel.getString("FileChooserButtonText"), 1, null, string, false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory((JComponent)pathPanel);
            fileChooser.setMultiSelectionEnabled(false);
            int n = fileChooser.showOpenDialog(null);
            if (n == 1) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            this.addFilesFromDirectory(file, file);
        }

        private void addFilesFromDirectory(File file, File file2) {
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.addFilesFromDirectory(file, fileArray[i]);
                    continue;
                }
                String string = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : fileArray[i].getPath());
                string = FilePathAdaptor.mapToRemote(string);
                string = FilePathAdaptor.normalize(string);
                String string2 = IpeUtils.toRelativePath((String)file.getParentFile().getAbsolutePath(), (String)fileArray[i].getPath());
                string2 = FilePathAdaptor.mapToRemote(string2);
                string2 = FilePathAdaptor.normalize(string2);
                String string3 = PackagingFilesPanel.this.packagingFilesOuterPanel.getTopDirectoryTextField().getText();
                if (string3.length() > 0 && !string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                String string4 = fileArray[i].getName().endsWith(".exe") || fileArray[i].isDirectory() || PackagingFilesPanel.this.isExecutable(fileArray[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                PackagingFilesPanel.this.addObjectAction(new FileElement(FileElement.FileType.FILE, string, string3 + string2, string4, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
            }
        }
    }

    class AddFileOrDirectoryButtonAction
    implements ActionListener {
        AddFileOrDirectoryButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = PackagingFilesPanel.this.baseDir;
            }
            FileChooser fileChooser = new FileChooser(PackagingFilesPanel.getString("FileChooserFileTitle"), PackagingFilesPanel.getString("FileChooserButtonText"), 2, null, string, false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory((JComponent)pathPanel);
            fileChooser.setMultiSelectionEnabled(true);
            int n = fileChooser.showOpenDialog(null);
            if (n == 1) {
                return;
            }
            File[] fileArray = fileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : fileArray[i].getPath());
                string2 = FilePathAdaptor.mapToRemote(string2);
                string2 = FilePathAdaptor.normalize(string2);
                String string3 = PackagingFilesPanel.this.packagingFilesOuterPanel.getTopDirectoryTextField().getText();
                if (string3.length() > 0 && !string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                if (fileArray[i].isDirectory()) {
                    PackagingFilesPanel.this.addObjectAction(new FileElement(FileElement.FileType.DIRECTORY, "", string3 + fileArray[i].getName(), PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
                    continue;
                }
                String string4 = PackagingFilesPanel.this.isExecutable(fileArray[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                PackagingFilesPanel.this.addObjectAction(new FileElement(FileElement.FileType.FILE, string2, string3 + fileArray[i].getName(), string4, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
            }
        }
    }

    class AddButtonAction
    implements ActionListener {
        AddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = PackagingFilesPanel.this.packagingFilesOuterPanel.getTopDirectoryTextField().getText();
            if (string.length() > 0 && !string.endsWith("/")) {
                string = string + "/";
            }
            PackagingFilesPanel.this.addObjectAction(new FileElement(FileElement.FileType.UNKNOWN, "", string));
        }
    }
}

