/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.util.NbBundle;

public class LibraryOptionPanel
extends JPanel {
    private ButtonGroup buttonGroup;
    private JRadioButton dynamicRadioButton;
    private JRadioButton otherRadioButton;
    private JTextField otherTextField;
    private JRadioButton staticRadioButton;

    public LibraryOptionPanel() {
        this.initComponents();
        this.buttonGroup.add(this.staticRadioButton);
        this.buttonGroup.add(this.dynamicRadioButton);
        this.buttonGroup.add(this.otherRadioButton);
        this.staticRadioButton.setSelected(true);
        this.otherTextField.setEnabled(false);
        this.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_PANEL_SD"));
        this.dynamicRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_DYNAMIC_RB_SD"));
        this.otherRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_OTHER_RB_SD"));
        this.otherTextField.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_OTHER_TF_SD"));
        this.staticRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_STATIC_RB_SD"));
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.staticRadioButton = new JRadioButton();
        this.dynamicRadioButton = new JRadioButton();
        this.otherRadioButton = new JRadioButton();
        this.otherTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.staticRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("STATIC_BINDINGS_MN").charAt(0));
        this.staticRadioButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("STATIC_BINDINGS_TXT"));
        this.staticRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionPanel.this.staticRadioButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.staticRadioButton, gridBagConstraints);
        this.dynamicRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("DYNAMIC_BINDINGS_MN").charAt(0));
        this.dynamicRadioButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("DYNAMIC_BINDINGS_TXT"));
        this.dynamicRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionPanel.this.dynamicRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 12);
        this.add((Component)this.dynamicRadioButton, gridBagConstraints);
        this.otherRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("OTHER_OPTION_MN").charAt(0));
        this.otherRadioButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("OTHER_OPTION_TXT"));
        this.otherRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptionPanel.this.otherRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 12);
        this.add((Component)this.otherRadioButton, gridBagConstraints);
        this.otherTextField.setColumns(32);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 34, 12, 12);
        this.add((Component)this.otherTextField, gridBagConstraints);
    }

    private void otherRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.otherTextField.setEnabled(true);
    }

    private void dynamicRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.otherTextField.setEnabled(false);
    }

    private void staticRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.otherTextField.setEnabled(false);
    }

    public String getOption(MakeConfiguration makeConfiguration) {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return this.otherTextField.getText();
        }
        if (this.dynamicRadioButton.isSelected()) {
            String string;
            ToolchainManager.LinkerDescriptor linkerDescriptor = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (linkerDescriptor != null && (string = linkerDescriptor.getDynamicLibraryFlag()) != null) {
                return string;
            }
            return "";
        }
        if (this.staticRadioButton.isSelected()) {
            String string;
            ToolchainManager.LinkerDescriptor linkerDescriptor = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (linkerDescriptor != null && (string = linkerDescriptor.getStaticLibraryFlag()) != null) {
                return string;
            }
            return "";
        }
        return this.otherTextField.getText();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(LibraryOptionPanel.class).getString(string);
    }
}

