/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.api.utils.IpeUtils;

public class VectorConfiguration {
    private VectorConfiguration master;
    private List value;
    private boolean dirty = false;

    public VectorConfiguration(VectorConfiguration vectorConfiguration) {
        this.master = vectorConfiguration;
        this.value = new ArrayList();
        this.reset();
    }

    public VectorConfiguration getMaster() {
        return this.master;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void add(Object object) {
        this.getValue().add(object);
    }

    public void setValue(List list) {
        this.value = !(list instanceof ArrayList) ? new ArrayList(list) : list;
    }

    public void setValue(String string) {
        ArrayList arrayList = CppUtils.tokenizeString((String)string);
        this.setValue(arrayList);
    }

    public List getValue() {
        return this.value;
    }

    public String[] getValueAsArray() {
        return this.getValue().toArray(new String[this.getValue().size()]);
    }

    public boolean getModified() {
        return this.value.size() != 0;
    }

    public void reset() {
        this.value = new ArrayList();
    }

    public String getOption(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getValueAsArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(string + IpeUtils.escapeOddCharacters((String)stringArray[i]) + " ");
        }
        return stringBuilder.toString();
    }

    public void assign(VectorConfiguration vectorConfiguration) {
        this.setDirty(!this.equals(vectorConfiguration));
        this.reset();
        this.getValue().addAll(vectorConfiguration.getValue());
    }

    public boolean equals(VectorConfiguration vectorConfiguration) {
        boolean bl = true;
        if (this.getValue().size() != vectorConfiguration.getValue().size()) {
            bl = false;
        } else {
            for (int i = 0; i < this.getValue().size(); ++i) {
                if (this.getValue().get(i).equals(vectorConfiguration.getValue().get(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public Object clone() {
        VectorConfiguration vectorConfiguration = new VectorConfiguration(this.master);
        vectorConfiguration.setValue((List)((ArrayList)this.getValue()).clone());
        return vectorConfiguration;
    }
}

