/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLWriter;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeConfigurationDescriptor
extends ConfigurationDescriptor
implements ChangeListener {
    public static final String EXTERNAL_FILES_FOLDER = "ExternalFiles";
    public static final String SOURCE_FILES_FOLDER = "SourceFiles";
    public static final String HEADER_FILES_FOLDER = "HeaderFiles";
    public static final String RESOURCE_FILES_FOLDER = "ResourceFiles";
    public static final String ICONBASE = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject";
    public static final String ICON = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif";
    public static final Icon MAKEFILE_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif"));
    private Project project = null;
    private String baseDir;
    private boolean modified = false;
    private Folder externalFileItems = null;
    private Folder rootFolder = null;
    private HashMap projectItems = null;
    private List<String> sourceRoots = null;
    private Set<ChangeListener> projectItemsChangeListeners = new HashSet<ChangeListener>();
    private NativeProject nativeProject = null;
    public static String DEFAULT_PROJECT_MAKFILE_NAME = "Makefile";
    private String projectMakefileName = DEFAULT_PROJECT_MAKFILE_NAME;
    private String sourceEncoding = null;

    public MakeConfigurationDescriptor(String string) {
        this.baseDir = string;
        this.rootFolder = new Folder(this, null, "root", "root", true);
        this.projectItems = new HashMap();
        this.sourceRoots = new ArrayList<String>();
        this.setModified(true);
        ToolsPanel.addCompilerSetModifiedListener((ChangeListener)this);
        this.sourceEncoding = FileEncodingQuery.getDefaultEncoding().name();
    }

    @Override
    public void closed() {
        ToolsPanel.removeCompilerSetModifiedListener((ChangeListener)this);
    }

    public static MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project project) {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider != null) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
            return makeConfigurationDescriptor;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setModified();
    }

    public Project getProject() {
        if (this.project == null) {
            String string = FilePathAdaptor.mapToLocal(this.getBaseDir());
            try {
                FileObject fileObject = FileUtil.toFileObject((File)new File(string));
                this.project = ProjectManager.getDefault().findProject(fileObject);
            }
            catch (Exception exception) {
                System.err.println("Cannot find project in '" + string + "' " + exception);
            }
        }
        return this.project;
    }

    public void init(Configuration configuration) {
        super.init(new Configuration[]{configuration}, 0);
        this.setModified(true);
    }

    public void initLogicalFolders(Iterator iterator, boolean bl, Iterator iterator2) {
        if (bl) {
            this.rootFolder.addNewFolder(SOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("SourceFilesTxt"), true);
            this.rootFolder.addNewFolder(HEADER_FILES_FOLDER, MakeConfigurationDescriptor.getString("HeaderFilesTxt"), true);
            this.rootFolder.addNewFolder(RESOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("ResourceFilesTxt"), true);
        }
        this.externalFileItems = this.rootFolder.addNewFolder(EXTERNAL_FILES_FOLDER, MakeConfigurationDescriptor.getString("ImportantFilesTxt"), false);
        this.externalFileItems.addItem(new Item(this.getProjectMakefileName()));
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                this.externalFileItems.addItem(new Item((String)iterator2.next()));
            }
        }
        this.addSourceFilesFromFolders(iterator, false, false);
        this.setModified(true);
    }

    public String getProjectMakefileName() {
        return this.projectMakefileName;
    }

    public void setProjectMakefileName(String string) {
        this.projectMakefileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectItemsChangeEvent(Item item, int n) {
        Iterator<ChangeListener> iterator;
        Object object = this.projectItemsChangeListeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.projectItemsChangeListeners).iterator();
        }
        object = new ProjectItemChangeEvent(this, item, n);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public Set<ChangeListener> getProjectItemsChangeListeners() {
        return this.projectItemsChangeListeners;
    }

    public void setProjectItemsChangeListeners(Set<ChangeListener> set) {
        this.projectItemsChangeListeners = set;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public HashMap getProjectItemsMap() {
        return this.projectItems;
    }

    public void setProjectItemsMap(HashMap hashMap) {
        this.projectItems = hashMap;
    }

    public void init(Configuration[] configurationArray) {
        super.init(configurationArray, 0);
    }

    @Override
    public Icon getIcon() {
        return MAKEFILE_ICON;
    }

    @Override
    public Configuration defaultConf(String string, int n) {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this, string, n);
        Item[] itemArray = this.getProjectItems();
        for (int i = 0; i < itemArray.length; ++i) {
            makeConfiguration.addAuxObject(new ItemConfiguration(makeConfiguration, itemArray[i]));
        }
        return makeConfiguration;
    }

    public void setExternalFileItems(Vector vector) {
        this.externalFileItems.reset();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.externalFileItems.addItem(new Item((String)enumeration.nextElement()));
        }
    }

    public void setExternalFileItems(Folder folder) {
        this.externalFileItems = folder;
    }

    public Folder getExternalFileItems() {
        return this.externalFileItems;
    }

    public Item[] getExternalFileItemsAsArray() {
        return this.externalFileItems.getItemsAsArray();
    }

    public Folder getExternalItemFolder() {
        return this.externalFileItems;
    }

    public Folder getLogicalFolders() {
        return this.rootFolder;
    }

    public void setLogicalFolders(Folder folder) {
        this.rootFolder = folder;
    }

    public Item[] getProjectItems() {
        Collection collection = this.projectItems.values();
        return collection.toArray(new Item[collection.size()]);
    }

    public Item findItemByFile(File file) {
        Collection collection = this.projectItems.values();
        for (Item item : collection) {
            File file2 = item.getCanonicalFile();
            if (file2 != file && !file2.getPath().equals(file.getPath())) continue;
            return item;
        }
        return null;
    }

    public Item findProjectItemByPath(String string) {
        Item item = (Item)this.projectItems.get(string = FilePathAdaptor.normalize(string));
        if (item == null) {
            String string2 = IpeUtils.isPathAbsolute((String)string) ? IpeUtils.toRelativePath((String)this.getBaseDir(), (String)FilePathAdaptor.naturalize(string)) : IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
            string2 = FilePathAdaptor.normalize(string2);
            item = (Item)this.projectItems.get(string2);
        }
        return item;
    }

    public Item findExternalItemByPath(String string) {
        Item item = this.externalFileItems.findItemByPath(string);
        if (item == null) {
            String string2 = IpeUtils.isPathAbsolute((String)string) ? IpeUtils.toRelativePath((String)this.getBaseDir(), (String)string) : IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
            item = (Item)this.projectItems.get(FilePathAdaptor.normalize(string2));
        }
        return item;
    }

    public Folder findFolderByPath(String string) {
        return this.getLogicalFolders().findFolderByPath(string);
    }

    public void addProjectItem(Item item) {
        this.projectItems.put(item.getPath(), item);
        this.fireProjectItemsChangeEvent(item, 0);
        this.setModified(true);
    }

    public void fireFilesAdded(List<NativeFileItem> list) {
        this.getNativeProject().fireFilesAdded(list);
    }

    public void removeProjectItem(Item item) {
        this.projectItems.remove(item.getPath());
        this.fireProjectItemsChangeEvent(item, 1);
        this.setModified(true);
    }

    public void fireFilesRemoved(List<NativeFileItem> list) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesRemoved(list);
        }
    }

    public void fireFileRenamed(String string, NativeFileItem nativeFileItem) {
        this.getNativeProject().fireFileRenamed(string, nativeFileItem);
    }

    public void checkForChangedItems(Project project, Folder folder, Item item) {
        this.getNativeProject().checkForChangedItems(folder, item);
        MakeLogicalViewProvider.checkForChangedItems(project, folder, item);
    }

    @Override
    public void copyFromProjectDescriptor(ConfigurationDescriptor configurationDescriptor) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptor;
        this.setConfs(makeConfigurationDescriptor.getConfs());
        this.setBaseDir(configurationDescriptor.getBaseDir());
        this.setProjectMakefileName(makeConfigurationDescriptor.getProjectMakefileName());
        this.setExternalFileItems(makeConfigurationDescriptor.getExternalFileItems());
        this.setLogicalFolders(makeConfigurationDescriptor.getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)configurationDescriptor).getSourceRootsRaw());
        this.setSourceEncoding(((MakeConfigurationDescriptor)configurationDescriptor).getSourceEncoding());
    }

    @Override
    public void assign(ConfigurationDescriptor configurationDescriptor) {
        Configuration[] configurationArray = configurationDescriptor.getConfs().getConfs();
        Configuration[] configurationArray2 = new Configuration[configurationArray.length];
        this.setBaseDir(configurationDescriptor.getBaseDir());
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i].getCloneOf() != null) {
                configurationArray[i].getCloneOf().assign(configurationArray[i]);
                configurationArray2[i] = configurationArray[i].getCloneOf();
                continue;
            }
            configurationArray2[i] = configurationArray[i];
        }
        this.init(configurationArray2, configurationDescriptor.getConfs().getActiveAsIndex());
        this.setProjectMakefileName(((MakeConfigurationDescriptor)configurationDescriptor).getProjectMakefileName());
        this.setExternalFileItems(((MakeConfigurationDescriptor)configurationDescriptor).getExternalFileItems());
        this.setLogicalFolders(((MakeConfigurationDescriptor)configurationDescriptor).getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)configurationDescriptor).getSourceRootsRaw());
        this.setSourceEncoding(((MakeConfigurationDescriptor)configurationDescriptor).getSourceEncoding());
    }

    @Override
    public ConfigurationDescriptor cloneProjectDescriptor() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = new MakeConfigurationDescriptor(this.getBaseDir());
        super.cloneProjectDescriptor(makeConfigurationDescriptor);
        makeConfigurationDescriptor.setProjectMakefileName(this.getProjectMakefileName());
        makeConfigurationDescriptor.setExternalFileItems(this.getExternalFileItems());
        makeConfigurationDescriptor.setLogicalFolders(this.getLogicalFolders());
        makeConfigurationDescriptor.setProjectItemsMap(this.getProjectItemsMap());
        makeConfigurationDescriptor.setProjectItemsChangeListeners(this.getProjectItemsChangeListeners());
        makeConfigurationDescriptor.setSourceRoots(this.getSourceRootsRaw());
        makeConfigurationDescriptor.setSourceEncoding(this.getSourceEncoding());
        return makeConfigurationDescriptor;
    }

    public boolean getModified() {
        return this.modified;
    }

    @Override
    public void setModified() {
        this.setModified(true);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (bl && this.getConfs() != null) {
            Configuration[] configurationArray = this.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                ((MakeConfiguration)configurationArray[i]).setRequiredLanguagesDirty(true);
            }
        }
    }

    public void refreshRequiredLanguages() {
        if (this.getConfs() != null) {
            Configuration[] configurationArray = this.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                ((MakeConfiguration)configurationArray[i]).reCountLanguages(this);
            }
        }
    }

    @Override
    public boolean save() {
        return this.save(null);
    }

    @Override
    public boolean save(String string) {
        SaveRunnable saveRunnable = new SaveRunnable(string);
        RequestProcessor.Task task = RequestProcessor.getDefault().post((Runnable)saveRunnable);
        task.waitFinished();
        return saveRunnable.ret;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String string) {
        this.sourceEncoding = string;
    }

    public Collection<String> getAdditionalExtensions() {
        return Collections.emptyList();
    }

    public void addAdditionalExtensions(Collection<String> collection) {
        HDataLoader.getInstance().addExtensions(collection);
    }

    private boolean saveWorker(String string) {
        Object object;
        int n;
        Object[] objectArray;
        Object object2;
        Configuration[] configurationArray = this.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            object2 = configurationArray[i];
            objectArray = ((Configuration)object2).getAuxObjects();
            for (n = 0; n < objectArray.length; n += 1) {
                if (objectArray[n].hasChanged()) {
                    this.setModified(true);
                }
                objectArray[n].clearChanged();
            }
        }
        if (!this.getModified()) {
            return true;
        }
        Vector<String> vector = new Vector<String>();
        object2 = new Vector();
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "project.xml");
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "configurations.xml");
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "Makefile-impl.mk");
        objectArray = this.getConfs().getConfs();
        for (n = 0; n < objectArray.length; n += 1) {
            vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "Makefile-" + ((Configuration)objectArray[n]).getName() + ".mk");
        }
        n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            object = new File((String)vector.elementAt(i));
            if (!((File)object).exists() || ((File)object).canWrite()) continue;
            n = 0;
            ((Vector)object2).add(vector.elementAt(i));
        }
        if (!n) {
            String string2 = IpeUtils.getBaseName((String)this.getBaseDir());
            object = MakeConfigurationDescriptor.getString("CannotSaveTxt", string2);
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = (String)object + "\n" + ((Vector)object2).elementAt(i);
            }
            if (string != null) {
                object = (String)object + "\n\n" + string;
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message(object, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return n != 0;
        }
        FileObject fileObject = null;
        fileObject = FileUtil.toFileObject((File)new File(this.getBaseDir()));
        if (fileObject != null) {
            new ConfigurationXMLWriter(fileObject, this).write();
            new ConfigurationMakefileWriter(this).write();
            this.ConfigurationProjectXMLWriter();
        }
        this.setModified(false);
        return n != 0;
    }

    private void ConfigurationProjectXMLWriter() {
        try {
            Object object;
            AntProjectHelper antProjectHelper = ((MakeProject)this.getProject()).getAntProjectHelper();
            Element element = antProjectHelper.getPrimaryConfigurationData(true);
            Document document = element.getOwnerDocument();
            NodeList nodeList = element.getElementsByTagName("make-dep-projects");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object = nodeList.item(i);
                    element.removeChild((Node)object);
                }
            }
            Element element2 = document.createElementNS("http://www.netbeans.org/ns/make-project/1", "make-dep-projects");
            object = this.getSubprojectLocations();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Element element3 = document.createElement("make-dep-project");
                element3.appendChild(document.createTextNode(string));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            antProjectHelper.putPrimaryConfigurationData(element, true);
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public Set<String> getSubprojectLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        Configuration[] configurationArray = this.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            int n;
            LibraryItem[] libraryItemArray;
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
            LibrariesConfiguration librariesConfiguration = null;
            if (((MakeConfiguration)configurationArray[i]).isLinkerConfiguration()) {
                librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
                libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
                for (n = 0; n < libraryItemArray.length; ++n) {
                    if (!(libraryItemArray[n] instanceof LibraryItem.ProjectItem)) continue;
                    LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)libraryItemArray[n];
                    hashSet.add(projectItem.getMakeArtifact().getProjectLocation());
                }
            }
            libraryItemArray = makeConfiguration.getRequiredProjectsConfiguration().getRequiredProjectItemsAsArray();
            for (n = 0; n < libraryItemArray.length; ++n) {
                hashSet.add(((LibraryItem.ProjectItem)libraryItemArray[n]).getMakeArtifact().getProjectLocation());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceRootRaw(String string) {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            this.sourceRoots.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSourceRoot(String string) {
        String string2 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
        String string3 = null;
        try {
            string3 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = null;
        }
        String string4 = FilePathAdaptor.normalize(IpeUtils.toRelativePath((String)this.getBaseDir(), (String)string));
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (IpeUtils.isPathAbsolute((String)string4) || string4.startsWith("..")) {
            List<String> list = this.sourceRoots;
            synchronized (list) {
                if (string3 != null) {
                    int n = string3.length();
                    for (String string5 : this.sourceRoots) {
                        String string6 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string5);
                        String string7 = null;
                        try {
                            string7 = new File(string6).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            string7 = null;
                        }
                        if (string7 == null) continue;
                        int n2 = string7.length();
                        if (string7.equals(string3)) {
                            bl = false;
                            break;
                        }
                        if (string7.startsWith(string3) && string7.charAt(n) == File.separatorChar) {
                            arrayList.add(string5);
                            continue;
                        }
                        if (!string3.startsWith(string7) || string3.charAt(n2) != File.separatorChar) continue;
                        bl = false;
                        break;
                    }
                }
                if (arrayList.size() > 0) {
                    for (String string8 : arrayList) {
                        this.sourceRoots.remove(string8);
                    }
                }
                if (bl) {
                    this.sourceRoots.add(string4);
                    this.setModified();
                }
            }
        }
    }

    private List<String> getSourceRootsRaw() {
        return this.sourceRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(List list) {
        List<String> list2 = this.sourceRoots;
        synchronized (list2) {
            this.sourceRoots = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRootsList(List<String> list) {
        Object object = this.sourceRoots;
        synchronized (object) {
            this.sourceRoots.clear();
            for (String string : list) {
                this.addSourceRoot(string);
            }
        }
        object = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class);
        if (object != null) {
            ((MakeSources)object).sourceRootsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSourceRoots() {
        ArrayList<String> arrayList;
        List<String> list = this.sourceRoots;
        synchronized (list) {
            arrayList = new ArrayList<String>(this.sourceRoots);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAbsoluteSourceRoots() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.sourceRoots;
        synchronized (list) {
            for (String string : this.sourceRoots) {
                arrayList.add(IpeUtils.toAbsolutePath((String)this.baseDir, (String)string));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceRootsAsArray() {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            String[] stringArray = new String[this.sourceRoots.size()];
            int n = 0;
            for (String string : this.sourceRoots) {
                stringArray[n++] = string;
            }
            return stringArray;
        }
    }

    private NativeProjectProvider getNativeProject() {
        if (this.nativeProject == null) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(this.baseDir));
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                this.nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            }
            catch (Exception exception) {
                System.err.println("getNativeProject " + exception);
            }
        }
        return (NativeProjectProvider)this.nativeProject;
    }

    public void addSourceFilesFromFolders(Iterator iterator, boolean bl, boolean bl2) {
        this.addSourceFilesFromFolders(this.rootFolder, iterator, bl, bl2);
    }

    public void addSourceFilesFromFolders(Folder folder, Iterator iterator, boolean bl, boolean bl2) {
        if (iterator == null) {
            return;
        }
        if (bl) {
            new AddFilesThread(iterator, folder, bl2).start();
        } else {
            Object object;
            while (iterator.hasNext()) {
                object = new ArrayList();
                FolderEntry folderEntry = (FolderEntry)iterator.next();
                Folder folder2 = folder.findFolderByName(folderEntry.getFile().getName());
                if (folder2 == null) {
                    folder2 = new Folder(folder.getConfigurationDescriptor(), folder, folderEntry.getFile().getName(), folderEntry.getFile().getName(), true);
                    folder.addFolder(folder2);
                }
                this.addFiles(folder2, folderEntry.getFile(), folderEntry.isAddSubfoldersSelected(), folderEntry.getFileFilter(), null, (ArrayList)object, bl2);
                this.getNativeProject().fireFilesAdded((List<NativeFileItem>)object);
                this.addSourceRoot(folderEntry.getFile().getPath());
            }
            if (bl2 && (object = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class)) != null) {
                ((MakeSources)object).sourceRootsChanged();
            }
        }
    }

    private void addFiles(Folder folder, File file, boolean bl, FileFilter fileFilter, ProgressHandle progressHandle, ArrayList arrayList, boolean bl2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            if (!fileFilter.accept(fileArray[i])) continue;
            if (fileArray[i].isDirectory()) {
                if (fileArray[i].getName().equals("SCCS") || fileArray[i].getName().equals(".hg") || fileArray[i].getName().equals("CVS")) continue;
                object = folder;
                if (bl && (object = folder.findFolderByName(fileArray[i].getName())) == null) {
                    object = folder.addNewFolder(fileArray[i].getName(), fileArray[i].getName(), true);
                }
                this.addFiles((Folder)object, fileArray[i], bl, fileFilter, progressHandle, arrayList, bl2);
                if (((Folder)object).size() != 0) continue;
                folder.removeFolder((Folder)object);
                continue;
            }
            object = IpeUtils.toRelativePath((String)this.baseDir, (String)fileArray[i].getPath());
            Item item = new Item(FilePathAdaptor.normalize((String)object));
            if (folder.addItem(item, bl2) != null) {
                arrayList.add(item);
            }
            if (progressHandle == null) continue;
            progressHandle.progress((String)object);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)string, (Object)string2);
    }

    class AddFilesThread
    extends Thread {
        Iterator iterator;
        Folder folder;
        private ProgressHandle handle;
        private boolean notify;

        AddFilesThread(Iterator iterator, Folder folder, boolean bl) {
            this.iterator = iterator;
            this.folder = folder;
            this.notify = bl;
            this.handle = ProgressHandleFactory.createHandle((String)MakeConfigurationDescriptor.getString("AddingFilesTxt"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
            try {
                this.handle.setInitialDelay(500);
                this.handle.start();
                while (this.iterator.hasNext()) {
                    object = (FolderEntry)this.iterator.next();
                    Folder folder = this.folder.findFolderByName(((FolderEntry)object).getFile().getName());
                    if (folder == null) {
                        folder = new Folder(this.folder.getConfigurationDescriptor(), this.folder, ((FolderEntry)object).getFile().getName(), ((FolderEntry)object).getFile().getName(), true);
                        this.folder.addFolder(folder);
                    }
                    MakeConfigurationDescriptor.this.addFiles(folder, ((FolderEntry)object).getFile(), ((FolderEntry)object).isAddSubfoldersSelected(), FolderEntry.getFileFilter(), this.handle, arrayList, true);
                    MakeConfigurationDescriptor.this.addSourceRoot(((FolderEntry)object).getFile().getPath());
                }
            }
            finally {
                this.handle.finish();
            }
            MakeConfigurationDescriptor.this.getNativeProject().fireFilesAdded(arrayList);
            if (this.notify && (object = (MakeSources)MakeConfigurationDescriptor.this.getProject().getLookup().lookup(MakeSources.class)) != null) {
                ((MakeSources)object).sourceRootsChanged();
            }
        }
    }

    public static class ProjectItemChangeEvent
    extends ChangeEvent {
        public static final int ITEM_ADDED = 0;
        public static final int ITEM_REMOVED = 1;
        private Item item;
        private int action;

        public ProjectItemChangeEvent(Object object, Item item, int n) {
            super(object);
            this.item = item;
            this.action = n;
        }

        public Item getItem() {
            return this.item;
        }

        public int getAction() {
            return this.action;
        }
    }

    private class SaveRunnable
    implements Runnable {
        public boolean ret = false;
        private String extraMessage;

        public SaveRunnable(String string) {
            this.extraMessage = string;
        }

        public void run() {
            this.ret = MakeConfigurationDescriptor.this.saveWorker(this.extraMessage);
        }
    }
}

