/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.PersistentList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class SunCCCCompiler
extends CCCCompiler {
    protected PersistentList systemIncludeDirectoriesList = null;
    protected PersistentList systemPreprocessorSymbolsList = null;

    public SunCCCCompiler(String string, CompilerSet.CompilerFlavor compilerFlavor, int n, String string2, String string3, String string4) {
        super(string, compilerFlavor, n, string2, string3, string4);
    }

    public boolean setSystemIncludeDirectories(List list) {
        assert (list != null);
        if (((Object)list).equals(this.systemIncludeDirectoriesList)) {
            return false;
        }
        this.systemIncludeDirectoriesList = new PersistentList(list);
        this.normalizePaths(this.systemIncludeDirectoriesList);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    public boolean setSystemPreprocessorSymbols(List list) {
        assert (list != null);
        if (((Object)list).equals(this.systemPreprocessorSymbolsList)) {
            return false;
        }
        this.systemPreprocessorSymbolsList = new PersistentList(list);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    public List getSystemPreprocessorSymbols() {
        if (this.systemPreprocessorSymbolsList != null) {
            return this.systemPreprocessorSymbolsList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemPreprocessorSymbolsList;
    }

    public List getSystemIncludeDirectories() {
        if (this.systemIncludeDirectoriesList != null) {
            return this.systemIncludeDirectoriesList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemIncludeDirectoriesList;
    }

    public void saveSystemIncludesAndDefines() {
        if (this.systemIncludeDirectoriesList != null) {
            this.systemIncludeDirectoriesList.saveList(this.getUniqueID() + "systemIncludeDirectoriesList");
        }
        if (this.systemPreprocessorSymbolsList != null) {
            this.systemPreprocessorSymbolsList.saveList(this.getUniqueID() + "systemPreprocessorSymbolsList");
        }
    }

    private void restoreSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList");
        this.systemPreprocessorSymbolsList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList");
    }

    private void getSystemIncludesAndDefines() {
        this.restoreSystemIncludesAndDefines();
        if (this.systemIncludeDirectoriesList == null || this.systemPreprocessorSymbolsList == null) {
            this.getFreshSystemIncludesAndDefines();
        }
    }

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getNames().length > 0) {
            return compilerDescriptor.getNames()[0];
        }
        return "";
    }

    protected abstract String getCompilerStderrCommand();

    protected abstract String getCompilerStderrCommand2();

    private void getFreshSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = new PersistentList();
        this.systemPreprocessorSymbolsList = new PersistentList();
        String string = this.getPath();
        if (string == null || !PlatformInfo.getDefault((String)this.getHostKey()).fileExists(string)) {
            string = this.getDefaultPath();
        }
        try {
            this.getSystemIncludesAndDefines(IpeUtils.getDirName((String)string), string + this.getCompilerStderrCommand(), false);
            if (this.getCompilerStderrCommand2() != null) {
                this.getSystemIncludesAndDefines(IpeUtils.getDirName((String)string), string + this.getCompilerStderrCommand2(), false);
            }
            this.systemIncludeDirectoriesList.addUnique(this.normalizePath("/usr/include"));
            this.saveSystemIncludesAndDefines();
        }
        catch (IOException iOException) {
            System.err.println("IOException " + iOException);
            String string2 = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CANTFINDCOMPILER", (Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
        }
    }

    public void resetSystemIncludesAndDefines() {
        this.getFreshSystemIncludesAndDefines();
    }
}

