/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.PersistentList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class GNUCCCCompiler
extends CCCCompiler {
    private PersistentList systemIncludeDirectoriesList = null;
    private PersistentList systemPreprocessorSymbolsList = null;
    private String includeFilePrefix = null;

    public GNUCCCCompiler(String string, CompilerSet.CompilerFlavor compilerFlavor, int n, String string2, String string3, String string4) {
        super(string, compilerFlavor, n, string2, string3, string4);
    }

    public boolean setSystemIncludeDirectories(List list) {
        assert (list != null);
        if (((Object)list).equals(this.systemIncludeDirectoriesList)) {
            return false;
        }
        this.systemIncludeDirectoriesList = new PersistentList(list);
        this.normalizePaths(this.systemIncludeDirectoriesList);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    public boolean setSystemPreprocessorSymbols(List list) {
        assert (list != null);
        if (((Object)list).equals(this.systemPreprocessorSymbolsList)) {
            return false;
        }
        this.systemPreprocessorSymbolsList = new PersistentList(list);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    public List getSystemPreprocessorSymbols() {
        if (this.systemPreprocessorSymbolsList != null) {
            return this.systemPreprocessorSymbolsList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemPreprocessorSymbolsList;
    }

    public List getSystemIncludeDirectories() {
        if (this.systemIncludeDirectoriesList != null) {
            return this.systemIncludeDirectoriesList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemIncludeDirectoriesList;
    }

    public void saveSystemIncludesAndDefines() {
        if (this.systemIncludeDirectoriesList != null) {
            this.systemIncludeDirectoriesList.saveList(this.getUniqueID() + "systemIncludeDirectoriesList");
        }
        if (this.systemPreprocessorSymbolsList != null) {
            this.systemPreprocessorSymbolsList.saveList(this.getUniqueID() + "systemPreprocessorSymbolsList");
        }
    }

    private void restoreSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList");
        this.systemPreprocessorSymbolsList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList");
    }

    private void getSystemIncludesAndDefines() {
        this.restoreSystemIncludesAndDefines();
        if (this.systemIncludeDirectoriesList == null || this.systemPreprocessorSymbolsList == null) {
            this.getFreshSystemIncludesAndDefines();
        }
    }

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getNames().length > 0) {
            return compilerDescriptor.getNames()[0];
        }
        return "";
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getIncludeFlags();
        }
        return "";
    }

    protected String getCompilerStdoutCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getMacroFlags();
        }
        return "";
    }

    private void getFreshSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = new PersistentList();
        this.systemPreprocessorSymbolsList = new PersistentList();
        String string = this.getPath();
        if (string != null && string.length() == 0) {
            return;
        }
        if (string == null || !PlatformInfo.getDefault((String)this.getHostKey()).fileExists(string)) {
            string = this.getDefaultPath();
        }
        try {
            this.getSystemIncludesAndDefines(IpeUtils.getDirName((String)string), string + this.getCompilerStderrCommand(), false);
            this.getSystemIncludesAndDefines(IpeUtils.getDirName((String)string), string + this.getCompilerStdoutCommand(), true);
            if (!this.containsMacro(this.systemPreprocessorSymbolsList, "__STDC__")) {
                this.systemPreprocessorSymbolsList.add("__STDC__=1");
            }
            this.saveSystemIncludesAndDefines();
        }
        catch (IOException iOException) {
            System.err.println("IOException " + iOException);
            String string2 = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CANTFINDCOMPILER", (Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
        }
    }

    public void resetSystemIncludesAndDefines() {
        this.getFreshSystemIncludesAndDefines();
    }

    private boolean startsWithPath(String string) {
        if ((string = string.trim()).startsWith("/")) {
            return true;
        }
        return System.getProperty("os.name").indexOf("Windows") >= 0 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':';
    }

    protected String cutIncludePrefix(String string) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
            String string2 = compilerDescriptor.getRemoveIncludeOutputPrefix();
            if (string.toLowerCase().startsWith(this.getIncludeFilePathPrefix().toLowerCase())) {
                string = string.substring(this.getIncludeFilePathPrefix().length());
            } else if (string.toLowerCase().startsWith(string2)) {
                string = string.substring(string2.length());
            }
        }
        return string;
    }

    public String getIncludeFilePathPrefix() {
        if (this.includeFilePrefix == null) {
            this.includeFilePrefix = "";
            ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
            if (compilerDescriptor != null) {
                int n;
                String string = this.getPath().replaceAll("\\\\", "/");
                if (compilerDescriptor.getRemoveIncludePathPrefix() != null && (n = string.toLowerCase().indexOf("/bin")) > 0) {
                    this.includeFilePrefix = string.substring(0, n);
                }
            }
        }
        return this.includeFilePrefix;
    }

    protected void parseCompilerOutput(BufferedReader bufferedReader) {
        try {
            String string;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.contains("#include <...>")) {
                    bl = true;
                    continue;
                }
                if (bl && (string.startsWith("End of search") || !this.startsWithPath(string))) {
                    bl = false;
                    continue;
                }
                if (bl) {
                    string = this.cutIncludePrefix(string.trim());
                    this.systemIncludeDirectoriesList.addUnique(this.normalizePath(this.getIncludeFilePathPrefix() + string));
                    if (this.getIncludeFilePathPrefix().length() <= 0 || !string.startsWith("/usr/lib")) continue;
                    this.systemIncludeDirectoriesList.addUnique(this.normalizePath(this.getIncludeFilePathPrefix() + string.substring(4)));
                    continue;
                }
                this.parseUserMacros(string, this.systemPreprocessorSymbolsList);
                if (!string.startsWith("#define ") || (n = string.indexOf(32, 8)) <= 0) continue;
                String string2 = string.substring(8, n) + "=" + string.substring(n + 1);
                this.systemPreprocessorSymbolsList.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
    }

    private void dumpLists() {
        int n;
        System.out.println("==================================" + this.getDisplayName());
        for (n = 0; n < this.systemIncludeDirectoriesList.size(); ++n) {
            System.out.println("-I" + this.systemIncludeDirectoriesList.get(n));
        }
        for (n = 0; n < this.systemPreprocessorSymbolsList.size(); ++n) {
            System.out.println("-D" + this.systemPreprocessorSymbolsList.get(n));
        }
    }
}

