/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.NativeExecutor;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.CustomProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.CustomProjectActionHandlerProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.SelectExecutablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class DefaultProjectActionHandler
implements ActionListener {
    private CustomProjectActionHandlerProvider customActionHandlerProvider = null;
    private CustomProjectActionHandler customActionHandler = null;
    private static DefaultProjectActionHandler instance = null;
    private static InputOutput mainTab = null;
    private static HandleEvents mainTabHandler = null;
    private static ArrayList tabNames = new ArrayList();

    public static DefaultProjectActionHandler getInstance() {
        if (instance == null) {
            instance = new DefaultProjectActionHandler();
        }
        return instance;
    }

    public void setCustomDebugActionHandlerProvider(CustomProjectActionHandlerProvider customProjectActionHandlerProvider) {
        this.customActionHandlerProvider = customProjectActionHandlerProvider;
    }

    public CustomProjectActionHandlerProvider getCustomDebugActionHandlerProvider() {
        if (this.customActionHandlerProvider != null) {
            return this.customActionHandlerProvider;
        }
        Lookup.Template template = new Lookup.Template(CustomProjectActionHandlerProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof CustomProjectActionHandlerProvider)) continue;
            this.customActionHandlerProvider = (CustomProjectActionHandlerProvider)e;
            if (!this.customActionHandlerProvider.getClass().getName().contains("dbx")) continue;
            break;
        }
        return this.customActionHandlerProvider;
    }

    public void setCustomActionHandlerProvider(CustomProjectActionHandler customProjectActionHandler) {
        this.customActionHandler = customProjectActionHandler;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ProjectActionEvent[] projectActionEventArray = (ProjectActionEvent[])actionEvent.getSource();
        new HandleEvents(projectActionEventArray).go();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(DefaultProjectActionHandler.class).getString(string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(DefaultProjectActionHandler.class, (String)string, (Object)string2);
    }

    private static final class RerunAction
    extends AbstractAction {
        HandleEvents handleEvents;

        public RerunAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(DefaultProjectActionHandler.class.getResource("/org/netbeans/modules/cnd/makeproject/ui/resources/rerun.png"));
            }
            if (string.equals("ShortDescription")) {
                return DefaultProjectActionHandler.getString("TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            this.handleEvents.reRun();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        HandleEvents handleEvents;

        public StopAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(DefaultProjectActionHandler.class.getResource("/org/netbeans/modules/cnd/makeproject/ui/resources/stop.png"));
            }
            if (string.equals("ShortDescription")) {
                return DefaultProjectActionHandler.getString("TargetExecutor.StopAction.stop");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            if (this.handleEvents.getExecutorTask() != null) {
                this.handleEvents.getNativeExecutor().stop();
                this.handleEvents.getExecutorTask().stop();
            }
        }
    }

    class HandleEvents
    implements ExecutionListener {
        private InputOutput ioTab = null;
        private ProjectActionEvent[] paes;
        private String tabName;
        private String tabNameSeq;
        int currentAction = 0;
        private ExecutorTask executorTask = null;
        private NativeExecutor projectExecutor = null;
        private StopAction sa = null;
        private RerunAction ra = null;
        private ProgressHandle progressHandle = null;
        private final Object lock = new Object();

        private String getTabName(ProjectActionEvent[] projectActionEventArray) {
            String string = ProjectUtils.getInformation((Project)projectActionEventArray[0].getProject()).getName();
            String string2 = string + " (";
            for (int i = 0; i < projectActionEventArray.length; ++i) {
                if (i >= 2) {
                    string2 = string2 + "...";
                    break;
                }
                string2 = string2 + projectActionEventArray[i].getActionName();
                if (i >= projectActionEventArray.length - 1) continue;
                string2 = string2 + ", ";
            }
            string2 = string2 + ")";
            return string2;
        }

        private InputOutput getTab() {
            return this.ioTab;
        }

        private ProgressHandle createPogressHandle() {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    HandleEvents.this.sa.actionPerformed(null);
                    return true;
                }
            }, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HandleEvents.this.getTab().select();
                }
            });
            progressHandle.setInitialDelay(0);
            return progressHandle;
        }

        private ProgressHandle createPogressHandleNoCancel() {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HandleEvents.this.getTab().select();
                }
            });
            progressHandle.setInitialDelay(0);
            return progressHandle;
        }

        private InputOutput getIOTab(String string, boolean bl) {
            InputOutput inputOutput;
            this.sa = new StopAction(this);
            this.ra = new RerunAction(this);
            if (bl) {
                inputOutput = IOProvider.getDefault().getIO(string, false);
                inputOutput.closeInputOutput();
            }
            inputOutput = IOProvider.getDefault().getIO(string, new Action[]{this.ra, this.sa});
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressHandle = this.createPogressHandle();
            this.progressHandle.start();
            return inputOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HandleEvents(ProjectActionEvent[] projectActionEventArray) {
            this.paes = projectActionEventArray;
            this.currentAction = 0;
            if (MakeOptions.getInstance().getReuse()) {
                Object object = this.lock;
                synchronized (object) {
                    if (mainTabHandler == null && mainTab != null) {
                        mainTab.closeInputOutput();
                        mainTab = null;
                    }
                    this.tabNameSeq = this.tabName = this.getTabName(projectActionEventArray);
                    if (tabNames.contains(this.tabName)) {
                        int n = 2;
                        while (true) {
                            this.tabNameSeq = this.tabName + " #" + n;
                            if (!tabNames.contains(this.tabNameSeq)) break;
                            ++n;
                        }
                    }
                    tabNames.add(this.tabNameSeq);
                    this.ioTab = this.getIOTab(this.tabNameSeq, true);
                    if (mainTabHandler == null) {
                        mainTab = this.ioTab;
                        mainTabHandler = this;
                    }
                }
            } else {
                this.tabNameSeq = this.tabName = this.getTabName(projectActionEventArray);
                this.ioTab = this.getIOTab(this.tabName, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reRun() {
            this.currentAction = 0;
            this.getTab().closeInputOutput();
            Object object = this.lock;
            synchronized (object) {
                tabNames.add(this.tabNameSeq);
            }
            try {
                this.getTab().getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressHandle = this.createPogressHandle();
            this.progressHandle.start();
            this.go();
        }

        public void go() {
            this.executorTask = null;
            this.sa.setEnabled(false);
            this.ra.setEnabled(false);
            if (this.currentAction >= this.paes.length) {
                return;
            }
            ProjectActionEvent projectActionEvent = this.paes[this.currentAction];
            String string = null;
            if (!(projectActionEvent.getID() != 2 && projectActionEvent.getID() != 3 && projectActionEvent.getID() != 5 && projectActionEvent.getID() != 4 && projectActionEvent.getID() != 6 || this.checkExecutable(projectActionEvent))) {
                this.progressHandle.finish();
                return;
            }
            if ((projectActionEvent.getID() == 3 || projectActionEvent.getID() == 5 || projectActionEvent.getID() == 4) && DefaultProjectActionHandler.this.getCustomDebugActionHandlerProvider() != null) {
                this.progressHandle.finish();
                this.progressHandle = this.createPogressHandleNoCancel();
                this.progressHandle.start();
                CustomProjectActionHandler customProjectActionHandler = DefaultProjectActionHandler.this.getCustomDebugActionHandlerProvider().factoryCreate();
                customProjectActionHandler.addExecutionListener(this);
                customProjectActionHandler.execute(projectActionEvent, this.getTab());
            } else if (projectActionEvent.getID() == 2 || projectActionEvent.getID() == 0 || projectActionEvent.getID() == 1) {
                String[] stringArray;
                String string2;
                String string3 = IpeUtils.quoteIfNecessary((String)projectActionEvent.getExecutable());
                String string4 = projectActionEvent.getProfile().getArgsFlat();
                String[] stringArray2 = projectActionEvent.getProfile().getEnvironment().getenv();
                boolean bl = projectActionEvent.getID() == 2;
                MakeConfiguration makeConfiguration = (MakeConfiguration)projectActionEvent.getConfiguration();
                String string5 = makeConfiguration.getDevelopmentHost().getDisplayName();
                if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
                    string2 = projectActionEvent.getProfile().getBaseDir();
                    stringArray = HostInfoProvider.getDefault().getMapper(string5);
                    if (!stringArray.isRemote(string2, true)) {
                        this.progressHandle.finish();
                        return;
                    }
                }
                string2 = PlatformInfo.getDefault((String)makeConfiguration.getDevelopmentHost().getName());
                if (projectActionEvent.getID() == 2) {
                    Object object;
                    Object object2;
                    int n = projectActionEvent.getProfile().getConsoleType().getValue();
                    if (projectActionEvent.getProfile().getTerminalType() == null || projectActionEvent.getProfile().getTerminalPath() == null) {
                        object2 = Utilities.isMac() ? DefaultProjectActionHandler.getString("Err_NoTermFoundMacOSX") : DefaultProjectActionHandler.getString("Err_NoTermFound");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object2));
                        n = 2;
                    }
                    if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
                        n = 2;
                    }
                    if (n == 2) {
                        string4 = projectActionEvent.getProfile().getArgsFlat();
                        string3 = IpeUtils.quoteIfNecessary((String)projectActionEvent.getExecutable());
                    } else {
                        bl = false;
                        if (n == 0) {
                            n = projectActionEvent.getProfile().getDefaultConsoleType();
                        }
                        if (n == 1) {
                            try {
                                string = File.createTempFile("nbcnd_rc", "").getAbsolutePath();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (projectActionEvent.getProfile().getTerminalPath().indexOf("gnome-terminal") != -1) {
                                object = new StringBuffer();
                                for (int i = 0; i < string4.length(); ++i) {
                                    if (string4.charAt(i) == '\"') {
                                        ((StringBuffer)object).append("\\\"");
                                        continue;
                                    }
                                    ((StringBuffer)object).append(string4.charAt(i));
                                }
                                object2 = ((StringBuffer)object).toString();
                            } else {
                                object2 = "";
                            }
                            string4 = MessageFormat.format(projectActionEvent.getProfile().getTerminalOptions(), string, string3, string4, object2);
                            string3 = projectActionEvent.getProfile().getTerminalPath();
                        }
                        this.progressHandle.finish();
                        this.progressHandle = this.createPogressHandleNoCancel();
                        this.progressHandle.start();
                    }
                    object2 = new ArrayList();
                    object = makeConfiguration.getCompilerSet().getCompilerSet();
                    if (object != null) {
                        String string6 = object.getDirectory();
                        String string7 = object.getCompilerFlavor().getCommandFolder(makeConfiguration.getPlatform().getValue());
                        if (string7 != null && string7.length() > 0) {
                            string6 = string6 + string2.pathSeparator() + string7;
                        }
                        boolean bl2 = false;
                        String string8 = string2.getPathName() + '=';
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (stringArray2[i].startsWith(string8)) {
                                ((ArrayList)object2).add(stringArray2[i] + string2.pathSeparator() + string6);
                                bl2 = true;
                                continue;
                            }
                            ((ArrayList)object2).add(stringArray2[i]);
                        }
                        if (!bl2) {
                            ((ArrayList)object2).add(string8 + string2.getPathAsString() + string2.pathSeparator() + string6);
                        }
                        stringArray2 = ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
                    }
                } else {
                    stringArray = new String[stringArray2.length + 1];
                    String string9 = makeConfiguration.getCompilerSet().getCompilerSet().getDirectory();
                    String string10 = makeConfiguration.getCompilerSet().getCompilerSet().getCompilerFlavor().getCommandFolder(makeConfiguration.getPlatform().getValue());
                    if (string10 != null && string10.length() > 0) {
                        string9 = string9 + string2.pathSeparator() + string10;
                    }
                    boolean bl3 = false;
                    String string11 = string2.getPathName() + '=';
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i].startsWith(string11)) {
                            stringArray[i] = string11 + string9 + string2.pathSeparator() + stringArray2[i].substring(5);
                            bl3 = true;
                            continue;
                        }
                        stringArray[i] = stringArray2[i];
                    }
                    if (!bl3) {
                        String string12 = makeConfiguration.getPlatformInfo().getPathAsString();
                        stringArray[i] = string11 + string9 + string2.pathSeparator() + string12;
                    }
                    stringArray2 = stringArray;
                }
                this.projectExecutor = new NativeExecutor(string5, projectActionEvent.getProfile().getRunDirectory(), string3, string4, stringArray2, projectActionEvent.getTabName(), projectActionEvent.getActionName(), projectActionEvent.getID() == 0, bl);
                this.projectExecutor.addExecutionListener((ExecutionListener)this);
                if (string != null) {
                    this.projectExecutor.setExitValueOverride(string);
                }
                try {
                    this.sa.setEnabled(projectActionEvent.getID() != 2 || bl);
                    this.ra.setEnabled(false);
                    this.executorTask = this.projectExecutor.execute(this.getTab());
                }
                catch (IOException iOException) {}
            } else if (projectActionEvent.getID() == 6) {
                this.progressHandle.finish();
                this.progressHandle = this.createPogressHandleNoCancel();
                this.progressHandle.start();
                DefaultProjectActionHandler.this.customActionHandler.addExecutionListener(this);
                DefaultProjectActionHandler.this.customActionHandler.execute(projectActionEvent, this.getTab());
            } else if (projectActionEvent.getID() == 3 || projectActionEvent.getID() == 4 || projectActionEvent.getID() == 5) {
                System.err.println("No built-in debugging");
            } else assert (false);
        }

        public ExecutorTask getExecutorTask() {
            return this.executorTask;
        }

        public NativeExecutor getNativeExecutor() {
            return this.projectExecutor;
        }

        public void executionStarted() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionFinished(int n) {
            Object object;
            if (this.paes[this.currentAction].getID() == 0 || this.paes[this.currentAction].getID() == 1) {
                try {
                    object = this.paes[this.currentAction].getProject().getProjectDirectory();
                    object.getFileSystem().refresh(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.currentAction >= this.paes.length - 1 || n != 0) {
                object = this.lock;
                synchronized (object) {
                    if (mainTabHandler == this) {
                        mainTabHandler = null;
                    }
                    tabNames.remove(this.tabNameSeq);
                }
                this.sa.setEnabled(false);
                this.ra.setEnabled(true);
                this.progressHandle.finish();
                return;
            }
            if (n == 0) {
                ++this.currentAction;
                this.go();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkExecutable(ProjectActionEvent projectActionEvent) {
            Object object;
            String string = projectActionEvent.getExecutable();
            if (string.length() == 0) {
                if (((MakeConfiguration)projectActionEvent.getConfiguration()).isMakefileConfiguration()) {
                    object = new SelectExecutablePanel((MakeConfiguration)projectActionEvent.getConfiguration());
                    DialogDescriptor dialogDescriptor = new DialogDescriptor(object, DefaultProjectActionHandler.getString("SELECT_EXECUTABLE"));
                    ((SelectExecutablePanel)object).setDialogDescriptor(dialogDescriptor);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                    if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) return false;
                    MakeConfiguration makeConfiguration = (MakeConfiguration)projectActionEvent.getConfiguration();
                    string = ((SelectExecutablePanel)object).getExecutable();
                    string = FilePathAdaptor.naturalize(string);
                    string = IpeUtils.toRelativePath((String)makeConfiguration.getBaseDir(), (String)string);
                    string = FilePathAdaptor.normalize(string);
                    makeConfiguration.getMakefileConfiguration().getOutput().setValue(string);
                    ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)projectActionEvent.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class);
                    if (configurationDescriptorProvider != null) {
                        configurationDescriptorProvider.getConfigurationDescriptor().setModified();
                    }
                    if (projectActionEvent.getID() == 2) {
                        projectActionEvent.setExecutable(string);
                    } else {
                        projectActionEvent.setExecutable(makeConfiguration.getMakefileConfiguration().getAbsOutput());
                    }
                } else {
                    String string2 = DefaultProjectActionHandler.getString("NO_BUILD_RESULT");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
                    return false;
                }
            }
            if (!IpeUtils.isPathAbsolute((String)string)) return true;
            File file = new File(string);
            if (!file.exists()) {
                file = new File(string + ".exe");
            }
            if (file.exists() && !file.isDirectory()) return true;
            object = DefaultProjectActionHandler.getString("EXECUTABLE_DOESNT_EXISTS", projectActionEvent.getExecutable());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object, 0));
            return false;
        }
    }
}

