/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.propertyeditors.binding.DataBindingHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

public class DataBindingHelperRegistry {
    private static DataBindingHelper DATA_BINDING_HELPER;

    public static void setDataBindingHelper(DataBindingHelper dataBindingHelper) {
        DATA_BINDING_HELPER = dataBindingHelper;
    }

    public static DataBindingHelper getDataBindingHelper() {
        return DATA_BINDING_HELPER;
    }

    private static DataBindingHelper findDataBindingHelper(ClassLoader classLoader) {
        try {
            String interfaceName = "META-INF/services/" + DataBindingHelper.class.getName();
            Enumeration<URL> urls = classLoader.getResources(interfaceName);
            Class<?> dataBindingHelperClass = null;
            while (dataBindingHelperClass == null && urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    String content = reader.readLine();
                    if (content == null || DataBindingHelper.class.isAssignableFrom(dataBindingHelperClass = Class.forName(content = content.trim(), false, classLoader))) continue;
                    throw new ClassNotFoundException(dataBindingHelperClass.getName() + " is not a subclass of " + DataBindingHelper.class.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dataBindingHelperClass = null;
                }
            }
            if (dataBindingHelperClass != null) {
                DataBindingHelper dataBindingHelper = (DataBindingHelper)dataBindingHelperClass.newInstance();
                return dataBindingHelper;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("No implementation of " + DataBindingHelper.class.getName() + " found.");
        return null;
    }
}

