/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        if ("true".equals(System.getProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips"))) {
            return null;
        }
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        String string;
        block19: {
            StyledDocument styledDocument;
            if (this.lp == null || this.ec == null) {
                return;
            }
            try {
                styledDocument = this.ec.openDocument();
            }
            catch (IOException iOException) {
                return;
            }
            JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
            if (jEditorPane == null) {
                return;
            }
            int n = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
            String string2 = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, n);
            if (string2 == null) {
                return;
            }
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (debuggerEngine == null) {
                return;
            }
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) {
                return;
            }
            JPDAThread jPDAThread = jPDADebugger.getCurrentThread();
            if (jPDAThread == null || !jPDAThread.isSuspended()) {
                return;
            }
            string = null;
            try {
                Variable variable = null;
                List list = jPDAThread.getLastOperations();
                if (list != null) {
                    for (Object object : list) {
                        if (!string2.endsWith(object.getMethodName()) || object.getMethodStartPosition().getOffset() > n || n > object.getMethodEndPosition().getOffset()) continue;
                        variable = object.getReturnValue();
                    }
                }
                if (variable == null) {
                    variable = jPDADebugger.evaluate(string2);
                }
                String string3 = variable.getType();
                if (variable instanceof ObjectVariable) {
                    try {
                        Object object;
                        object = null;
                        try {
                            Method method = variable.getClass().getMethod("getToStringValue", Integer.TYPE);
                            method.setAccessible(true);
                            object = (String)method.invoke((Object)variable, 10000);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (object == null) {
                            object = ((ObjectVariable)variable).getToStringValue();
                        }
                        string = string2 + " = " + (string3.length() == 0 ? "" : "(" + (String)string3 + ") ") + (String)object;
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        string = string2 + " = " + (string3.length() == 0 ? "" : "(" + (String)string3 + ") ") + variable.getValue();
                    }
                    break block19;
                }
                string = string2 + " = " + (string3.length() == 0 ? "" : "(" + (String)string3 + ") ") + variable.getValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                string = string2 + " = >" + invalidExpressionException.getMessage() + "<";
            }
        }
        this.firePropertyChange("shortDescription", null, string);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

