/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.ui.views.ViewModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class View
extends TopComponent
implements HelpCtx.Provider {
    public static final String BREAKPOINTS_VIEW_NAME = "BreakpointsView";
    public static final String CALLSTACK_VIEW_NAME = "CallStackView";
    public static final String LOCALS_VIEW_NAME = "LocalsView";
    public static final String SESSIONS_VIEW_NAME = "SessionsView";
    public static final String THREADS_VIEW_NAME = "ThreadsView";
    public static final String WATCHES_VIEW_NAME = "WatchesView";
    public static final String SOURCES_VIEW_NAME = "SourcesView";
    private transient JComponent tree;
    private transient ViewModelListener viewModelListener;
    private String name;
    private transient String helpID;
    private transient String propertiesHelpID;
    private transient String displayNameResource;
    private transient String toolTipResource;

    private View(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setIcon(Utilities.loadImage((String)string));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.name = string2;
        this.helpID = string3;
        this.propertiesHelpID = string4;
        this.displayNameResource = string5;
        this.toolTipResource = string6;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name;
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.tree == null) {
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(NbBundle.getMessage(View.class, (String)this.toolTipResource));
            this.add(this.tree, "Center");
        }
        this.viewModelListener = new ViewModelListener(this.name, this.tree, this.propertiesHelpID);
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpID);
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.tree == null) {
            return false;
        }
        return this.tree.requestFocusInWindow();
    }

    public void requestActive() {
        super.requestActive();
        if (this.tree != null) {
            this.tree.requestFocusInWindow();
        }
    }

    public String getName() {
        return NbBundle.getMessage(View.class, (String)this.displayNameResource);
    }

    public String getToolTipText() {
        return NbBundle.getMessage(View.class, (String)this.toolTipResource);
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.name);
    }

    public static synchronized TopComponent getBreakpointsView() {
        return new View("org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint.gif", BREAKPOINTS_VIEW_NAME, "NetbeansDebuggerBreakpointNode", null, "CTL_Breakpoints_view", "CTL_Breakpoints_view_tooltip");
    }

    public static synchronized TopComponent getCallStackView() {
        return new View("org/netbeans/modules/debugger/resources/allInOneView/CallStack.gif", CALLSTACK_VIEW_NAME, "NetbeansDebuggerCallStackNode", null, "CTL_Call_stack_view", "CTL_Call_stack_view_tooltip");
    }

    public static synchronized TopComponent getLocalsView() {
        return new View("org/netbeans/modules/debugger/resources/localsView/local_variable_16.png", LOCALS_VIEW_NAME, "NetbeansDebuggerVariableNode", null, "CTL_Variables_view", "CTL_Locals_view_tooltip");
    }

    public static synchronized TopComponent getSessionsView() {
        return new View("org/netbeans/modules/debugger/resources/sessionsView/session_16.png", SESSIONS_VIEW_NAME, "NetbeansDebuggerSessionNode", "NetbeansDebuggerSessionsPropertiesSheet", "CTL_Sessions_view", "CTL_Sessions_view_tooltip");
    }

    public static synchronized TopComponent getThreadsView() {
        return new View("org/netbeans/modules/debugger/resources/threadsView/RunningThread.gif", THREADS_VIEW_NAME, "NetbeansDebuggerThreadNode", "NetbeansDebuggerThreadsPropertiesSheet", "CTL_Threads_view", "CTL_Threads_view_tooltip");
    }

    public static synchronized TopComponent getWatchesView() {
        return new View("org/netbeans/modules/debugger/resources/watchesView/watch_16.png", WATCHES_VIEW_NAME, "NetbeansDebuggerWatchNode", null, "CTL_Watches_view", "CTL_Watches_view_tooltip");
    }

    public static synchronized TopComponent getSourcesView() {
        return new View("org/netbeans/modules/debugger/resources/sourcesView/sources_16.png", SOURCES_VIEW_NAME, "NetbeansDebuggerSourcesNode", null, "CTL_Sources_view", "CTL_Sources_view_tooltip");
    }

    private static TopComponent getView(String string) {
        if (string.equals(BREAKPOINTS_VIEW_NAME)) {
            return View.getBreakpointsView();
        }
        if (string.equals(CALLSTACK_VIEW_NAME)) {
            return View.getCallStackView();
        }
        if (string.equals(LOCALS_VIEW_NAME)) {
            return View.getLocalsView();
        }
        if (string.equals(SESSIONS_VIEW_NAME)) {
            return View.getSessionsView();
        }
        if (string.equals(THREADS_VIEW_NAME)) {
            return View.getThreadsView();
        }
        if (string.equals(WATCHES_VIEW_NAME)) {
            return View.getWatchesView();
        }
        if (string.equals(SOURCES_VIEW_NAME)) {
            return View.getSourcesView();
        }
        throw new IllegalArgumentException(string);
    }

    private static final class ResolvableHelper
    implements Externalizable {
        private String name;
        private static final long serialVersionUID = 1L;

        public ResolvableHelper(String string) {
            this.name = string;
        }

        public ResolvableHelper() {
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.name);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.name = (String)objectInput.readObject();
        }

        public Object readResolve() {
            return View.getView(this.name);
        }
    }
}

