/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class ManyVarsDynamicScope
extends DynamicScope {
    private IRubyObject[] variableValues;

    public ManyVarsDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
        this.allocate();
    }

    public ManyVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
        this.allocate();
    }

    private void allocate() {
        if (this.variableValues == null) {
            int n = this.staticScope.getNumberOfVariables();
            this.variableValues = new IRubyObject[n];
        }
    }

    public DynamicScope cloneScope() {
        return new ManyVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (this.variableValues != null) : "No variables in getValue for off: " + n + ", Dep: " + n2;
        assert (n < this.variableValues.length) : "Index to big for getValue off: " + n + ", Dep: " + n2 + ", O: " + this;
        return this.variableValues[n];
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        if (n2 > 0) {
            return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
        }
        return this.getValueDepthZeroOrNil(n, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (this.variableValues != null) : "No variables in getValue for off: " + n + ", Dep: " + 0;
        assert (n < this.variableValues.length) : "Index to big for getValue off: " + n + ", Dep: " + 0 + ", O: " + this;
        IRubyObject iRubyObject2 = this.variableValues[n];
        if (iRubyObject2 == null) {
            this.variableValues[n] = iRubyObject;
            iRubyObject2 = iRubyObject;
        }
        return iRubyObject2;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject iRubyObject) {
        assert (this.variableValues != null) : "No variables in getValue for off: 0, Dep: 0";
        assert (0 < this.variableValues.length) : "Index to big for getValue off: 0, Dep: 0, O: " + this;
        IRubyObject iRubyObject2 = this.variableValues[0];
        if (iRubyObject2 == null) {
            this.variableValues[0] = iRubyObject;
            iRubyObject2 = iRubyObject;
        }
        return iRubyObject2;
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject iRubyObject) {
        assert (this.variableValues != null) : "No variables in getValue for off: 1, Dep: 0";
        assert (1 < this.variableValues.length) : "Index to big for getValue off: 1, Dep: 0, O: " + this;
        IRubyObject iRubyObject2 = this.variableValues[1];
        if (iRubyObject2 == null) {
            this.variableValues[1] = iRubyObject;
            iRubyObject2 = iRubyObject;
        }
        return iRubyObject2;
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject iRubyObject) {
        assert (this.variableValues != null) : "No variables in getValue for off: 2, Dep: 0";
        assert (2 < this.variableValues.length) : "Index to big for getValue off: 2, Dep: 0, O: " + this;
        IRubyObject iRubyObject2 = this.variableValues[2];
        if (iRubyObject2 == null) {
            this.variableValues[2] = iRubyObject;
            iRubyObject2 = iRubyObject;
        }
        return iRubyObject2;
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject iRubyObject) {
        assert (this.variableValues != null) : "No variables in getValue for off: 3, Dep: 0";
        assert (3 < this.variableValues.length) : "Index to big for getValue off: 3, Dep: 0, O: " + this;
        IRubyObject iRubyObject2 = this.variableValues[3];
        if (iRubyObject2 == null) {
            this.variableValues[3] = iRubyObject;
            iRubyObject2 = iRubyObject;
        }
        return iRubyObject2;
    }

    public IRubyObject setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(n, iRubyObject, n2 - 1);
        }
        assert (n < this.variableValues.length) : "Setting " + n + " to " + iRubyObject + ", O: " + this;
        this.variableValues[n] = iRubyObject;
        return this.variableValues[n];
    }

    public IRubyObject setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n < this.variableValues.length) : "Setting " + n + " to " + iRubyObject + ", O: " + this;
        this.variableValues[n] = iRubyObject;
        return this.variableValues[n];
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject iRubyObject) {
        assert (0 < this.variableValues.length) : "Setting 0 to " + iRubyObject + ", O: " + this;
        this.variableValues[0] = iRubyObject;
        return this.variableValues[0];
    }

    public IRubyObject setValueOneDepthZero(IRubyObject iRubyObject) {
        assert (1 < this.variableValues.length) : "Setting 1 to " + iRubyObject + ", O: " + this;
        this.variableValues[1] = iRubyObject;
        return this.variableValues[1];
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject iRubyObject) {
        assert (2 < this.variableValues.length) : "Setting 2 to " + iRubyObject + ", O: " + this;
        this.variableValues[2] = iRubyObject;
        return this.variableValues[2];
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject iRubyObject) {
        assert (3 < this.variableValues.length) : "Setting 3 to " + iRubyObject + ", O: " + this;
        this.variableValues[3] = iRubyObject;
        return this.variableValues[3];
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        System.arraycopy(iRubyObjectArray, 0, this.variableValues, 0, n);
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        if (this.staticScope.getRestArg() < 0) {
            IRubyObject[] iRubyObjectArray = new IRubyObject[n];
            System.arraycopy(this.variableValues, 0, iRubyObjectArray, 0, n);
            return iRubyObjectArray;
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(this.variableValues, 0, iRubyObjectArray, 0, n);
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        return iRubyObjectArray;
    }

    public void growIfNeeded() {
        int n;
        int n2 = n = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > n) {
            IRubyObject[] iRubyObjectArray = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (n > 0) {
                System.arraycopy(this.variableValues, 0, iRubyObjectArray, 0, n);
            }
            this.variableValues = iRubyObjectArray;
        }
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        int n = this.staticScope.getNumberOfVariables();
        if (n != 0) {
            String[] stringArray = this.staticScope.getVariables();
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(stringArray[i]).append("=");
                if (this.variableValues[i] == null) {
                    stringBuffer.append("null");
                } else {
                    stringBuffer.append(this.variableValues[i]);
                }
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[n - 1]).append("=");
            assert (this.variableValues.length == stringArray.length) : "V: " + this.variableValues.length + " != N: " + stringArray.length + " for " + stringBuffer;
            if (this.variableValues[n - 1] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.variableValues[n - 1]);
            }
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

