/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class LoadService {
    protected static final String[] sourceSuffixes = new String[]{".class", ".rb"};
    protected static final String[] extensionSuffixes = new String[]{".so", ".jar"};
    protected static final String[] allSuffixes = new String[]{".class", ".rb", ".so", ".jar"};
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|jar)$");
    protected RubyArray loadPath;
    protected RubyArray loadedFeatures;
    protected List loadedFeaturesInternal;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Map<String, IAutoloadMethod> autoloadMap = new HashMap<String, IAutoloadMethod>();
    protected final Ruby runtime;

    public LoadService(Ruby ruby) {
        this.runtime = ruby;
    }

    public void init(List list) {
        String string;
        RubyString rubyString;
        this.loadPath = RubyArray.newArray(this.runtime);
        this.loadedFeatures = RubyArray.newArray(this.runtime);
        this.loadedFeaturesInternal = Collections.synchronizedList(this.loadedFeatures);
        Object object = list.iterator();
        while (object.hasNext()) {
            this.addPath((String)object.next());
        }
        object = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        if (((RubyHash)object).has_key_p(rubyString = this.runtime.newString("RUBYLIB")).isTrue()) {
            string = ((RubyHash)object).op_aref(this.runtime.getCurrentContext(), rubyString).toString();
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                this.addPath(stringArray[i]);
            }
        }
        if (!Ruby.isSecurityRestricted() && (string = this.runtime.getJRubyHome()) != null) {
            char c = '/';
            String string2 = string + c + "lib" + c + "ruby" + c;
            this.addPath(string2 + "site_ruby" + c + Constants.RUBY_MAJOR_VERSION);
            this.addPath(string2 + "site_ruby");
            this.addPath(string2 + Constants.RUBY_MAJOR_VERSION);
            this.addPath(string2 + Constants.RUBY_MAJOR_VERSION + c + "java");
            this.addPath("lib" + c + "ruby" + c + Constants.RUBY_MAJOR_VERSION);
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(string.replace('\\', '/')));
        }
    }

    public void load(String string, boolean bl) {
        if (!this.runtime.getProfile().allowLoad(string)) {
            throw this.runtime.newLoadError("No such file to load -- " + string);
        }
        Library library = null;
        library = this.findLibrary(string, false);
        if (library == null && (library = this.findLibraryWithClassloaders(string)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + string);
        }
        try {
            library.load(this.runtime, bl);
        }
        catch (IOException iOException) {
            if (this.runtime.getDebug().isTrue()) {
                iOException.printStackTrace();
            }
            throw this.runtime.newLoadError("IO error -- " + string);
        }
    }

    public boolean smartLoad(String string) {
        Serializable serializable;
        Object object;
        int n;
        if (string.equals("")) {
            throw this.runtime.newLoadError("No such file to load -- " + string);
        }
        Library library = null;
        String string2 = string;
        String[] stringArray = null;
        if (string.lastIndexOf(46) > string.lastIndexOf(47)) {
            Matcher matcher = null;
            matcher = sourcePattern.matcher(string);
            if (matcher.find()) {
                stringArray = sourceSuffixes;
                string = string.substring(0, matcher.start());
            } else {
                matcher = extensionPattern.matcher(string);
                if (matcher.find()) {
                    stringArray = extensionSuffixes;
                    string = string.substring(0, matcher.start());
                } else {
                    stringArray = allSuffixes;
                }
            }
        } else {
            stringArray = allSuffixes;
        }
        for (n = 0; n < stringArray.length; ++n) {
            library = Ruby.isSecurityRestricted() ? this.findLibrary(string + stringArray[n], false) : this.findLibrary(string + stringArray[n], true);
            if (library == null) continue;
            string2 = string + stringArray[n];
            break;
        }
        if (library == null) {
            for (n = 0; n < stringArray.length; ++n) {
                library = this.findLibraryWithClassloaders(string + stringArray[n]);
                if (library == null) continue;
                string2 = string + stringArray[n];
                break;
            }
        }
        library = this.tryLoadExtension(library, string);
        Script script = null;
        if (library == null) {
            int n2;
            object = string;
            if (((String)(object = ((String)object).replaceFirst("^\\.\\/", ""))).lastIndexOf(".") != -1) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
            }
            if ((n2 = ((String)(object = ((String)object).replace("-", "_minus_").replace('.', '_'))).lastIndexOf(47)) > -1 && n2 < ((String)object).length() - 1 && !Character.isJavaIdentifierStart(((String)object).charAt(n2 + 1))) {
                object = n2 == -1 ? "_" + (String)object : ((String)object).substring(0, n2 + 1) + "_" + ((String)object).substring(n2 + 1);
            }
            object = ((String)object).replace('/', '.');
            try {
                serializable = Class.forName((String)object);
                script = (Script)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                throw this.runtime.newLoadError("no such file to load -- " + string);
            }
        }
        if (this.loadedFeaturesInternal.contains(object = this.runtime.newString(string2))) {
            return false;
        }
        try {
            this.loadedFeaturesInternal.add(object);
            if (script != null) {
                this.runtime.loadScript(script);
                return true;
            }
            library.load(this.runtime, false);
            return true;
        }
        catch (Throwable throwable) {
            if (library instanceof JarredScript && string.endsWith(".jar")) {
                return true;
            }
            this.loadedFeaturesInternal.remove(object);
            if (throwable instanceof RaiseException) {
                throw (RaiseException)throwable;
            }
            if (this.runtime.getDebug().isTrue()) {
                throwable.printStackTrace();
            }
            serializable = this.runtime.newLoadError("IO error -- " + string);
            ((Throwable)serializable).initCause(throwable);
            throw serializable;
        }
    }

    public boolean require(String string) {
        if (!this.runtime.getProfile().allowRequire(string)) {
            throw this.runtime.newLoadError("No such file to load -- " + string);
        }
        return this.smartLoad(string);
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String string) {
        return this.autoloadMap.get(string);
    }

    public void removeAutoLoadFor(String string) {
        this.autoloadMap.remove(string);
    }

    public IRubyObject autoload(String string) {
        IAutoloadMethod iAutoloadMethod = this.autoloadMap.remove(string);
        if (iAutoloadMethod != null) {
            return iAutoloadMethod.load(this.runtime, string);
        }
        return null;
    }

    public void addAutoload(String string, IAutoloadMethod iAutoloadMethod) {
        this.autoloadMap.put(string, iAutoloadMethod);
    }

    public void addBuiltinLibrary(String string, Library library) {
        this.builtinLibraries.put(string, library);
    }

    public void removeBuiltinLibrary(String string) {
        this.builtinLibraries.remove(string);
    }

    public void removeInternalLoadedFeature(String string) {
        this.loadedFeaturesInternal.remove(string);
    }

    private Library findLibrary(String string, boolean bl) {
        if (this.builtinLibraries.containsKey(string)) {
            return this.builtinLibraries.get(string);
        }
        return this.createLibrary(string, this.findFile(string, bl));
    }

    private Library findLibraryWithClassloaders(String string) {
        return this.createLibrary(string, this.findFileInClasspath(string));
    }

    private Library createLibrary(String string, LoadServiceResource loadServiceResource) {
        if (loadServiceResource == null) {
            return null;
        }
        if (string.endsWith(".jar")) {
            return new JarredScript(loadServiceResource);
        }
        if (string.endsWith(".class")) {
            return new JavaCompiledScript(loadServiceResource);
        }
        return new ExternalScript(loadServiceResource, string);
    }

    private LoadServiceResource findFile(String string, boolean bl) {
        String string2;
        Object object;
        if (string.startsWith("jar:")) {
            try {
                return new LoadServiceResource(new URL(string), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw this.runtime.newIOErrorFromException(malformedURLException);
            }
        }
        if (string.startsWith("file:") && string.indexOf("!/") != -1) {
            try {
                object = new JarFile(string.substring(5, string.indexOf("!/")));
                string2 = string.substring(string.indexOf("!/") + 2);
                if (((JarFile)object).getJarEntry(string2) != null) {
                    return new LoadServiceResource(new URL("jar:" + string), string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.loadPath.getList().iterator();
        while (object.hasNext()) {
            String string3;
            Object object2;
            string2 = ((IRubyObject)object.next()).toString();
            if (string2.startsWith("jar:") || string2.endsWith(".jar") || string2.startsWith("file:") && string2.indexOf("!/") != -1) {
                String string4;
                object2 = this.jarFiles.get(string2);
                string3 = string2.startsWith("file:") ? string2.substring(string2.indexOf("!/") + 2) + "/" : "";
                String string5 = string4 = string2.startsWith("file:") ? string2.substring(0, string2.indexOf("!/")) : string2;
                if (null == object2) {
                    try {
                        object2 = string2.startsWith("jar:") ? new JarFile(string2.substring(4)) : (string2.endsWith(".jar") ? new JarFile(string2) : new JarFile(string2.substring(5, string2.indexOf("!/"))));
                        this.jarFiles.put(string2, (JarFile)object2);
                    }
                    catch (ZipException zipException) {
                        if (this.runtime.getInstanceConfig().isVerbose()) {
                            this.runtime.getErr().println("ZipException trying to access " + string2 + ", stack trace follows:");
                            zipException.printStackTrace(this.runtime.getErr());
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        throw this.runtime.newIOErrorFromException(iOException);
                    }
                }
                String string6 = string3 + string;
                if (string3.length() > 0) {
                    try {
                        string6 = new File(string3 + string).getCanonicalPath().substring(new File(".").getCanonicalPath().length() + 1).replaceAll("\\\\", "/");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((JarFile)object2).getJarEntry(string6) != null) {
                    try {
                        if (string2.endsWith(".jar")) {
                            return new LoadServiceResource(new URL("jar:file:" + string2 + "!/" + string6), "/" + string);
                        }
                        if (string2.startsWith("file:")) {
                            return new LoadServiceResource(new URL("jar:" + string4 + "!/" + string6), string2 + "/" + string);
                        }
                        return new LoadServiceResource(new URL("jar:file:" + string2.substring(4) + "!/" + string), string2 + string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw this.runtime.newIOErrorFromException(malformedURLException);
                    }
                }
            }
            try {
                if (Ruby.isSecurityRestricted() || !((File)(object2 = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), string2).getAbsolutePath(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), string)))).isFile()) continue;
                try {
                    string3 = string.startsWith("./") ? string : ((JRubyFile)object2).getPath();
                    return new LoadServiceResource(((File)object2).toURI().toURL(), string3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw this.runtime.newIOErrorFromException(malformedURLException);
                }
            }
            catch (SecurityException securityException) {
            }
        }
        if (bl) {
            try {
                object = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), string));
                if (((File)object).isFile() && ((File)object).isAbsolute()) {
                    try {
                        return new LoadServiceResource(((File)object).toURI().toURL(), string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw this.runtime.newIOErrorFromException(malformedURLException);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private LoadServiceResource findFileInClasspath(String string) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        Object object = this.loadPath.getList().iterator();
        while (object.hasNext()) {
            URL uRL;
            String string2 = object.next().toString();
            if (string2.charAt(0) == '/' || string2.length() > 1 && string2.charAt(1) == ':' || !this.isRequireable(uRL = classLoader.getResource(string2 + "/" + string))) continue;
            return new LoadServiceResource(uRL, uRL.getPath());
        }
        if (string.charAt(0) == '/' || string.length() > 1 && string.charAt(1) == ':') {
            return null;
        }
        object = classLoader.getResource(string);
        return this.isRequireable((URL)object) ? new LoadServiceResource((URL)object, ((URL)object).getPath()) : null;
    }

    private Library tryLoadExtension(Library library, String string) {
        Library library2 = library;
        if ((library == null || library instanceof JarredScript) && !string.equalsIgnoreCase("")) {
            String[] stringArray = string.split("/");
            StringBuilder stringBuilder = new StringBuilder();
            int n = stringArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(stringArray[i].toLowerCase()).append(".");
            }
            try {
                String[] stringArray2 = stringArray[stringArray.length - 1].split("_");
                int n2 = stringArray2.length;
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append(Character.toUpperCase(stringArray2[n].charAt(0))).append(stringArray2[n].substring(1));
                }
                stringBuilder.append("Service");
                String string2 = stringBuilder.toString().replaceAll("^\\.*", "");
                if (library instanceof JarredScript) {
                    this.runtime.getJRubyClassLoader().addURL(((JarredScript)library).getResource().getURL());
                }
                Class clazz = this.runtime.getJavaSupport().loadJavaClassQuiet(string2);
                library = new ClassExtensionLibrary(clazz);
            }
            catch (Exception exception) {
                library = null;
                this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            }
        }
        if (library == null && library2 != null) {
            library = library2;
        }
        return library;
    }

    private boolean isRequireable(URL uRL) {
        if (uRL != null) {
            if (uRL.getProtocol().equals("file") && new File(uRL.getFile()).isDirectory()) {
                return false;
            }
            try {
                uRL.openConnection();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

