/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;

public class JavaCompiledScript
implements Library {
    private final LoadServiceResource resource;

    public JavaCompiledScript(LoadServiceResource loadServiceResource) {
        this.resource = loadServiceResource;
    }

    public void load(Ruby ruby, boolean bl) {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(this.resource.getURL().openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8196];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            JRubyClassLoader jRubyClassLoader = ruby.getJRubyClassLoader();
            ClassReader classReader = new ClassReader(byArray);
            String string = classReader.getClassName().replace('/', '.');
            Class<?> clazz = null;
            try {
                clazz = jRubyClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = jRubyClassLoader.defineClass(string, byArray);
            }
            if (Script.class.isAssignableFrom(clazz)) {
                ((Script)clazz.newInstance()).load(ruby.getCurrentContext(), ruby.getTopSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            }
        }
        catch (IOException iOException) {
            throw ruby.newIOErrorFromException(iOException);
        }
        catch (InstantiationException instantiationException) {
            throw ruby.newLoadError("Error loading compiled script: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ruby.newLoadError("Error loading compiled script: " + illegalAccessException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw ruby.newIOErrorFromException(iOException);
            }
        }
    }
}

