/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.AbstractCompiledBlockCallback;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.FastInvocationCallback;
import org.jruby.runtime.callback.InvocationCallback;
import org.jruby.runtime.callback.ReflectionCallback;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class InvocationCallbackFactory
extends CallbackFactory
implements Opcodes {
    private final Class type;
    final ProtectionDomain protectionDomain;
    protected final JRubyClassLoader classLoader;
    private final String typePath;
    protected final Ruby runtime;
    private static final String SUPER_CLASS = CodegenUtils.p(InvocationCallback.class);
    private static final String FAST_SUPER_CLASS = CodegenUtils.p(FastInvocationCallback.class);
    private static final String CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class, Block.class));
    private static final String FAST_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class));
    private static final String BLOCK_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class));
    private static final String IRUB = CodegenUtils.p(RubyKernel.IRUBY_OBJECT);
    public static final int DISPATCHER_THREADCONTEXT_INDEX = 1;
    public static final int DISPATCHER_SELF_INDEX = 2;
    public static final int DISPATCHER_RUBYMODULE_INDEX = 3;
    public static final int DISPATCHER_METHOD_INDEX = 4;
    public static final int DISPATCHER_NAME_INDEX = 5;
    public static final int DISPATCHER_ARGS_INDEX = 6;
    public static final int DISPATCHER_CALLTYPE_INDEX = 7;
    public static final int DISPATCHER_BLOCK_INDEX = 8;
    public static final int DISPATCHER_RUNTIME_INDEX = 9;
    private static final int METHOD_ARGS_INDEX = 2;

    public InvocationCallbackFactory(Ruby ruby, final Class clazz, ClassLoader classLoader) {
        this.type = clazz;
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
        this.typePath = CodegenUtils.p(clazz);
        this.runtime = ruby;
        SecurityManager securityManager = System.getSecurityManager();
        this.protectionDomain = securityManager == null ? clazz.getProtectionDomain() : AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    @Deprecated
    private Class getReturnClass(String string, Class[] classArray) throws Exception {
        return this.type.getMethod(string, classArray).getReturnType();
    }

    @Deprecated
    private ClassWriter createCtor(String string) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, SUPER_CLASS, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, SUPER_CLASS, "<init>", "()V");
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        return classWriter;
    }

    @Deprecated
    private ClassWriter createCtorDispatcher(String string, Map map) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, CodegenUtils.p(Dispatcher.class), null);
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class)), null, null));
        skinnyMethodAdapter.visitCode();
        skinnyMethodAdapter.visitVarInsn(25, 0);
        skinnyMethodAdapter.visitMethodInsn(183, CodegenUtils.p(Dispatcher.class), "<init>", "()V");
        Label label = new Label();
        skinnyMethodAdapter.visitLineNumber(0, label);
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.ldc(new Integer(MethodIndex.NAMES.size()));
        skinnyMethodAdapter.newarray(8);
        skinnyMethodAdapter.putfield(CodegenUtils.p(Dispatcher.class), "switchTable", CodegenUtils.ci(byte[].class));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(CodegenUtils.p(Dispatcher.class), "switchTable", CodegenUtils.ci(byte[].class));
        for (Integer n : map.keySet()) {
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.ldc(new Integer(MethodIndex.getIndex((String)map.get(n))));
            skinnyMethodAdapter.ldc(n);
            skinnyMethodAdapter.barraystore();
        }
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.visitInsn(177);
        skinnyMethodAdapter.visitMaxs(1, 1);
        skinnyMethodAdapter.visitEnd();
        return classWriter;
    }

    @Deprecated
    private ClassWriter createCtorFast(String string) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, FAST_SUPER_CLASS, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, FAST_SUPER_CLASS, "<init>", "()V");
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private ClassWriter createBlockCtor(String string) throws Exception {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(48, 33, string, null, CodegenUtils.p(AbstractCompiledBlockCallback.class), null);
        classWriter.visitField(18, "$scriptObject", CodegenUtils.ci(Object.class), null, null);
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)), null, null));
        skinnyMethodAdapter.start();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokespecial(CodegenUtils.p(AbstractCompiledBlockCallback.class), "<init>", CodegenUtils.sig(Void.TYPE, Object.class));
        skinnyMethodAdapter.voidreturn();
        skinnyMethodAdapter.end();
        return classWriter;
    }

    private Class tryClass(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    private MethodVisitor startCall(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "call", CALL_SIG, null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.typePath);
        return methodVisitor;
    }

    @Deprecated
    private MethodVisitor startCallS(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "call", CALL_SIG, null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitVarInsn(25, 1);
        this.checkCast(methodVisitor, IRubyObject.class);
        return methodVisitor;
    }

    @Deprecated
    private MethodVisitor startCallFast(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.typePath);
        return methodVisitor;
    }

    @Deprecated
    private MethodVisitor startDispatcher(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "callMethod", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyClass.class, Integer.TYPE, String.class, IRubyObject[].class, CallType.class, Block.class)), null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, this.typePath);
        return methodVisitor;
    }

    @Deprecated
    private MethodVisitor startCallSFast(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, IRUB);
        return methodVisitor;
    }

    private SkinnyMethodAdapter startBlockCall(ClassWriter classWriter) {
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(4113, "call", BLOCK_CALL_SIG, null, null));
        skinnyMethodAdapter.visitCode();
        Label label = new Label();
        skinnyMethodAdapter.visitLineNumber(0, label);
        return skinnyMethodAdapter;
    }

    protected Class endCall(ClassWriter classWriter, MethodVisitor methodVisitor, String string) {
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        return this.classLoader.defineClass(string, byArray, this.protectionDomain);
    }

    @Deprecated
    public Callback getMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_0";
        String string3 = this.typePath + "Callback$" + string + "_0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{Block.class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCall(classWriter);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(1, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.noArguments());
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String string, Class clazz) {
        String string2 = this.type.getName() + "Callback$" + string + "_1";
        String string3 = this.typePath + "Callback$" + string + "_1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz};
                if (clazz2 == null) {
                    classArray = new Class[]{clazz, Block.class};
                    Class clazz3 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCall(classWriter);
                    this.loadArguments(methodVisitor, 2, 1, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz3, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(3, 3);
                    clazz2 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz2.newInstance();
                classArray.setArity(Arity.singleArgument());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String string, Class clazz, Class clazz2) {
        String string2 = this.type.getName() + "Callback$" + string + "_2";
        String string3 = this.typePath + "Callback$" + string + "_2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz3 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2};
                if (clazz3 == null) {
                    classArray = new Class[]{clazz, clazz2, Block.class};
                    Class clazz4 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCall(classWriter);
                    this.loadArguments(methodVisitor, 2, 2, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz4, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(4, 3);
                    clazz3 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz3.newInstance();
                classArray.setArity(Arity.twoArguments());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        String string2 = this.type.getName() + "Callback$" + string + "_3";
        String string3 = this.typePath + "Callback$" + string + "_3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz4 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2, clazz3};
                if (clazz4 == null) {
                    classArray = new Class[]{clazz, clazz2, clazz3, Block.class};
                    Class clazz5 = this.getReturnClass(string, classArray2);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCall(classWriter);
                    this.loadArguments(methodVisitor, 2, 3, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz5, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(5, 3);
                    clazz4 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz4.newInstance();
                classArray.setArity(Arity.fixed(3));
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "S0";
        String string3 = this.typePath + "Callback$" + string + "S0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, Block.class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCallS(classWriter);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(1, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.noArguments());
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String string, Class clazz) {
        String string2 = this.type.getName() + "Callback$" + string + "_S1";
        String string3 = this.typePath + "Callback$" + string + "_S1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz};
                if (clazz2 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz, Block.class};
                    Class clazz3 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCallS(classWriter);
                    this.loadArguments(methodVisitor, 2, 1, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz3, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(3, 3);
                    clazz2 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz2.newInstance();
                classArray.setArity(Arity.singleArgument());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String string, Class clazz, Class clazz2) {
        String string2 = this.type.getName() + "Callback$" + string + "_S2";
        String string3 = this.typePath + "Callback$" + string + "_S2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz3 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2};
                if (clazz3 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz, clazz2, Block.class};
                    Class clazz4 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCallS(classWriter);
                    this.loadArguments(methodVisitor, 2, 2, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz4, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(4, 4);
                    clazz3 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz3.newInstance();
                classArray.setArity(Arity.twoArguments());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getSingletonMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        String string2 = this.type.getName() + "Callback$" + string + "_S3";
        String string3 = this.typePath + "Callback$" + string + "_S3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz4 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2, clazz3};
                if (clazz4 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz, clazz2, clazz3, Block.class};
                    Class clazz5 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCallS(classWriter);
                    this.loadArguments(methodVisitor, 2, 3, classArray2);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz5, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(5, 3);
                    clazz4 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz4.newInstance();
                classArray.setArity(Arity.fixed(3));
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getBlockMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT}, false, true, Arity.fixed(2), false);
    }

    public CompiledBlockCallback getBlockCallback(String string, Object object) {
        Class<?> clazz = object.getClass();
        String string2 = CodegenUtils.p(clazz);
        String string3 = clazz.getName() + "BlockCallback$" + string + "xx1";
        String string4 = string2 + "BlockCallback$" + string + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string3);
            try {
                Object object2;
                if (clazz2 == null) {
                    object2 = this.createBlockCtor(string4);
                    SkinnyMethodAdapter skinnyMethodAdapter = this.startBlockCall((ClassWriter)object2);
                    skinnyMethodAdapter.aload(0);
                    skinnyMethodAdapter.getfield(CodegenUtils.p(AbstractCompiledBlockCallback.class), "$scriptObject", CodegenUtils.ci(Object.class));
                    skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz));
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.aload(2);
                    skinnyMethodAdapter.aload(3);
                    skinnyMethodAdapter.invokevirtual(string2, string, CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class)));
                    skinnyMethodAdapter.areturn();
                    skinnyMethodAdapter.visitMaxs(2, 3);
                    clazz2 = this.endCall((ClassWriter)object2, skinnyMethodAdapter, string3);
                }
                object2 = (CompiledBlockCallback)clazz2.getConstructor(Object.class).newInstance(object);
                return object2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getOptSingletonMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_Sopt";
        String string3 = this.typePath + "Callback$" + string + "_Sopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCallS(classWriter);
                    methodVisitor.visitVarInsn(25, 2);
                    this.checkCast(methodVisitor, IRubyObject[].class);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(2, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.optional());
                classArray.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getOptMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_opt";
        String string3 = this.typePath + "Callback$" + string + "_opt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{IRubyObject[].class, Block.class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtor(string3);
                    MethodVisitor methodVisitor = this.startCall(classWriter);
                    methodVisitor.visitVarInsn(25, 2);
                    this.checkCast(methodVisitor, IRubyObject[].class);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(2, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.optional());
                classArray.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_F0";
        String string3 = this.typePath + "Callback$" + string + "_F0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Object object;
                if (clazz == null) {
                    object = this.getReturnClass(string, new Class[0]);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallFast(classWriter);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig((Class)object, new Class[0]));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(1, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                object = (FastInvocationCallback)clazz.newInstance();
                ((InvocationCallback)object).setArity(Arity.noArguments());
                ((InvocationCallback)object).setJavaName(string);
                return object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String string, Class clazz) {
        String string2 = this.type.getName() + "Callback$" + string + "_F1";
        String string3 = this.typePath + "Callback$" + string + "_F1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz};
                if (clazz2 == null) {
                    classArray = classArray2;
                    Class clazz3 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 1, classArray2);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz3, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(3, 3);
                    clazz2 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (FastInvocationCallback)clazz2.newInstance();
                classArray.setArity(Arity.singleArgument());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String string, Class clazz, Class clazz2) {
        String string2 = this.type.getName() + "Callback$" + string + "_F2";
        String string3 = this.typePath + "Callback$" + string + "_F2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz3 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2};
                if (clazz3 == null) {
                    classArray = classArray2;
                    Class clazz4 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 2, classArray2);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz4, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(4, 3);
                    clazz3 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (FastInvocationCallback)clazz3.newInstance();
                classArray.setArity(Arity.twoArguments());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        String string2 = this.type.getName() + "Callback$" + string + "_F3";
        String string3 = this.typePath + "Callback$" + string + "_F3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz4 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2, clazz3};
                if (clazz4 == null) {
                    classArray = classArray2;
                    Class clazz5 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 3, classArray2);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz5, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(5, 3);
                    clazz4 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (FastInvocationCallback)clazz4.newInstance();
                classArray.setArity(Arity.fixed(3));
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_FS0";
        String string3 = this.typePath + "Callback$" + string + "_FS0";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallSFast(classWriter);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(1, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.noArguments());
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String string, Class clazz) {
        String string2 = this.type.getName() + "Callback$" + string + "_FS1";
        String string3 = this.typePath + "Callback$" + string + "_FS1";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz};
                if (clazz2 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz};
                    Class clazz3 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallSFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 1, classArray2);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz3, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(3, 3);
                    clazz2 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz2.newInstance();
                classArray.setArity(Arity.singleArgument());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String string, Class clazz, Class clazz2) {
        String string2 = this.type.getName() + "Callback$" + string + "_FS2";
        String string3 = this.typePath + "Callback$" + string + "_FS2";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz3 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2};
                if (clazz3 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz, clazz2};
                    Class clazz4 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallSFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 2, classArray2);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz4, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(4, 4);
                    clazz3 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz3.newInstance();
                classArray.setArity(Arity.twoArguments());
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastSingletonMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        String string2 = this.type.getName() + "Callback$" + string + "_FS3";
        String string3 = this.typePath + "Callback$" + string + "_FS3";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz4 = this.tryClass(string2);
            try {
                Class[] classArray;
                Class[] classArray2 = new Class[]{clazz, clazz2, clazz3};
                if (clazz4 == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, clazz, clazz2, clazz3};
                    Class clazz5 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallSFast(classWriter);
                    this.loadArguments(methodVisitor, 2, 3, classArray2);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz5, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(5, 3);
                    clazz4 = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz4.newInstance();
                classArray.setArity(Arity.fixed(3));
                classArray.setArgumentTypes(classArray2);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastOptMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_Fopt";
        String string3 = this.typePath + "Callback$" + string + "_Fopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{IRubyObject[].class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallFast(classWriter);
                    methodVisitor.visitVarInsn(25, 2);
                    this.checkCast(methodVisitor, IRubyObject[].class);
                    methodVisitor.visitMethodInsn(182, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(2, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.optional());
                classArray.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                classArray.setJavaName(string);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Callback getFastOptSingletonMethod(String string) {
        String string2 = this.type.getName() + "Callback$" + string + "_FSopt";
        String string3 = this.typePath + "Callback$" + string + "_FSopt";
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            try {
                Class[] classArray;
                if (clazz == null) {
                    classArray = new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class};
                    Class clazz2 = this.getReturnClass(string, classArray);
                    ClassWriter classWriter = this.createCtorFast(string3);
                    MethodVisitor methodVisitor = this.startCallSFast(classWriter);
                    methodVisitor.visitVarInsn(25, 2);
                    this.checkCast(methodVisitor, IRubyObject[].class);
                    methodVisitor.visitMethodInsn(184, this.typePath, string, CodegenUtils.sig(clazz2, classArray));
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(2, 3);
                    clazz = this.endCall(classWriter, methodVisitor, string2);
                }
                classArray = (Class[])clazz.newInstance();
                classArray.setArity(Arity.optional());
                classArray.setArgumentTypes(InvocationCallback.OPTIONAL_ARGS);
                classArray.setJavaName(string);
                classArray.setSingleton(true);
                return classArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    public Dispatcher createDispatcher(RubyClass rubyClass) {
        String string = this.type.getName() + "Dispatcher$" + rubyClass.getBaseName();
        String string2 = this.typePath + "Dispatcher$" + rubyClass.getBaseName();
        JRubyClassLoader jRubyClassLoader = this.runtime.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string);
            try {
                Object object;
                if (clazz == null) {
                    Label label;
                    Object object22;
                    Cloneable cloneable;
                    object = new HashMap();
                    RubyClass rubyClass2 = rubyClass;
                    while (rubyClass2 != null) {
                        for (Map.Entry object32 : rubyClass2.getMethods().entrySet()) {
                            DynamicMethod n;
                            if (object.containsKey(object32.getKey()) || !((n = (DynamicMethod)object32.getValue()) instanceof JavaMethod) || ((JavaMethod)(cloneable = (JavaMethod)n)).isSingleton() || ((DynamicMethod)((Object)cloneable)).getCallConfig() != CallConfiguration.NO_FRAME_NO_SCOPE || n.getVisibility() != Visibility.PUBLIC) continue;
                            object.put(object32.getKey(), object32.getValue());
                        }
                        for (rubyClass2 = rubyClass2.getSuperClass(); rubyClass2 != null && rubyClass2.isIncluded(); rubyClass2 = rubyClass2.getSuperClass()) {
                        }
                    }
                    Label[] labelArray = new Label[object.size()];
                    Label label2 = new Label();
                    int n = 0;
                    cloneable = new HashMap();
                    ArrayList arrayList = new ArrayList(object.keySet());
                    Collections.sort(arrayList);
                    for (Object object22 : arrayList) {
                        cloneable.put(new Integer(++n), object22);
                        labelArray[n - 1] = new Label();
                    }
                    ClassWriter classWriter = this.createCtorDispatcher(string2, (Map)((Object)cloneable));
                    object22 = new SkinnyMethodAdapter(this.startDispatcher(classWriter));
                    ((SkinnyMethodAdapter)object22).aload(1);
                    ((SkinnyMethodAdapter)object22).invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    ((SkinnyMethodAdapter)object22).astore(9);
                    Label label3 = new Label();
                    Label label4 = new Label();
                    Label label5 = new Label();
                    ((SkinnyMethodAdapter)object22).trycatch(label3, label4, label5, CodegenUtils.p(StackOverflowError.class));
                    ((SkinnyMethodAdapter)object22).label(label3);
                    ((SkinnyMethodAdapter)object22).aload(9);
                    ((SkinnyMethodAdapter)object22).invokevirtual(CodegenUtils.p(Ruby.class), "hasEventHooks", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    ((SkinnyMethodAdapter)object22).ifne(label2);
                    if (n == 0) {
                        ((SkinnyMethodAdapter)object22).go_to(label2);
                    } else {
                        ((SkinnyMethodAdapter)object22).aload(0);
                        ((SkinnyMethodAdapter)object22).getfield(CodegenUtils.p(Dispatcher.class), "switchTable", CodegenUtils.ci(byte[].class));
                        ((SkinnyMethodAdapter)object22).dup();
                        ((SkinnyMethodAdapter)object22).arraylength();
                        ((SkinnyMethodAdapter)object22).iload(4);
                        label = new Label();
                        ((SkinnyMethodAdapter)object22).if_icmpgt(label);
                        ((SkinnyMethodAdapter)object22).pop();
                        ((SkinnyMethodAdapter)object22).go_to(label2);
                        ((SkinnyMethodAdapter)object22).label(label);
                        ((SkinnyMethodAdapter)object22).iload(4);
                        ((SkinnyMethodAdapter)object22).barrayload();
                        ((SkinnyMethodAdapter)object22).tableswitch(1, n, label2, labelArray);
                        for (int i = 0; i < labelArray.length; ++i) {
                            boolean bl;
                            String string3 = (String)cloneable.get(new Integer(i + 1));
                            DynamicMethod dynamicMethod = (DynamicMethod)object.get(string3);
                            ((SkinnyMethodAdapter)object22).label((Label)labelArray[i]);
                            JavaMethod javaMethod = (JavaMethod)dynamicMethod;
                            String string4 = javaMethod.getJavaName();
                            Arity arity = javaMethod.getArity();
                            Class[] classArray = javaMethod.getArgumentTypes();
                            this.checkArity((SkinnyMethodAdapter)object22, arity);
                            if (javaMethod.isSingleton()) {
                                ((SkinnyMethodAdapter)object22).aload(2);
                            }
                            boolean bl2 = bl = classArray.length > 0 && classArray[0] == ThreadContext.class;
                            if (bl) {
                                ((SkinnyMethodAdapter)object22).aload(1);
                            }
                            int n2 = arity.getValue();
                            switch (n2) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.loadArguments((MethodVisitor)object22, 6, n2, classArray, bl);
                                    break;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    ((SkinnyMethodAdapter)object22).aload(6);
                                    this.checkCast((MethodVisitor)object22, IRubyObject[].class);
                                }
                            }
                            Class clazz2 = this.getReturnClass(string4, classArray);
                            String string5 = CodegenUtils.sig(clazz2, classArray);
                            if (classArray.length > 0 && classArray[classArray.length - 1] == Block.class) {
                                ((SkinnyMethodAdapter)object22).aload(8);
                            }
                            ((SkinnyMethodAdapter)object22).invokevirtual(this.typePath, string4, string5);
                            ((SkinnyMethodAdapter)object22).areturn();
                        }
                    }
                    ((SkinnyMethodAdapter)object22).label(label2);
                    label = new Label();
                    this.dispatchWithoutSTI((SkinnyMethodAdapter)object22, label);
                    ((SkinnyMethodAdapter)object22).label(label4);
                    ((SkinnyMethodAdapter)object22).go_to(label);
                    ((SkinnyMethodAdapter)object22).label(label5);
                    ((SkinnyMethodAdapter)object22).aload(9);
                    ((SkinnyMethodAdapter)object22).ldc("stack level too deep");
                    ((SkinnyMethodAdapter)object22).invokevirtual(CodegenUtils.p(Ruby.class), "newSystemStackError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
                    ((SkinnyMethodAdapter)object22).athrow();
                    ((SkinnyMethodAdapter)object22).label(label);
                    ((SkinnyMethodAdapter)object22).areturn();
                    ((SkinnyMethodAdapter)object22).visitMaxs(1, 1);
                    clazz = this.endCall(classWriter, (MethodVisitor)object22, string);
                }
                object = (Dispatcher)clazz.getConstructor(Ruby.class).newInstance(this.runtime);
                return object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    @Deprecated
    private void dispatchWithoutSTI(SkinnyMethodAdapter skinnyMethodAdapter, Label label) {
        skinnyMethodAdapter.aload(3);
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(RubyModule.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
        Label label2 = new Label();
        this.callMethodMissingIfNecessary(skinnyMethodAdapter, label, label2);
        skinnyMethodAdapter.label(label2);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(2);
        skinnyMethodAdapter.aload(3);
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.aload(6);
        skinnyMethodAdapter.aload(8);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class)));
    }

    @Deprecated
    public void callMethodMissingIfNecessary(SkinnyMethodAdapter skinnyMethodAdapter, Label label, Label label2) {
        Label label3 = new Label();
        skinnyMethodAdapter.dup();
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicMethod.class), "isUndefined", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        skinnyMethodAdapter.ifne(label3);
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.ldc("method_missing");
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
        skinnyMethodAdapter.ifne(label2);
        skinnyMethodAdapter.dup();
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        skinnyMethodAdapter.aload(7);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicMethod.class), "isCallableFrom", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class, CallType.class)));
        skinnyMethodAdapter.ifne(label2);
        skinnyMethodAdapter.label(label3);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.swap();
        skinnyMethodAdapter.aload(2);
        skinnyMethodAdapter.swap();
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.aload(6);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        skinnyMethodAdapter.aload(7);
        skinnyMethodAdapter.aload(8);
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "callMethodMissing", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, DynamicMethod.class, String.class, IRubyObject[].class, IRubyObject.class, CallType.class, Block.class)));
        skinnyMethodAdapter.go_to(label);
    }

    @Deprecated
    private void loadArguments(MethodVisitor methodVisitor, int n, int n2, Class[] classArray) {
        this.loadArguments(methodVisitor, n, n2, classArray, false);
    }

    @Deprecated
    private void loadArguments(MethodVisitor methodVisitor, int n, int n2, Class[] classArray, boolean bl) {
        for (int i = 0; i < n2; ++i) {
            this.loadArgument(methodVisitor, n, i, classArray[i + (bl ? 1 : 0)]);
        }
    }

    @Deprecated
    private void loadArgument(MethodVisitor methodVisitor, int n, int n2, Class clazz) {
        methodVisitor.visitVarInsn(25, n);
        methodVisitor.visitLdcInsn(new Integer(n2));
        methodVisitor.visitInsn(50);
        this.checkCast(methodVisitor, clazz);
    }

    @Deprecated
    private void checkCast(MethodVisitor methodVisitor, Class clazz) {
        methodVisitor.visitTypeInsn(192, CodegenUtils.p(clazz));
    }

    @Deprecated
    private void checkArity(SkinnyMethodAdapter skinnyMethodAdapter, Arity arity) {
        if (arity.getValue() >= 0) {
            Label label = new Label();
            skinnyMethodAdapter.aload(6);
            skinnyMethodAdapter.arraylength();
            switch (arity.getValue()) {
                case 3: {
                    skinnyMethodAdapter.iconst_3();
                    break;
                }
                case 2: {
                    skinnyMethodAdapter.iconst_2();
                    break;
                }
                case 1: {
                    skinnyMethodAdapter.iconst_1();
                    break;
                }
                case 0: {
                    skinnyMethodAdapter.iconst_0();
                    break;
                }
                default: {
                    skinnyMethodAdapter.ldc(new Integer(arity.getValue()));
                }
            }
            skinnyMethodAdapter.if_icmpeq(label);
            skinnyMethodAdapter.aload(9);
            skinnyMethodAdapter.aload(6);
            skinnyMethodAdapter.arraylength();
            switch (arity.getValue()) {
                case 3: {
                    skinnyMethodAdapter.iconst_3();
                    break;
                }
                case 2: {
                    skinnyMethodAdapter.iconst_2();
                    break;
                }
                case 1: {
                    skinnyMethodAdapter.iconst_1();
                    break;
                }
                case 0: {
                    skinnyMethodAdapter.iconst_0();
                    break;
                }
                default: {
                    skinnyMethodAdapter.ldc(new Integer(arity.getValue()));
                }
            }
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newArgumentError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE)));
            skinnyMethodAdapter.athrow();
            skinnyMethodAdapter.label(label);
        }
    }
}

