/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends BlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected final StaticScope scope;

    public static Block newCompiledClosure(IRubyObject iRubyObject, Frame frame, Visibility visibility, RubyModule rubyModule, DynamicScope dynamicScope, Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        Binding binding = new Binding(iRubyObject, frame, visibility, rubyModule, dynamicScope);
        CompiledBlock compiledBlock = new CompiledBlock(arity, staticScope, compiledBlockCallback, bl, n);
        return new Block(compiledBlock, binding);
    }

    public static Block newCompiledClosure(ThreadContext threadContext, IRubyObject iRubyObject, Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        return CompiledBlock.newCompiledClosure(iRubyObject, threadContext.getCurrentFrame(), Visibility.PUBLIC, threadContext.getRubyClass(), threadContext.getCurrentScope(), arity, staticScope, compiledBlockCallback, bl, n);
    }

    public static Block newCompiledClosure(ThreadContext threadContext, IRubyObject iRubyObject, BlockBody blockBody) {
        Binding binding = new Binding(iRubyObject, threadContext.getCurrentFrame(), Visibility.PUBLIC, threadContext.getRubyClass(), threadContext.getCurrentScope());
        return new Block(blockBody, binding);
    }

    public static BlockBody newCompiledBlock(Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        return new CompiledBlock(arity, staticScope, compiledBlockCallback, bl, n);
    }

    protected CompiledBlock(Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        super(n);
        this.arity = arity;
        this.scope = staticScope;
        this.callback = compiledBlockCallback;
        this.hasMultipleArgsHead = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        IRubyObject iRubyObject2 = this.prepareSelf(binding);
        IRubyObject iRubyObject3 = this.setupBlockArg(threadContext.getRuntime(), iRubyObject, iRubyObject2);
        Visibility visibility = binding.getFrame().getVisibility();
        Frame frame = this.pre(threadContext, null, binding);
        try {
            IRubyObject iRubyObject4 = this.callback.call(threadContext, iRubyObject2, iRubyObject3);
            return iRubyObject4;
        }
        catch (JumpException.NextJump nextJump) {
            IRubyObject iRubyObject5 = this.handleNextJump(threadContext, nextJump, type);
            return iRubyObject5;
        }
        finally {
            this.post(threadContext, binding, visibility, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        if (rubyModule == null) {
            iRubyObject2 = this.prepareSelf(binding);
        }
        IRubyObject iRubyObject3 = bl ? this.setupBlockArgs(threadContext, iRubyObject, iRubyObject2) : this.setupBlockArg(threadContext.getRuntime(), iRubyObject, iRubyObject2);
        Visibility visibility = binding.getFrame().getVisibility();
        Frame frame = this.pre(threadContext, rubyModule, binding);
        try {
            IRubyObject iRubyObject4 = this.callback.call(threadContext, iRubyObject2, iRubyObject3);
            return iRubyObject4;
        }
        catch (JumpException.NextJump nextJump) {
            IRubyObject iRubyObject5 = this.handleNextJump(threadContext, nextJump, type);
            return iRubyObject5;
        }
        finally {
            this.post(threadContext, binding, visibility, frame);
        }
    }

    private IRubyObject prepareSelf(Binding binding) {
        IRubyObject iRubyObject = binding.getSelf();
        binding.getFrame().setSelf(iRubyObject);
        return iRubyObject;
    }

    private IRubyObject handleNextJump(ThreadContext threadContext, JumpException.NextJump nextJump, Block.Type type) {
        return type == Block.Type.LAMBDA ? threadContext.getRuntime().getNil() : (IRubyObject)nextJump.getValue();
    }

    protected Frame pre(ThreadContext threadContext, RubyModule rubyModule, Binding binding) {
        return threadContext.preYieldSpecificBlock(binding, this.scope, rubyModule);
    }

    protected void post(ThreadContext threadContext, Binding binding, Visibility visibility, Frame frame) {
        binding.getFrame().setVisibility(visibility);
        threadContext.postYield(binding, frame);
    }

    protected IRubyObject setupBlockArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return iRubyObject;
            }
        }
        return this.defaultArgsLogic(threadContext.getRuntime(), iRubyObject);
    }

    private IRubyObject defaultArgsLogic(Ruby ruby, IRubyObject iRubyObject) {
        int n = ArgsUtil.arrayLength(iRubyObject);
        switch (n) {
            case 0: {
                return ruby.getNil();
            }
            case 1: {
                return ((RubyArray)iRubyObject).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby, n);
        return iRubyObject;
    }

    private void blockArgWarning(Ruby ruby, int n) {
        ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + n + " for 1)", new Object[0]);
    }

    protected IRubyObject setupBlockArg(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby, iRubyObject, this.hasMultipleArgsHead);
            }
        }
        return this.defaultArgLogic(ruby, iRubyObject);
    }

    private IRubyObject defaultArgLogic(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject == null) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return ruby.getNil();
        }
        return iRubyObject;
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

