/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NodeType;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class BlockBody
implements JumpTarget {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    protected final int argumentType;
    public static final BlockBody NULL_BODY = new BlockBody(0){

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
            return null;
        }

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
            return null;
        }

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
            return null;
        }

        public StaticScope getStaticScope() {
            return null;
        }

        public Block cloneBlock(Binding binding) {
            return null;
        }

        public Arity arity() {
            return null;
        }
    };

    public BlockBody(int n) {
        this.argumentType = n;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        iRubyObjectArray = this.prepareArgumentsForCall(threadContext, iRubyObjectArray, type);
        return this.yield(threadContext, threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), null, null, true, binding, type);
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyModule var4, boolean var5, Binding var6, Block.Type var7);

    public abstract StaticScope getStaticScope();

    public abstract Block cloneBlock(Binding var1);

    public abstract Arity arity();

    public boolean isGiven() {
        return true;
    }

    public static int asArgumentType(NodeType nodeType) {
        if (nodeType == null) {
            return 0;
        }
        switch (nodeType) {
            case ZEROARGNODE: {
                return 0;
            }
            case MULTIPLEASGNNODE: {
                return 1;
            }
            case SVALUENODE: {
                return 3;
            }
        }
        return 2;
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block.Type type) {
        switch (type) {
            case NORMAL: {
                if (iRubyObjectArray.length == 1 && iRubyObjectArray[0] instanceof RubyArray) {
                    if (this.argumentType != 1 && this.argumentType != 3) break;
                    iRubyObjectArray = ((RubyArray)iRubyObjectArray[0]).toJavaArray();
                    break;
                }
            }
            case PROC: {
                if (iRubyObjectArray.length != 1 || !(iRubyObjectArray[0] instanceof RubyArray) || this.argumentType != 1 || this.argumentType == 3) break;
                iRubyObjectArray = ((RubyArray)iRubyObjectArray[0]).toJavaArray();
                break;
            }
            case LAMBDA: {
                if (this.argumentType == 2 && iRubyObjectArray.length != 1) {
                    threadContext.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + iRubyObjectArray.length + " for " + this.arity().getValue() + ")", new Object[0]);
                    if (iRubyObjectArray.length == 0) {
                        iRubyObjectArray = new IRubyObject[]{threadContext.getRuntime().getNil()};
                        break;
                    }
                    iRubyObjectArray = new IRubyObject[]{threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray)};
                    break;
                }
                this.arity().checkArity(threadContext.getRuntime(), iRubyObjectArray);
            }
        }
        return iRubyObjectArray;
    }

    public static NodeType getArgumentTypeWackyHack(IterNode iterNode) {
        MultipleAsgnNode multipleAsgnNode;
        NodeType nodeType = null;
        if (iterNode.getVarNode() != null && iterNode.getVarNode().nodeId != NodeType.ZEROARGNODE && (nodeType = iterNode.getVarNode().nodeId) == NodeType.MULTIPLEASGNNODE && (multipleAsgnNode = (MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() == null && multipleAsgnNode.getArgsNode() != null) {
            nodeType = NodeType.SVALUENODE;
        }
        return nodeType;
    }
}

