/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean extraPositionInformation = false;
    private boolean isDubyExtensionsEnabled = false;

    public ParserConfiguration(int n, boolean bl) {
        this(n, false, bl);
    }

    public ParserConfiguration(int n, boolean bl, boolean bl2) {
        this.inlineSource = bl2;
        this.lineNumber = n;
        this.extraPositionInformation = bl;
    }

    public ParserConfiguration(int n, boolean bl, boolean bl2, boolean bl3) {
        this.inlineSource = bl2;
        this.lineNumber = n;
        this.extraPositionInformation = bl;
        this.isEvalParse = !bl3;
    }

    public void setEvalParse(boolean bl) {
        this.isEvalParse = bl;
    }

    public void setExtraPositionInformation(boolean bl) {
        this.extraPositionInformation = bl;
    }

    public boolean hasExtraPositionInformation() {
        return this.extraPositionInformation;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope dynamicScope) {
        this.asBlock = true;
        this.existingScope = dynamicScope;
    }

    public DynamicScope getScope() {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new ManyVarsDynamicScope(new LocalStaticScope(null), this.existingScope);
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }

    public boolean isDubyExtensionsEnabled() {
        return this.isDubyExtensionsEnabled;
    }
}

