/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] apparentParameterTypes;
    private final JavaProxyClass declaringProxyClass;

    JavaProxyConstructor(Ruby ruby, JavaProxyClass javaProxyClass, Constructor<?> constructor) {
        super(ruby, ruby.getJavaSupport().getJavaModule().fastGetClass("JavaProxyConstructor"));
        this.declaringProxyClass = javaProxyClass;
        this.proxyConstructor = constructor;
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length - 1;
        this.apparentParameterTypes = new Class[n];
        System.arraycopy(classArray, 0, this.apparentParameterTypes, 0, n);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.apparentParameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    @Override
    public boolean isVarArgs() {
        return this.proxyConstructor.isVarArgs();
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public Object newInstance(Object[] objectArray, JavaProxyInvocationHandler javaProxyInvocationHandler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (objectArray.length != this.apparentParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = javaProxyInvocationHandler;
        return this.proxyConstructor.newInstance(objectArray2);
    }

    public static RubyClass createJavaProxyConstructorClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaProxyConstructor", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineAnnotatedMethods(JavaProxyConstructor.class);
        return rubyClass;
    }

    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getParameterTypes().length);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)object).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    protected String nameOnInspection() {
        return this.getDeclaringClass().nameOnInspection();
    }

    @Override
    public IRubyObject inspect() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.nameOnInspection());
        Class<?>[] classArray = this.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i].getName());
            if (i >= classArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(")>");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod
    public RubyArray argument_types() {
        return this.buildRubyArray(this.getParameterTypes());
    }

    @JRubyMethod(frame=true, rest=true)
    public RubyObject new_instance2(IRubyObject[] iRubyObjectArray, Block block) {
        Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 2, 2);
        final IRubyObject iRubyObject = iRubyObjectArray[0];
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyModule rubyModule = ruby.getJavaSupport().getJavaUtilitiesModule();
        RubyArray rubyArray = (RubyArray)iRubyObjectArray[1];
        Class<?>[] classArray = this.getParameterTypes();
        int n = (int)rubyArray.length().getLongValue();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject2 = rubyArray.aref(this.getRuntime().newFixnum(i));
            objectArray[i] = JavaUtil.convertArgument(this.getRuntime(), Java.ruby_to_java(this, iRubyObject2, Block.NULL_BLOCK), classArray[i]);
        }
        JavaProxyInvocationHandler javaProxyInvocationHandler = new JavaProxyInvocationHandler(){

            public Object invoke(Object object, JavaProxyMethod javaProxyMethod, Object[] objectArray) throws Throwable {
                String string = javaProxyMethod.getName();
                DynamicMethod dynamicMethod = iRubyObject.getMetaClass().searchMethod(string);
                int n = dynamicMethod.getArity().getValue();
                IRubyObject[] iRubyObjectArray = new IRubyObject[objectArray.length];
                int n2 = objectArray.length;
                while (--n2 >= 0) {
                    iRubyObjectArray[n2] = Java.java_to_ruby(rubyModule, JavaObject.wrap(ruby, objectArray[n2]), Block.NULL_BLOCK);
                }
                if (n < 0 || n == iRubyObjectArray.length) {
                    return JavaUtil.convertRubyToJava(RuntimeHelpers.invoke(ruby.getCurrentContext(), iRubyObject, string, iRubyObjectArray, CallType.FUNCTIONAL, Block.NULL_BLOCK), javaProxyMethod.getReturnType());
                }
                RubyClass rubyClass = iRubyObject.getMetaClass().getSuperClass();
                return JavaUtil.convertRubyToJava(RuntimeHelpers.invokeAs(ruby.getCurrentContext(), rubyClass, iRubyObject, string, iRubyObjectArray, CallType.SUPER, Block.NULL_BLOCK), javaProxyMethod.getReturnType());
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(objectArray, javaProxyInvocationHandler));
        }
        catch (Exception exception) {
            RaiseException raiseException = this.getRuntime().newArgumentError("Constructor invocation failed: " + exception.getMessage());
            raiseException.initCause(exception);
            throw raiseException;
        }
    }

    @JRubyMethod(required=1, optional=1, frame=true)
    public RubyObject new_instance(IRubyObject[] iRubyObjectArray, Block block) {
        Object object;
        Object object2;
        RubyProc rubyProc;
        int n = Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 1, 2) - 1;
        if (iRubyObjectArray[n] instanceof RubyProc) {
            rubyProc = (RubyProc)iRubyObjectArray[n];
        } else {
            rubyProc = this.getRuntime().newProc(Block.Type.PROC, block);
            ++n;
        }
        RubyArray rubyArray = (RubyArray)iRubyObjectArray[0];
        Class<?>[] classArray = this.getParameterTypes();
        int n2 = (int)rubyArray.length().getLongValue();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            object2 = rubyArray.aref(this.getRuntime().newFixnum(i));
            objectArray[i] = JavaUtil.convertArgument(this.getRuntime(), Java.ruby_to_java(this, (IRubyObject)object2, Block.NULL_BLOCK), classArray[i]);
        }
        final JavaProxyConstructor javaProxyConstructor = this;
        object2 = new JavaProxyInvocationHandler(){

            public Object invoke(Object object, JavaProxyMethod javaProxyMethod, Object[] objectArray) throws Throwable {
                int n = objectArray == null ? 0 : objectArray.length;
                IRubyObject[] iRubyObjectArray = new IRubyObject[n + 2];
                iRubyObjectArray[0] = JavaObject.wrap(javaProxyConstructor.getRuntime(), object);
                iRubyObjectArray[1] = javaProxyMethod;
                for (int i = 0; i < n; ++i) {
                    iRubyObjectArray[i + 2] = JavaUtil.convertJavaToRuby(JavaProxyConstructor.this.getRuntime(), objectArray[i]);
                }
                IRubyObject iRubyObject = rubyProc.call(JavaProxyConstructor.this.getRuntime().getCurrentContext(), iRubyObjectArray);
                Object object2 = JavaUtil.convertRubyToJava(iRubyObject, javaProxyMethod.getReturnType());
                return object2;
            }
        };
        try {
            object = this.newInstance(objectArray, (JavaProxyInvocationHandler)object2);
        }
        catch (Exception exception) {
            RaiseException raiseException = this.getRuntime().newArgumentError("Constructor invocation failed: " + exception.getMessage());
            raiseException.initCause(exception);
            throw raiseException;
        }
        return JavaObject.wrap(this.getRuntime(), object);
    }
}

